/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.admin.MQAdminExtInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.ClientRemotingProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.FindBrokerResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQAdminImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientAPIImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MQConsumerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullMessageService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalanceService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance$6;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.stat.ConsumerStatsManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MQVersion;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceThread;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.constant.PermName;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.filter.ExpressionType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumerData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.HeartbeatData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ProducerData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.BrokerData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.QueueData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.net.DatagramSocket;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MQClientInstance {
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final InternalLogger log = ClientLogger.getLog();
    private final ClientConfig clientConfig;
    private final int instanceIndex;
    private final String clientId;
    private final long bootTimestamp = System.currentTimeMillis();
    private final ConcurrentMap<String, MQProducerInner> producerTable = new ConcurrentHashMap<String, MQProducerInner>();
    private final ConcurrentMap<String, MQConsumerInner> consumerTable = new ConcurrentHashMap<String, MQConsumerInner>();
    private final ConcurrentMap<String, MQAdminExtInner> adminExtTable = new ConcurrentHashMap<String, MQAdminExtInner>();
    private final NettyClientConfig nettyClientConfig;
    private final MQClientAPIImpl mQClientAPIImpl;
    private final MQAdminImpl mQAdminImpl;
    private final ConcurrentMap<String, TopicRouteData> topicRouteTable = new ConcurrentHashMap<String, TopicRouteData>();
    private final Lock lockNamesrv = new ReentrantLock();
    private final Lock lockHeartbeat = new ReentrantLock();
    private final ConcurrentMap<String, HashMap<Long, String>> brokerAddrTable = new ConcurrentHashMap<String, HashMap<Long, String>>();
    private final ConcurrentMap<String, HashMap<String, Integer>> brokerVersionTable = new ConcurrentHashMap<String, HashMap<String, Integer>>();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new MQClientInstance$1(this));
    private final ClientRemotingProcessor clientRemotingProcessor;
    private final PullMessageService pullMessageService;
    private final RebalanceService rebalanceService;
    private final DefaultMQProducer defaultMQProducer;
    private final ConsumerStatsManager consumerStatsManager;
    private final AtomicLong sendHeartbeatTimesTotal = new AtomicLong(0L);
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private DatagramSocket datagramSocket;
    private Random random = new Random();

    public MQClientInstance(ClientConfig clientConfig, int n2, String string) {
        this(clientConfig, n2, string, null);
    }

    public MQClientInstance(ClientConfig clientConfig, int n2, String string, RPCHook rPCHook) {
        this(clientConfig, n2, string, rPCHook, null, null);
    }

    public MQClientInstance(ClientConfig clientConfig, int n2, String string, RPCHook rPCHook, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        this.clientConfig = clientConfig;
        this.instanceIndex = n2;
        this.nettyClientConfig = new NettyClientConfig();
        this.nettyClientConfig.setClientCallbackExecutorThreads(clientConfig.getClientCallbackExecutorThreads());
        this.nettyClientConfig.setUseTLS(clientConfig.isUseTLS());
        this.clientRemotingProcessor = new ClientRemotingProcessor(this);
        this.mQClientAPIImpl = new MQClientAPIImpl(this.nettyClientConfig, this.clientRemotingProcessor, rPCHook, clientConfig, eventLoopGroup, eventExecutorGroup);
        if (this.clientConfig.getNamesrvAddr() != null) {
            this.mQClientAPIImpl.updateNameServerAddressList(this.clientConfig.getNamesrvAddr());
            this.log.info("user specified name server address: {}", (Object)this.clientConfig.getNamesrvAddr());
        }
        this.clientId = string;
        this.mQAdminImpl = new MQAdminImpl(this);
        this.pullMessageService = new PullMessageService(this);
        this.rebalanceService = new RebalanceService(this);
        this.defaultMQProducer = new DefaultMQProducer("CLIENT_INNER_PRODUCER");
        this.defaultMQProducer.resetClientConfig(clientConfig);
        this.consumerStatsManager = new ConsumerStatsManager(this.scheduledExecutorService);
        this.mQClientAPIImpl.setConsumerStatsManager(this.consumerStatsManager);
        this.log.info("created a new client Instance, FactoryIndex: {} ClinetID: {} {} {}, serializeType={}", new Object[]{this.instanceIndex, this.clientId, this.clientConfig, MQVersion.getVersionDesc(MQVersion.CURRENT_VERSION), RemotingCommand.getSerializeTypeConfigInThisServer()});
    }

    public static TopicPublishInfo topicRouteData2TopicPublishInfo(String string, TopicRouteData topicRouteData) {
        TopicPublishInfo topicPublishInfo = new TopicPublishInfo();
        topicPublishInfo.setTopicRouteData(topicRouteData);
        if (topicRouteData.getOrderTopicConf() != null && topicRouteData.getOrderTopicConf().length() > 0) {
            String[] stringArray = topicRouteData.getOrderTopicConf().split(";");
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = stringArray2[i2];
                String[] stringArray3 = string2.split(":");
                int n3 = Integer.parseInt(stringArray3[1]);
                for (int i3 = 0; i3 < n3; ++i3) {
                    MessageQueue messageQueue = new MessageQueue(string, stringArray3[0], i3);
                    topicPublishInfo.getMessageQueueList().add(messageQueue);
                }
            }
            topicPublishInfo.setOrderTopic(true);
        } else {
            Object object = topicRouteData.getQueueDatas();
            Collections.sort(object);
            object = object.iterator();
            while (object.hasNext()) {
                QueueData queueData = (QueueData)object.next();
                if (!PermName.isWriteable(queueData.getPerm())) continue;
                BrokerData brokerData = null;
                for (Comparable<BrokerData> comparable : topicRouteData.getBrokerDatas()) {
                    if (!comparable.getBrokerName().equals(queueData.getBrokerName())) continue;
                    brokerData = comparable;
                    break;
                }
                if (brokerData == null || !brokerData.getBrokerAddrs().containsKey(0L)) continue;
                for (int i4 = 0; i4 < queueData.getWriteQueueNums(); ++i4) {
                    Comparable<BrokerData> comparable;
                    comparable = new MessageQueue(string, queueData.getBrokerName(), i4);
                    topicPublishInfo.getMessageQueueList().add((MessageQueue)comparable);
                }
            }
            topicPublishInfo.setOrderTopic(false);
        }
        return topicPublishInfo;
    }

    public static Set<MessageQueue> topicRouteData2TopicSubscribeInfo(String string, TopicRouteData iterator) {
        HashSet<MessageQueue> hashSet = new HashSet<MessageQueue>();
        iterator = ((TopicRouteData)((Object)iterator)).getQueueDatas();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            QueueData queueData = iterator.next();
            if (!PermName.isReadable(queueData.getPerm())) continue;
            for (int i2 = 0; i2 < queueData.getReadQueueNums(); ++i2) {
                MessageQueue messageQueue = new MessageQueue(string, queueData.getBrokerName(), i2);
                hashSet.add(messageQueue);
            }
        }
        return hashSet;
    }

    public void start() {
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case CREATE_JUST: {
                    this.serviceState = ServiceState.START_FAILED;
                    if (null == this.clientConfig.getNamesrvAddr()) {
                        this.mQClientAPIImpl.fetchNameServerAddr();
                    }
                    this.mQClientAPIImpl.start();
                    this.startScheduledTask();
                    this.pullMessageService.start();
                    this.rebalanceService.start();
                    this.defaultMQProducer.getDefaultMQProducerImpl().start(false);
                    this.log.info("the client factory [{}] start OK", (Object)this.clientId);
                    this.serviceState = ServiceState.RUNNING;
                    break;
                }
                case RUNNING: {
                    break;
                }
                case SHUTDOWN_ALREADY: {
                    break;
                }
                case START_FAILED: {
                    throw new MQClientException("The Factory object[" + this.getClientId() + "] has been created before, and failed.", null);
                }
            }
            return;
        }
    }

    private void startScheduledTask() {
        if (null == this.clientConfig.getNamesrvAddr()) {
            this.scheduledExecutorService.scheduleAtFixedRate(new MQClientInstance$2(this), 10000L, 120000L, TimeUnit.MILLISECONDS);
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new MQClientInstance$3(this), 10L, this.clientConfig.getPollNameServerInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new MQClientInstance$4(this), 1000L, this.clientConfig.getHeartbeatBrokerInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new MQClientInstance$5(this), 10000L, this.clientConfig.getPersistConsumerOffsetInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new MQClientInstance$6(this), 1L, 1L, TimeUnit.MINUTES);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void updateTopicRouteInfoFromNameServer() {
        Set<SubscriptionData> set;
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner object = (MQConsumerInner)entry.getValue();
            if (object == null) continue;
            set = object.subscriptions();
            if (set != null) {
                set = set.iterator();
                while (set.hasNext()) {
                    SubscriptionData subscriptionData = (SubscriptionData)set.next();
                    hashSet.add(subscriptionData.getTopic());
                }
            }
            if (!(object instanceof DefaultMQPullConsumerImpl) || !((DefaultMQPullConsumerImpl)((Object)(set = (DefaultMQPullConsumerImpl)object))).getDefaultMQPullConsumer().isAutoUpdateTopicRoute()) continue;
            hashSet.addAll(((DefaultMQPullConsumerImpl)((Object)set)).getRebalanceImpl().getSubscriptionInner().keySet());
        }
        for (Map.Entry entry : this.producerTable.entrySet()) {
            MQProducerInner mQProducerInner = (MQProducerInner)entry.getValue();
            if (mQProducerInner == null) continue;
            set = mQProducerInner.getPublishTopicList();
            hashSet.addAll(set);
        }
        for (String string : hashSet) {
            this.updateTopicRouteInfoFromNameServer(string);
        }
    }

    public Map<MessageQueue, Long> parseOffsetTableFromBroker(Map<MessageQueue, Long> object, String string) {
        HashMap<MessageQueue, Long> hashMap = new HashMap<MessageQueue, Long>();
        if (StringUtils.isNotEmpty(string)) {
            for (Map.Entry entry : object.entrySet()) {
                MessageQueue messageQueue = (MessageQueue)entry.getKey();
                messageQueue.setTopic(NamespaceUtil.withoutNamespace(messageQueue.getTopic(), string));
                hashMap.put(messageQueue, (Long)entry.getValue());
            }
        } else {
            hashMap.putAll((Map<MessageQueue, Long>)((Object)object));
        }
        return hashMap;
    }

    private void cleanOfflineBroker() {
        block10: {
            try {
                if (this.lockNamesrv.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                        Iterator iterator = this.brokerAddrTable.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Iterator iterator2 = iterator.next();
                            String string = (String)iterator2.getKey();
                            iterator2 = (HashMap)iterator2.getValue();
                            HashMap hashMap = new HashMap();
                            hashMap.putAll(iterator2);
                            iterator2 = hashMap.entrySet().iterator();
                            while (iterator2.hasNext()) {
                                Object object = iterator2.next();
                                if (this.isBrokerAddrExistInTopicRouteTable((String)(object = (String)object.getValue()))) continue;
                                iterator2.remove();
                                this.log.info("the broker addr[{} {}] is offline, remove it", (Object)string, object);
                            }
                            if (hashMap.isEmpty()) {
                                iterator.remove();
                                this.log.info("the broker[{}] name's host is offline, remove it", (Object)string);
                                continue;
                            }
                            concurrentHashMap.put(string, hashMap);
                        }
                        if (!concurrentHashMap.isEmpty()) {
                            this.brokerAddrTable.putAll(concurrentHashMap);
                        }
                        break block10;
                    }
                    finally {
                        this.lockNamesrv.unlock();
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("cleanOfflineBroker Exception", interruptedException);
            }
        }
    }

    public void checkClientInBroker() {
        Object object = this.consumerTable.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            Set<SubscriptionData> set = ((MQConsumerInner)entry.getValue()).subscriptions();
            if (set == null || set.isEmpty()) {
                return;
            }
            for (SubscriptionData subscriptionData : set) {
                String string;
                if (ExpressionType.isTagType(subscriptionData.getExpressionType()) || (string = this.findBrokerAddrByTopic(subscriptionData.getTopic())) == null) continue;
                try {
                    this.getMQClientAPIImpl().checkClientInBroker(string, (String)entry.getKey(), this.clientId, subscriptionData, 3000L);
                }
                catch (Exception exception) {
                    object = exception;
                    if (exception instanceof MQClientException) {
                        throw (MQClientException)object;
                    }
                    throw new MQClientException("Check client in broker error, maybe because you use " + subscriptionData.getExpressionType() + " to filter message, but server has not been upgraded to support!This error would not affect the launch of consumer, but may has impact on message receiving if you " + "have use the new features which are not supported by server, please check the log!", (Throwable)object);
                }
            }
        }
    }

    public void sendHeartbeatToAllBrokerWithLock() {
        if (this.lockHeartbeat.tryLock()) {
            try {
                this.sendHeartbeatToAllBroker();
                this.uploadFilterClassSource();
            }
            catch (Exception exception) {
                this.log.error("sendHeartbeatToAllBroker exception", exception);
            }
            finally {
                this.lockHeartbeat.unlock();
            }
        } else {
            this.log.warn("lock heartBeat, but failed.");
        }
    }

    private void persistAllConsumerOffset() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner object = (MQConsumerInner)entry.getValue();
            object.persistConsumerOffset();
        }
    }

    public void adjustThreadPool() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner mQConsumerInner = (MQConsumerInner)entry.getValue();
            if (mQConsumerInner == null) continue;
            try {
                if (!(mQConsumerInner instanceof DefaultMQPushConsumerImpl)) continue;
                DefaultMQPushConsumerImpl defaultMQPushConsumerImpl = (DefaultMQPushConsumerImpl)mQConsumerInner;
                defaultMQPushConsumerImpl.adjustThreadPool();
            }
            catch (Exception exception) {}
        }
    }

    public boolean updateTopicRouteInfoFromNameServer(String string) {
        return this.updateTopicRouteInfoFromNameServer(string, false, null);
    }

    private boolean isBrokerAddrExistInTopicRouteTable(String string) {
        for (Map.Entry entry : this.topicRouteTable.entrySet()) {
            TopicRouteData topicRouteData = (TopicRouteData)entry.getValue();
            List<BrokerData> list = topicRouteData.getBrokerDatas();
            for (BrokerData brokerData : list) {
                boolean bl;
                if (brokerData.getBrokerAddrs() == null || !(bl = brokerData.getBrokerAddrs().containsValue(string))) continue;
                return true;
            }
        }
        return false;
    }

    private void sendHeartbeatToAllBroker() {
        HeartbeatData heartbeatData = this.prepareHeartbeatData();
        boolean bl = heartbeatData.getProducerDataSet().isEmpty();
        boolean bl2 = heartbeatData.getConsumerDataSet().isEmpty();
        if (bl && bl2) {
            this.log.warn("sending heartbeat, but no consumer and no producer");
            return;
        }
        if (!this.brokerAddrTable.isEmpty()) {
            long l2 = this.sendHeartbeatTimesTotal.getAndIncrement();
            for (Map.Entry entry : this.brokerAddrTable.entrySet()) {
                String string = (String)entry.getKey();
                HashMap hashMap = (HashMap)entry.getValue();
                if (hashMap == null) continue;
                for (Object object : hashMap.entrySet()) {
                    Long l3 = (Long)object.getKey();
                    if ((object = (String)object.getValue()) == null || bl2 && l3 != 0L) continue;
                    try {
                        int n2 = this.mQClientAPIImpl.sendHeartbeat((String)object, heartbeatData, 3000L);
                        if (!this.brokerVersionTable.containsKey(string)) {
                            this.brokerVersionTable.put(string, new HashMap(4));
                        }
                        ((HashMap)this.brokerVersionTable.get(string)).put(object, n2);
                        if (l2 % 20L != 0L) continue;
                        this.log.info("send heart beat to broker[{} {} {}] success", string, l3, object);
                        this.log.info(heartbeatData.toString());
                    }
                    catch (Exception exception) {
                        if (this.isBrokerInNameServer((String)object)) {
                            this.log.info("send heart beat to broker[{} {} {}] failed", string, l3, object);
                            continue;
                        }
                        this.log.info("send heart beat to broker[{} {} {}] exception, because the broker not up, forget it", string, l3, object);
                    }
                }
            }
        }
    }

    private void uploadFilterClassSource() {
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner object = (MQConsumerInner)entry.getValue();
            if (ConsumeType.CONSUME_PASSIVELY != object.consumeType()) continue;
            Object object2 = object.subscriptions();
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object exception = (SubscriptionData)object2.next();
                if (!((SubscriptionData)exception).isClassFilterMode() || ((SubscriptionData)exception).getFilterClassSource() == null) continue;
                String string = object.groupName();
                String string2 = ((SubscriptionData)exception).getSubString();
                String string3 = ((SubscriptionData)exception).getTopic();
                exception = ((SubscriptionData)exception).getFilterClassSource();
                try {
                    this.uploadFilterClassToAllFilterServer(string, string2, string3, (String)exception);
                }
                catch (Exception exception2) {
                    this.log.error("uploadFilterClassToAllFilterServer Exception", exception2);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateTopicRouteInfoFromNameServer(String string, boolean bl, DefaultMQProducer set) {
        try {
            if (!this.lockNamesrv.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                this.log.warn("updateTopicRouteInfoFromNameServer tryLock timeout {}ms", (Object)3000L);
                return false;
            }
            try {
                TopicRouteData topicRouteData;
                if (bl && set != null) {
                    topicRouteData = this.mQClientAPIImpl.getDefaultTopicRouteInfoFromNameServer(((DefaultMQProducer)((Object)set)).getCreateTopicKey(), 3000L);
                    if (topicRouteData != null) {
                        for (QueueData queueData : topicRouteData.getQueueDatas()) {
                            int n2 = Math.min(((DefaultMQProducer)((Object)set)).getDefaultTopicQueueNums(), queueData.getReadQueueNums());
                            queueData.setReadQueueNums(n2);
                            queueData.setWriteQueueNums(n2);
                        }
                    }
                } else {
                    topicRouteData = this.mQClientAPIImpl.getTopicRouteInfoFromNameServer(string, 3000L);
                }
                if (topicRouteData != null) {
                    boolean bl2;
                    TopicRouteData topicRouteData2 = (TopicRouteData)this.topicRouteTable.get(string);
                    boolean bl3 = this.topicRouteDataIsChange(topicRouteData2, topicRouteData);
                    if (!bl3) {
                        bl2 = this.isNeedUpdateTopicRouteInfo(string);
                    } else {
                        this.log.info("the topic[{}] route info changed, old[{}] ,new[{}]", string, topicRouteData2, topicRouteData);
                    }
                    if (!bl2) return false;
                    TopicRouteData topicRouteData3 = topicRouteData.cloneTopicRouteData();
                    for (BrokerData brokerData : topicRouteData.getBrokerDatas()) {
                        this.brokerAddrTable.put(brokerData.getBrokerName(), brokerData.getBrokerAddrs());
                    }
                    set = MQClientInstance.topicRouteData2TopicPublishInfo(string, topicRouteData);
                    ((TopicPublishInfo)((Object)set)).setHaveTopicRouterInfo(true);
                    for (Map.Entry entry : this.producerTable.entrySet()) {
                        MQProducerInner mQProducerInner = (MQProducerInner)entry.getValue();
                        if (mQProducerInner == null) continue;
                        mQProducerInner.updateTopicPublishInfo(string, (TopicPublishInfo)((Object)set));
                    }
                    set = MQClientInstance.topicRouteData2TopicSubscribeInfo(string, topicRouteData);
                    Iterator iterator = this.consumerTable.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            this.log.info("topicRouteTable.put. Topic = {}, TopicRouteData[{}]", (Object)string, (Object)topicRouteData3);
                            this.topicRouteTable.put(string, topicRouteData3);
                            return true;
                        }
                        Map.Entry entry = iterator.next();
                        MQConsumerInner mQConsumerInner = (MQConsumerInner)entry.getValue();
                        if (mQConsumerInner == null) continue;
                        mQConsumerInner.updateTopicSubscribeInfo(string, set);
                    }
                }
                this.log.warn("updateTopicRouteInfoFromNameServer, getTopicRouteInfoFromNameServer return null, Topic: {}", (Object)string);
                return false;
            }
            catch (Exception exception) {
                if (string.startsWith("%RETRY%")) return false;
                if (string.equals("TBW102")) return false;
                this.log.warn("updateTopicRouteInfoFromNameServer Exception", exception);
                if (!(exception instanceof MQClientException)) return false;
                if (17 != ((MQClientException)exception).getResponseCode()) return false;
                this.cleanNoneRouteTopic(string);
                return false;
            }
            finally {
                this.lockNamesrv.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.warn("updateTopicRouteInfoFromNameServer Exception", interruptedException);
        }
        return false;
    }

    private void cleanNoneRouteTopic(String string) {
        TopicRouteData topicRouteData = (TopicRouteData)this.topicRouteTable.remove(string);
        if (topicRouteData != null) {
            this.log.info("cleanNoneRouteTopic remove topic route data, {}, {}", (Object)string, (Object)topicRouteData);
        }
        for (Map.Entry entry : this.producerTable.entrySet()) {
            MQProducerInner object = (MQProducerInner)entry.getValue();
            if (object == null) continue;
            object.removeTopicPublishInfo(string);
        }
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            MQConsumerInner mQConsumerInner = (MQConsumerInner)entry.getValue();
            if (mQConsumerInner == null) continue;
            mQConsumerInner.removeTopicSubscribeInfo(string);
        }
        this.defaultMQProducer.getDefaultMQProducerImpl().removeTopicPublishInfo(string);
    }

    private HeartbeatData prepareHeartbeatData() {
        Object object;
        Object object2;
        HeartbeatData heartbeatData = new HeartbeatData();
        heartbeatData.setClientID(this.clientId);
        for (Map.Entry entry : this.consumerTable.entrySet()) {
            object2 = (MQConsumerInner)entry.getValue();
            if (object2 == null) continue;
            object = new ConsumerData();
            ((ConsumerData)object).setGroupName(object2.groupName());
            ((ConsumerData)object).setConsumeType(object2.consumeType());
            ((ConsumerData)object).setMessageModel(object2.messageModel());
            ((ConsumerData)object).setConsumeFromWhere(object2.consumeFromWhere());
            ((ConsumerData)object).getSubscriptionDataSet().addAll(object2.subscriptions());
            ((ConsumerData)object).setUnitMode(object2.isUnitMode());
            heartbeatData.getConsumerDataSet().add((ConsumerData)object);
        }
        for (Map.Entry entry : this.producerTable.entrySet()) {
            object2 = (MQProducerInner)entry.getValue();
            if (object2 == null) continue;
            object = new ProducerData();
            ((ProducerData)object).setGroupName((String)entry.getKey());
            heartbeatData.getProducerDataSet().add((ProducerData)object);
        }
        return heartbeatData;
    }

    private boolean isBrokerInNameServer(String string) {
        for (Map.Entry entry : this.topicRouteTable.entrySet()) {
            List<BrokerData> list = ((TopicRouteData)entry.getValue()).getBrokerDatas();
            for (BrokerData brokerData : list) {
                boolean bl = brokerData.getBrokerAddrs().containsValue(string);
                if (!bl) continue;
                return true;
            }
        }
        return false;
    }

    private void uploadFilterClassToAllFilterServer(String string, String string2, String string3, String iterator) {
        byte[] byArray = null;
        int n2 = 0;
        try {
            byArray = ((String)((Object)iterator)).getBytes("UTF-8");
            n2 = UtilAll.crc32(byArray);
        }
        catch (Exception exception) {
            this.log.warn("uploadFilterClassToAllFilterServer Exception, ClassName: {} {}", (Object)string2, (Object)RemotingHelper.exceptionSimpleDesc(exception));
        }
        iterator = (TopicRouteData)this.topicRouteTable.get(string3);
        if (iterator != null && ((TopicRouteData)((Object)iterator)).getFilterServerTable() != null && !((TopicRouteData)((Object)iterator)).getFilterServerTable().isEmpty()) {
            for (Map.Entry<String, List<String>> entry : ((TopicRouteData)((Object)iterator)).getFilterServerTable().entrySet()) {
                List<String> list = entry.getValue();
                for (String string4 : list) {
                    try {
                        this.mQClientAPIImpl.registerMessageFilterClass(string4, string, string3, string2, n2, byArray, 5000L);
                        this.log.info("register message class filter to {} OK, ConsumerGroup: {} Topic: {} ClassName: {}", string4, string, string3, string2);
                    }
                    catch (Exception exception) {
                        this.log.error("uploadFilterClassToAllFilterServer Exception", exception);
                    }
                }
            }
            return;
        }
        this.log.warn("register message class filter failed, because no filter server, ConsumerGroup: {} Topic: {} ClassName: {}", string, string3, string2);
    }

    private boolean topicRouteDataIsChange(TopicRouteData topicRouteData, TopicRouteData topicRouteData2) {
        if (topicRouteData == null || topicRouteData2 == null) {
            return true;
        }
        topicRouteData = topicRouteData.cloneTopicRouteData();
        topicRouteData2 = topicRouteData2.cloneTopicRouteData();
        Collections.sort(topicRouteData.getQueueDatas());
        Collections.sort(topicRouteData.getBrokerDatas());
        Collections.sort(topicRouteData2.getQueueDatas());
        Collections.sort(topicRouteData2.getBrokerDatas());
        return !topicRouteData.equals(topicRouteData2);
    }

    private boolean isNeedUpdateTopicRouteInfo(String string) {
        Object object;
        boolean bl = false;
        Iterator iterator = this.producerTable.entrySet().iterator();
        while (iterator.hasNext() && !bl) {
            object = iterator.next();
            if ((object = (MQProducerInner)object.getValue()) == null) continue;
            bl = object.isPublishTopicNeedUpdate(string);
        }
        iterator = this.consumerTable.entrySet().iterator();
        while (iterator.hasNext() && !bl) {
            object = iterator.next();
            if ((object = (MQConsumerInner)object.getValue()) == null) continue;
            bl = object.isSubscribeTopicNeedUpdate(string);
        }
        return bl;
    }

    public void shutdown() {
        if (!this.consumerTable.isEmpty()) {
            return;
        }
        if (!this.adminExtTable.isEmpty()) {
            return;
        }
        if (this.producerTable.size() > 1) {
            return;
        }
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case CREATE_JUST: {
                    break;
                }
                case RUNNING: {
                    this.defaultMQProducer.getDefaultMQProducerImpl().shutdown(false);
                    this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                    ((ServiceThread)this.pullMessageService).shutdown(true);
                    this.scheduledExecutorService.shutdown();
                    this.mQClientAPIImpl.shutdown();
                    this.rebalanceService.shutdown();
                    if (this.datagramSocket != null) {
                        this.datagramSocket.close();
                        this.datagramSocket = null;
                    }
                    MQClientManager.getInstance().removeClientFactory(this.clientId);
                    this.log.info("the client factory [{}] shutdown OK", (Object)this.clientId);
                }
            }
            return;
        }
    }

    public boolean registerConsumer(String string, MQConsumerInner mQConsumerInner) {
        if (string == null || mQConsumerInner == null) {
            return false;
        }
        if ((mQConsumerInner = this.consumerTable.putIfAbsent(string, mQConsumerInner)) != null) {
            this.log.warn("the consumer group[" + string + "] exist already.");
            return false;
        }
        return true;
    }

    public void unregisterConsumer(String string) {
        this.consumerTable.remove(string);
        this.unregisterClientWithLock(null, string);
    }

    private void unregisterClientWithLock(String string, String string2) {
        try {
            if (this.lockHeartbeat.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                try {
                    this.unregisterClient(string, string2);
                }
                catch (Exception exception) {
                    this.log.error("unregisterClient exception", exception);
                }
                finally {
                    this.lockHeartbeat.unlock();
                }
            } else {
                this.log.warn("lock heartBeat, but failed.");
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.log.warn("unregisterClientWithLock exception", interruptedException);
            return;
        }
    }

    private void unregisterClient(String string, String string2) {
        for (Map.Entry entry : this.brokerAddrTable.entrySet()) {
            String string3 = (String)entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            if (hashMap == null) continue;
            for (Map.Entry mQBrokerException : hashMap.entrySet()) {
                String string4 = (String)mQBrokerException.getValue();
                if (string4 == null) continue;
                try {
                    this.mQClientAPIImpl.unregisterClient(string4, this.clientId, string, string2, 3000L);
                    this.log.info("unregister client[Producer: {} Consumer: {}] from broker[{} {} {}] success", string, string2, string3, mQBrokerException.getKey(), string4);
                }
                catch (RemotingException remotingException) {
                    this.log.error("unregister client exception from broker: " + string4, remotingException);
                }
                catch (InterruptedException interruptedException) {
                    this.log.error("unregister client exception from broker: " + string4, interruptedException);
                }
                catch (MQBrokerException mQBrokerException2) {
                    this.log.error("unregister client exception from broker: " + string4, mQBrokerException2);
                }
            }
        }
    }

    public boolean registerProducer(String string, DefaultMQProducerImpl mQProducerInner) {
        if (string == null || mQProducerInner == null) {
            return false;
        }
        if ((mQProducerInner = this.producerTable.putIfAbsent(string, mQProducerInner)) != null) {
            this.log.warn("the producer group[{}] exist already.", (Object)string);
            return false;
        }
        return true;
    }

    public void unregisterProducer(String string) {
        this.producerTable.remove(string);
        this.unregisterClientWithLock(string, null);
    }

    public boolean registerAdminExt(String string, MQAdminExtInner mQAdminExtInner) {
        if (string == null || mQAdminExtInner == null) {
            return false;
        }
        if ((mQAdminExtInner = this.adminExtTable.putIfAbsent(string, mQAdminExtInner)) != null) {
            this.log.warn("the admin group[{}] exist already.", (Object)string);
            return false;
        }
        return true;
    }

    public void unregisterAdminExt(String string) {
        this.adminExtTable.remove(string);
    }

    public void rebalanceImmediately() {
        this.rebalanceService.wakeup();
    }

    public void doRebalance() {
        for (Map.Entry throwable : this.consumerTable.entrySet()) {
            MQConsumerInner mQConsumerInner = (MQConsumerInner)throwable.getValue();
            if (mQConsumerInner == null) continue;
            try {
                mQConsumerInner.doRebalance();
            }
            catch (Throwable throwable2) {
                this.log.error("doRebalance exception", throwable2);
            }
        }
    }

    public MQProducerInner selectProducer(String string) {
        return (MQProducerInner)this.producerTable.get(string);
    }

    public MQConsumerInner selectConsumer(String string) {
        return (MQConsumerInner)this.consumerTable.get(string);
    }

    /*
     * WARNING - void declaration
     */
    public FindBrokerResult findBrokerAddressInAdmin(String string) {
        Object object2 = null;
        boolean bl = false;
        boolean bl2 = false;
        HashMap hashMap = (HashMap)this.brokerAddrTable.get(string);
        if (hashMap != null && !hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                Long l2 = (Long)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == null) continue;
                bl2 = true;
                if (0L == l2) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
        }
        if (bl2) {
            void var2_3;
            return new FindBrokerResult((String)var2_3, bl, this.findBrokerVersion(string, (String)var2_3));
        }
        return null;
    }

    public String findBrokerAddressInPublish(String object) {
        if ((object = (HashMap)this.brokerAddrTable.get(object)) != null && !((HashMap)object).isEmpty()) {
            return (String)((HashMap)object).get(0L);
        }
        return null;
    }

    public FindBrokerResult findBrokerAddressInSubscribe(String string, long l2, boolean bl) {
        String string2 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        HashMap hashMap = (HashMap)this.brokerAddrTable.get(string);
        if (hashMap != null && !hashMap.isEmpty()) {
            string2 = (String)hashMap.get(l2);
            bl2 = l2 != 0L;
            bl3 = string2 != null;
            if (!bl3 && !bl) {
                Map.Entry entry = hashMap.entrySet().iterator().next();
                string2 = (String)entry.getValue();
                bl2 = (Long)entry.getKey() != 0L;
                bl3 = true;
            }
        }
        if (bl3) {
            return new FindBrokerResult(string2, bl2, this.findBrokerVersion(string, string2));
        }
        return null;
    }

    public int findBrokerVersion(String string, String string2) {
        if (this.brokerVersionTable.containsKey(string) && ((HashMap)this.brokerVersionTable.get(string)).containsKey(string2)) {
            return (Integer)((HashMap)this.brokerVersionTable.get(string)).get(string2);
        }
        return 0;
    }

    public List<String> findConsumerIdList(String string, String string2) {
        String string3 = this.findBrokerAddrByTopic(string);
        if (string3 == null) {
            this.updateTopicRouteInfoFromNameServer(string);
            string3 = this.findBrokerAddrByTopic(string);
        }
        if (string3 != null) {
            try {
                return this.mQClientAPIImpl.getConsumerIdListByGroup(string3, string2, 3000L);
            }
            catch (Exception exception) {
                this.log.warn("getConsumerIdListByGroup exception, " + string3 + " " + string2, exception);
            }
        }
        return null;
    }

    public String findBrokerAddrByTopic(String object) {
        if ((object = (TopicRouteData)this.topicRouteTable.get(object)) != null && !(object = ((TopicRouteData)object).getBrokerDatas()).isEmpty()) {
            int n2 = this.random.nextInt(object.size());
            object = object.get(n2 % object.size());
            return ((BrokerData)object).selectBrokerAddr();
        }
        return null;
    }

    public void resetOffset(String string, String string2, Map<MessageQueue, Long> map) {
        DefaultMQPushConsumerImpl defaultMQPushConsumerImpl = null;
        try {
            Object object;
            Object object2 = (MQConsumerInner)this.consumerTable.get(string2);
            if (object2 == null || !(object2 instanceof DefaultMQPushConsumerImpl)) {
                this.log.info("[reset-offset] consumer dose not exist. group={}", (Object)string2);
                return;
            }
            defaultMQPushConsumerImpl = (DefaultMQPushConsumerImpl)object2;
            defaultMQPushConsumerImpl.suspend();
            object2 = defaultMQPushConsumerImpl.getRebalanceImpl().getProcessQueueTable();
            for (Map.Entry entry : object2.entrySet()) {
                object = (MessageQueue)entry.getKey();
                if (!string.equals(((MessageQueue)object).getTopic()) || !map.containsKey(object)) continue;
                object = (ProcessQueue)entry.getValue();
                ((ProcessQueue)object).setDropped(true);
                ((ProcessQueue)object).clear();
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            Iterator iterator = object2.keySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                entry = (MessageQueue)((Object)iterator.next());
                object = map.get(entry);
                if (!string.equals(((MessageQueue)((Object)entry)).getTopic()) || object == null) continue;
                try {
                    defaultMQPushConsumerImpl.updateConsumeOffset((MessageQueue)((Object)entry), (Long)object);
                    defaultMQPushConsumerImpl.getRebalanceImpl().removeUnnecessaryMessageQueue((MessageQueue)((Object)entry), (ProcessQueue)object2.get(entry));
                    iterator.remove();
                }
                catch (Exception exception) {
                    this.log.warn("reset offset failed. group={}, {}", string2, entry, exception);
                }
            }
            if (defaultMQPushConsumerImpl != null) {
                defaultMQPushConsumerImpl.resume();
                return;
            }
        }
        catch (Throwable throwable) {
            if (defaultMQPushConsumerImpl != null) {
                defaultMQPushConsumerImpl.resume();
            }
            throw throwable;
        }
    }

    public Map<MessageQueue, Long> getConsumerStatus(String string, String object) {
        if ((object = (MQConsumerInner)this.consumerTable.get(object)) != null && object instanceof DefaultMQPushConsumerImpl) {
            object = (DefaultMQPushConsumerImpl)object;
            return ((DefaultMQPushConsumerImpl)object).getOffsetStore().cloneOffsetTable(string);
        }
        if (object != null && object instanceof DefaultMQPullConsumerImpl) {
            object = (DefaultMQPullConsumerImpl)object;
            return ((DefaultMQPullConsumerImpl)object).getOffsetStore().cloneOffsetTable(string);
        }
        return Collections.EMPTY_MAP;
    }

    public TopicRouteData getAnExistTopicRouteData(String string) {
        return (TopicRouteData)this.topicRouteTable.get(string);
    }

    public MQClientAPIImpl getMQClientAPIImpl() {
        return this.mQClientAPIImpl;
    }

    public MQAdminImpl getMQAdminImpl() {
        return this.mQAdminImpl;
    }

    public long getBootTimestamp() {
        return this.bootTimestamp;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public PullMessageService getPullMessageService() {
        return this.pullMessageService;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    public ConcurrentMap<String, TopicRouteData> getTopicRouteTable() {
        return this.topicRouteTable;
    }

    public ConsumeMessageDirectlyResult consumeMessageDirectly(MessageExt object, String object2, String string) {
        if ((object2 = (MQConsumerInner)this.consumerTable.get(object2)) != null) {
            object2 = (DefaultMQPushConsumerImpl)object2;
            object = ((DefaultMQPushConsumerImpl)object2).getConsumeMessageService().consumeMessageDirectly((MessageExt)object, string);
            return object;
        }
        return null;
    }

    public ConsumerRunningInfo consumerRunningInfo(String object) {
        object = (MQConsumerInner)this.consumerTable.get(object);
        ConsumerRunningInfo consumerRunningInfo = object.consumerRunningInfo();
        Object object2 = this.mQClientAPIImpl.getRemotingClient().getNameServerAddressList();
        StringBuilder stringBuilder = new StringBuilder();
        if (object2 != null) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                String string = (String)object2.next();
                stringBuilder.append(string).append(";");
            }
        }
        object2 = stringBuilder.toString();
        consumerRunningInfo.getProperties().put("PROP_NAMESERVER_ADDR", object2);
        consumerRunningInfo.getProperties().put("PROP_CONSUME_TYPE", object.consumeType().name());
        consumerRunningInfo.getProperties().put("PROP_CLIENT_VERSION", MQVersion.getVersionDesc(MQVersion.CURRENT_VERSION));
        return consumerRunningInfo;
    }

    public ConsumerStatsManager getConsumerStatsManager() {
        return this.consumerStatsManager;
    }

    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    static /* synthetic */ MQClientAPIImpl access$000(MQClientInstance mQClientInstance) {
        return mQClientInstance.mQClientAPIImpl;
    }

    static /* synthetic */ InternalLogger access$100(MQClientInstance mQClientInstance) {
        return mQClientInstance.log;
    }

    static /* synthetic */ void access$200(MQClientInstance mQClientInstance) {
        mQClientInstance.cleanOfflineBroker();
    }

    static /* synthetic */ void access$300(MQClientInstance mQClientInstance) {
        mQClientInstance.persistAllConsumerOffset();
    }
}

