/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.QueryResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.Validators;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.CheckForbiddenHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.MQFaultStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageBatch;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageId;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.EndTransactionRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.SendMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultMQProducerImpl
implements MQProducerInner {
    private final InternalLogger log = ClientLogger.getLog();
    private final Random random = new Random();
    private final DefaultMQProducer defaultMQProducer;
    private final ConcurrentMap<String, TopicPublishInfo> topicPublishInfoTable = new ConcurrentHashMap<String, TopicPublishInfo>();
    private final ArrayList<SendMessageHook> sendMessageHookList = new ArrayList();
    private final RPCHook rpcHook;
    protected BlockingQueue<Runnable> checkRequestQueue;
    protected ExecutorService checkExecutor;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mQClientFactory;
    private ArrayList<CheckForbiddenHook> checkForbiddenHookList = new ArrayList();
    private int zipCompressLevel = Integer.parseInt(System.getProperty("rocketmq.message.compressLevel", "5"));
    private MQFaultStrategy mqFaultStrategy = new MQFaultStrategy();
    private EventLoopGroup eventLoopGroup;
    private EventExecutorGroup eventExecutorGroup;

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this(defaultMQProducer, null);
    }

    public DefaultMQProducerImpl(DefaultMQProducer defaultMQProducer, RPCHook rPCHook) {
        this.defaultMQProducer = defaultMQProducer;
        this.rpcHook = rPCHook;
    }

    public void registerCheckForbiddenHook(CheckForbiddenHook checkForbiddenHook) {
        this.checkForbiddenHookList.add(checkForbiddenHook);
        this.log.info("register a new checkForbiddenHook. hookName={}, allHookSize={}", (Object)checkForbiddenHook.hookName(), (Object)this.checkForbiddenHookList.size());
    }

    public void initTransactionEnv() {
        TransactionMQProducer transactionMQProducer = (TransactionMQProducer)this.defaultMQProducer;
        this.checkRequestQueue = new LinkedBlockingQueue<Runnable>(transactionMQProducer.getCheckRequestHoldMax());
        this.checkExecutor = new ThreadPoolExecutor(transactionMQProducer.getCheckThreadPoolMinSize(), transactionMQProducer.getCheckThreadPoolMaxSize(), 60000L, TimeUnit.MILLISECONDS, this.checkRequestQueue);
    }

    public void destroyTransactionEnv() {
        this.checkExecutor.shutdown();
        this.checkRequestQueue.clear();
    }

    public void registerSendMessageHook(SendMessageHook sendMessageHook) {
        this.sendMessageHookList.add(sendMessageHook);
        this.log.info("register sendMessage Hook, {}", (Object)sendMessageHook.hookName());
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean bl) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                if (!this.defaultMQProducer.getProducerGroup().equals("CLIENT_INNER_PRODUCER")) {
                    this.defaultMQProducer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getAndCreateMQClientInstance(this.defaultMQProducer, this.rpcHook, this.eventLoopGroup, this.eventExecutorGroup);
                boolean bl2 = this.mQClientFactory.registerProducer(this.defaultMQProducer.getProducerGroup(), this);
                if (!bl2) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The producer group[" + this.defaultMQProducer.getProducerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
                }
                this.topicPublishInfoTable.put(this.defaultMQProducer.getCreateTopicKey(), new TopicPublishInfo());
                if (bl) {
                    this.mQClientFactory.start();
                }
                this.log.info("the producer [{}] start OK. sendMessageWithVIPChannel={}", (Object)this.defaultMQProducer.getProducerGroup(), (Object)this.defaultMQProducer.isSendMessageWithVIPChannel());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The producer service state not OK, maybe started once, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
            }
        }
        this.mQClientFactory.sendHeartbeatToAllBrokerWithLock();
    }

    private void checkConfig() {
        Validators.checkGroup(this.defaultMQProducer.getProducerGroup());
        if (null == this.defaultMQProducer.getProducerGroup()) {
            throw new MQClientException("producerGroup is null", null);
        }
        if (this.defaultMQProducer.getProducerGroup().equals("DEFAULT_PRODUCER")) {
            throw new MQClientException("producerGroup can not equal DEFAULT_PRODUCER, please specify another one.", null);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean bl) {
        switch (this.serviceState) {
            case CREATE_JUST: {
                return;
            }
            case RUNNING: {
                this.mQClientFactory.unregisterProducer(this.defaultMQProducer.getProducerGroup());
                if (bl) {
                    this.mQClientFactory.shutdown();
                }
                this.log.info("the producer [{}] shutdown OK", (Object)this.defaultMQProducer.getProducerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
            }
        }
    }

    @Override
    public Set<String> getPublishTopicList() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.topicPublishInfoTable.keySet()) {
            hashSet.add(string);
        }
        return hashSet;
    }

    @Override
    public boolean isPublishTopicNeedUpdate(String object) {
        return (object = (TopicPublishInfo)this.topicPublishInfoTable.get(object)) == null || !((TopicPublishInfo)object).ok();
    }

    @Override
    public TransactionCheckListener checkListener() {
        if (this.defaultMQProducer instanceof TransactionMQProducer) {
            TransactionMQProducer transactionMQProducer = (TransactionMQProducer)this.defaultMQProducer;
            return transactionMQProducer.getTransactionCheckListener();
        }
        return null;
    }

    @Override
    public void checkTransactionState(String object, MessageExt messageExt, CheckTransactionStateRequestHeader checkTransactionStateRequestHeader) {
        object = new DefaultMQProducerImpl$1(this, (String)object, messageExt, checkTransactionStateRequestHeader);
        this.checkExecutor.submit((Runnable)object);
    }

    @Override
    public void updateTopicPublishInfo(String object, TopicPublishInfo topicPublishInfo) {
        if (topicPublishInfo != null && object != null && (object = this.topicPublishInfoTable.put((String)object, topicPublishInfo)) != null) {
            this.log.info("updateTopicPublishInfo prev is not null, " + ((TopicPublishInfo)object).toString());
        }
    }

    @Override
    public void removeTopicPublishInfo(String string) {
        if (!this.defaultMQProducer.isAutoCleanTopicRouteNotFound()) {
            return;
        }
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.remove(string);
        if (topicPublishInfo != null) {
            this.log.info("removeTopicPublishInfo {}, {}, {}", this.defaultMQProducer.getProducerGroup(), string, topicPublishInfo);
        }
    }

    @Override
    public boolean isUnitMode() {
        return this.defaultMQProducer.isUnitMode();
    }

    public void createTopic(String string, String string2, int n2) {
        this.createTopic(string, string2, n2, 0);
    }

    public void createTopic(String string, String string2, int n2, int n3) {
        this.makeSureStateOK();
        Validators.checkTopic(string2);
        this.mQClientFactory.getMQAdminImpl().createTopic(string, string2, n2, n3);
    }

    private void makeSureStateOK() {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The producer service state not OK, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
    }

    public List<MessageQueue> fetchPublishMessageQueues(String string) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(string);
    }

    public long searchOffset(MessageQueue messageQueue, long l2) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(messageQueue, l2);
    }

    public long maxOffset(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(messageQueue);
    }

    public long minOffset(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(messageQueue);
    }

    public long earliestMsgStoreTime(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(messageQueue);
    }

    public MessageExt viewMessage(String string) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(string);
    }

    public QueryResult queryMessage(String string, String string2, int n2, long l2, long l3) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(string, string2, n2, l2, l3);
    }

    public MessageExt queryMessageByUniqKey(String string, String string2) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessageByUniqKey(string, string2);
    }

    public void send(Message message, SendCallback sendCallback) {
        this.send(message, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message message, SendCallback sendCallback, long l2) {
        try {
            this.sendDefaultImpl(message, CommunicationMode.ASYNC, sendCallback, l2);
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknown exception", mQBrokerException);
        }
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo topicPublishInfo, String string) {
        return this.mqFaultStrategy.selectOneMessageQueue(topicPublishInfo, string);
    }

    public void updateFaultItem(String string, long l2, boolean bl) {
        this.mqFaultStrategy.updateFaultItem(string, l2, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SendResult sendDefaultImpl(Message message, CommunicationMode communicationMode, SendCallback sendCallback, long l2) {
        Object object;
        int n2;
        Object[] objectArray;
        int n3;
        SendResult sendResult;
        Exception exception;
        Object object2;
        long l3;
        this.makeSureStateOK();
        Validators.checkMessage(message, this.defaultMQProducer);
        long l4 = this.random.nextLong();
        long l5 = l3 = System.currentTimeMillis();
        TopicPublishInfo topicPublishInfo = this.tryToFindTopicPublishInfo(message.getTopic());
        if (topicPublishInfo != null && topicPublishInfo.ok()) {
            object2 = null;
            exception = null;
            sendResult = null;
            n3 = communicationMode == CommunicationMode.SYNC ? 1 + this.defaultMQProducer.getRetryTimesWhenSendFailed() : 1;
            objectArray = new String[n3];
        } else {
            List<String> list = this.getmQClientFactory().getMQClientAPIImpl().getNameServerAddressList();
            if (list == null) throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null).setResponseCode(10004);
            if (!list.isEmpty()) throw new MQClientException("No route info of this topic, " + message.getTopic() + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null).setResponseCode(10005);
            throw new MQClientException("No name server address, please set it." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null).setResponseCode(10004);
        }
        block13: for (n2 = 0; n2 < n3; ++n2) {
            long l6;
            object = object2 == null ? null : ((MessageQueue)object2).getBrokerName();
            if ((object = this.selectOneMessageQueue(topicPublishInfo, (String)object)) == null) break;
            object2 = object;
            objectArray[n2] = ((MessageQueue)object2).getBrokerName();
            try {
                l5 = System.currentTimeMillis();
                sendResult = this.sendKernelImpl(message, (MessageQueue)object2, communicationMode, sendCallback, topicPublishInfo, l2);
                l6 = System.currentTimeMillis();
                this.updateFaultItem(((MessageQueue)object2).getBrokerName(), l6 - l5, false);
                switch (communicationMode) {
                    case ASYNC: {
                        return null;
                    }
                    case ONEWAY: {
                        return null;
                    }
                    case SYNC: {
                        if (sendResult.getSendStatus() == SendStatus.SEND_OK) return sendResult;
                        if (!this.defaultMQProducer.isRetryAnotherBrokerWhenNotStoreOK()) return sendResult;
                        break;
                    }
                }
                continue;
            }
            catch (RemotingException remotingException) {
                l6 = System.currentTimeMillis();
                this.updateFaultItem(((MessageQueue)object2).getBrokerName(), l6 - l5, true);
                this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", l4, l6 - l5, object2), remotingException);
                this.log.warn(message.toString());
                exception = remotingException;
                continue;
            }
            catch (MQClientException mQClientException) {
                l6 = System.currentTimeMillis();
                this.updateFaultItem(((MessageQueue)object2).getBrokerName(), l6 - l5, true);
                this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", l4, l6 - l5, object2), mQClientException);
                this.log.warn(message.toString());
                exception = mQClientException;
                continue;
            }
            catch (MQBrokerException mQBrokerException) {
                l6 = System.currentTimeMillis();
                this.updateFaultItem(((MessageQueue)object2).getBrokerName(), l6 - l5, true);
                this.log.warn(String.format("sendKernelImpl exception, resend at once, InvokeID: %s, RT: %sms, Broker: %s", l4, l6 - l5, object2), mQBrokerException);
                this.log.warn(message.toString());
                exception = mQBrokerException;
                switch (mQBrokerException.getResponseCode()) {
                    case 1: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 204: 
                    case 205: {
                        continue block13;
                    }
                    default: {
                        if (sendResult == null) throw mQBrokerException;
                        return sendResult;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                long l7 = System.currentTimeMillis();
                this.updateFaultItem(((MessageQueue)object2).getBrokerName(), l7 - l5, false);
                this.log.warn(String.format("sendKernelImpl exception, throw exception, InvokeID: %s, RT: %sms, Broker: %s", l4, l7 - l5, object2), interruptedException);
                this.log.warn(message.toString());
                this.log.warn("sendKernelImpl exception", interruptedException);
                this.log.warn(message.toString());
                throw interruptedException;
            }
        }
        if (sendResult != null) {
            return sendResult;
        }
        object = String.format("Send [%d] times, still failed, cost [%d]ms, Topic: %s, BrokersSent: %s", n2, System.currentTimeMillis() - l3, message.getTopic(), Arrays.toString(objectArray));
        object = (String)object + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/");
        object = new MQClientException((String)object, exception);
        if (exception instanceof MQBrokerException) {
            ((MQClientException)object).setResponseCode(((MQBrokerException)exception).getResponseCode());
            throw object;
        }
        if (exception instanceof RemotingConnectException) {
            ((MQClientException)object).setResponseCode(10001);
            throw object;
        }
        if (exception instanceof RemotingTimeoutException) {
            ((MQClientException)object).setResponseCode(10002);
            throw object;
        }
        if (!(exception instanceof MQClientException)) throw object;
        ((MQClientException)object).setResponseCode(10003);
        throw object;
    }

    private TopicPublishInfo tryToFindTopicPublishInfo(String string) {
        TopicPublishInfo topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(string);
        if (topicPublishInfo == null || !topicPublishInfo.ok()) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(string);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(string);
        }
        if (topicPublishInfo != null && (topicPublishInfo.isHaveTopicRouterInfo() || topicPublishInfo.ok())) {
            return topicPublishInfo;
        }
        if (this.defaultMQProducer.isUseDefaultTopicIfNotFound()) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(string, true, this.defaultMQProducer);
            topicPublishInfo = (TopicPublishInfo)this.topicPublishInfoTable.get(string);
            return topicPublishInfo;
        }
        throw new MQClientException(17, "Topic " + string + " not exist!");
    }

    private SendResult sendKernelImpl(Message message, MessageQueue messageQueue, CommunicationMode communicationMode, SendCallback sendCallback, TopicPublishInfo topicPublishInfo, long l2) {
        String string = this.mQClientFactory.findBrokerAddressInPublish(messageQueue.getBrokerName());
        if (string == null) {
            this.tryToFindTopicPublishInfo(messageQueue.getTopic());
            string = this.mQClientFactory.findBrokerAddressInPublish(messageQueue.getBrokerName());
        }
        SendMessageContext sendMessageContext = null;
        if (string != null) {
            string = MixAll.brokerVIPChannel(this.defaultMQProducer.isSendMessageWithVIPChannel(), string);
            byte[] byArray = message.getBody();
            try {
                Object object;
                if (!(message instanceof MessageBatch)) {
                    MessageClientIDSetter.setUniqID(message);
                    if (this.defaultMQProducer.isAddExtendUniqInfo()) {
                        MessageClientIDSetter.setExtendUniqInfo(message, this.defaultMQProducer.getRandomSign());
                    }
                }
                boolean bl = false;
                if (null != this.mQClientFactory.getClientConfig().getNamespace()) {
                    message.setInstanceId(this.mQClientFactory.getClientConfig().getNamespace());
                    bl = true;
                }
                int n2 = 0;
                boolean bl2 = false;
                if (this.tryToCompressMessage(message)) {
                    n2 = 1;
                    bl2 = true;
                }
                if ((object = message.getProperty("TRAN_MSG")) != null && Boolean.parseBoolean((String)object)) {
                    n2 |= 4;
                }
                if (this.hasCheckForbiddenHook()) {
                    object = new CheckForbiddenContext();
                    ((CheckForbiddenContext)object).setNameSrvAddr(this.defaultMQProducer.getNamesrvAddr());
                    ((CheckForbiddenContext)object).setGroup(this.defaultMQProducer.getProducerGroup());
                    ((CheckForbiddenContext)object).setCommunicationMode(communicationMode);
                    ((CheckForbiddenContext)object).setBrokerAddr(string);
                    ((CheckForbiddenContext)object).setMessage(message);
                    ((CheckForbiddenContext)object).setMq(messageQueue);
                    ((CheckForbiddenContext)object).setUnitMode(this.isUnitMode());
                    this.executeCheckForbiddenHook((CheckForbiddenContext)object);
                }
                if (this.hasSendMessageHook()) {
                    sendMessageContext = new SendMessageContext();
                    sendMessageContext.setProducer(this);
                    sendMessageContext.setProducerGroup(this.defaultMQProducer.getProducerGroup());
                    sendMessageContext.setCommunicationMode(communicationMode);
                    sendMessageContext.setBornHost(this.defaultMQProducer.getClientIP());
                    sendMessageContext.setBrokerAddr(string);
                    sendMessageContext.setMessage(message);
                    sendMessageContext.setMq(messageQueue);
                    sendMessageContext.setNamespace(this.defaultMQProducer.getNamespace());
                    object = message.getProperty("TRAN_MSG");
                    if (object != null && ((String)object).equals("true")) {
                        sendMessageContext.setMsgType(MessageType.Trans_Msg_Half);
                    }
                    if (message.getProperty("__STARTDELIVERTIME") != null || message.getProperty("DELAY") != null) {
                        sendMessageContext.setMsgType(MessageType.Delay_Msg);
                    }
                    this.executeSendMessageHookBefore(sendMessageContext);
                }
                object = new SendMessageRequestHeader();
                ((SendMessageRequestHeader)object).setProducerGroup(this.defaultMQProducer.getProducerGroup());
                ((SendMessageRequestHeader)object).setTopic(message.getTopic());
                ((SendMessageRequestHeader)object).setDefaultTopic(this.defaultMQProducer.getCreateTopicKey());
                ((SendMessageRequestHeader)object).setDefaultTopicQueueNums(this.defaultMQProducer.getDefaultTopicQueueNums());
                ((SendMessageRequestHeader)object).setQueueId(messageQueue.getQueueId());
                ((SendMessageRequestHeader)object).setSysFlag(n2);
                ((SendMessageRequestHeader)object).setBornTimestamp(System.currentTimeMillis());
                ((SendMessageRequestHeader)object).setFlag(message.getFlag());
                ((SendMessageRequestHeader)object).setProperties(MessageDecoder.messageProperties2String(message.getProperties()));
                ((SendMessageRequestHeader)object).setReconsumeTimes(0);
                ((SendMessageRequestHeader)object).setUnitMode(this.isUnitMode());
                ((SendMessageRequestHeader)object).setBatch(message instanceof MessageBatch);
                if (((SendMessageRequestHeader)object).getTopic().startsWith("%RETRY%")) {
                    String string2 = MessageAccessor.getReconsumeTime(message);
                    if (string2 != null) {
                        ((SendMessageRequestHeader)object).setReconsumeTimes(Integer.valueOf(string2));
                        MessageAccessor.clearProperty(message, "RECONSUME_TIME");
                    }
                    if ((string2 = MessageAccessor.getMaxReconsumeTimes(message)) != null) {
                        ((SendMessageRequestHeader)object).setMaxReconsumeTimes(Integer.valueOf(string2));
                        MessageAccessor.clearProperty(message, "MAX_RECONSUME_TIMES");
                    }
                }
                Object object2 = null;
                switch (communicationMode) {
                    case ASYNC: {
                        object2 = message;
                        boolean bl3 = false;
                        if (bl2) {
                            object2 = MessageAccessor.cloneMessage(message);
                            bl3 = true;
                            message.setBody(byArray);
                        }
                        if (bl) {
                            if (!bl3) {
                                object2 = MessageAccessor.cloneMessage(message);
                            }
                            Message message2 = message;
                            message2.setTopic(NamespaceUtil.withoutNamespace(message2.getTopic(), this.defaultMQProducer.getNamespace()));
                        }
                        object2 = this.mQClientFactory.getMQClientAPIImpl().sendMessage(string, messageQueue.getBrokerName(), (Message)object2, (SendMessageRequestHeader)object, l2, communicationMode, sendCallback, topicPublishInfo, this.mQClientFactory, this.defaultMQProducer.getRetryTimesWhenSendAsyncFailed(), sendMessageContext, this);
                        break;
                    }
                    case ONEWAY: 
                    case SYNC: {
                        object2 = this.mQClientFactory.getMQClientAPIImpl().sendMessage(string, messageQueue.getBrokerName(), message, (SendMessageRequestHeader)object, l2, communicationMode, sendMessageContext, this);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (this.hasSendMessageHook()) {
                    sendMessageContext.setSendResult((SendResult)object2);
                    this.executeSendMessageHookAfter(sendMessageContext);
                }
                return object2;
            }
            catch (RemotingException remotingException) {
                if (this.hasSendMessageHook()) {
                    sendMessageContext.setException(remotingException);
                    this.executeSendMessageHookAfter(sendMessageContext);
                }
                throw remotingException;
            }
            catch (MQBrokerException mQBrokerException) {
                if (this.hasSendMessageHook()) {
                    sendMessageContext.setException(mQBrokerException);
                    this.executeSendMessageHookAfter(sendMessageContext);
                }
                throw mQBrokerException;
            }
            catch (InterruptedException interruptedException) {
                if (this.hasSendMessageHook()) {
                    sendMessageContext.setException(interruptedException);
                    this.executeSendMessageHookAfter(sendMessageContext);
                }
                throw interruptedException;
            }
            finally {
                message.setBody(byArray);
                Message message3 = message;
                message3.setTopic(NamespaceUtil.withoutNamespace(message3.getTopic(), this.defaultMQProducer.getNamespace()));
            }
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    private boolean tryToCompressMessage(Message message) {
        if (message instanceof MessageBatch) {
            return false;
        }
        byte[] byArray = message.getBody();
        if (byArray != null && byArray.length >= this.defaultMQProducer.getCompressMsgBodyOverHowmuch()) {
            try {
                byArray = UtilAll.compress(byArray, this.zipCompressLevel);
                if (byArray != null) {
                    message.setBody(byArray);
                    return true;
                }
            }
            catch (IOException iOException) {
                this.log.error("tryToCompressMessage exception", iOException);
                this.log.warn(message.toString());
            }
        }
        return false;
    }

    public boolean hasCheckForbiddenHook() {
        return !this.checkForbiddenHookList.isEmpty();
    }

    public void executeCheckForbiddenHook(CheckForbiddenContext checkForbiddenContext) {
        if (this.hasCheckForbiddenHook()) {
            for (CheckForbiddenHook checkForbiddenHook : this.checkForbiddenHookList) {
                checkForbiddenHook.checkForbidden(checkForbiddenContext);
            }
        }
    }

    public boolean hasSendMessageHook() {
        return !this.sendMessageHookList.isEmpty();
    }

    public void executeSendMessageHookBefore(SendMessageContext sendMessageContext) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook sendMessageHook : this.sendMessageHookList) {
                try {
                    sendMessageHook.sendMessageBefore(sendMessageContext);
                }
                catch (Throwable throwable) {
                    this.log.warn("failed to executeSendMessageHookBefore", throwable);
                }
            }
        }
    }

    public void executeSendMessageHookAfter(SendMessageContext sendMessageContext) {
        if (!this.sendMessageHookList.isEmpty()) {
            for (SendMessageHook sendMessageHook : this.sendMessageHookList) {
                try {
                    sendMessageHook.sendMessageAfter(sendMessageContext);
                }
                catch (Throwable throwable) {
                    this.log.warn("failed to executeSendMessageHookAfter", throwable);
                }
            }
        }
    }

    public void sendOneway(Message message) {
        try {
            this.sendDefaultImpl(message, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknown exception", mQBrokerException);
        }
    }

    public SendResult send(Message message, MessageQueue messageQueue) {
        return this.send(message, messageQueue, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message message, MessageQueue messageQueue, long l2) {
        this.makeSureStateOK();
        Validators.checkMessage(message, this.defaultMQProducer);
        if (!message.getTopic().equals(messageQueue.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        return this.sendKernelImpl(message, messageQueue, CommunicationMode.SYNC, null, null, l2);
    }

    public void send(Message message, MessageQueue messageQueue, SendCallback sendCallback) {
        this.send(message, messageQueue, sendCallback, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message message, MessageQueue messageQueue, SendCallback sendCallback, long l2) {
        this.makeSureStateOK();
        Validators.checkMessage(message, this.defaultMQProducer);
        if (!message.getTopic().equals(messageQueue.getTopic())) {
            throw new MQClientException("message's topic not equal mq's topic", null);
        }
        try {
            this.sendKernelImpl(message, messageQueue, CommunicationMode.ASYNC, sendCallback, null, l2);
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknown exception", mQBrokerException);
        }
    }

    public void sendOneway(Message message, MessageQueue messageQueue) {
        this.makeSureStateOK();
        Validators.checkMessage(message, this.defaultMQProducer);
        try {
            this.sendKernelImpl(message, messageQueue, CommunicationMode.ONEWAY, null, null, this.defaultMQProducer.getSendMsgTimeout());
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknown exception", mQBrokerException);
        }
    }

    public SendResult send(Message message, MessageQueueSelector messageQueueSelector, Object object) {
        return this.send(message, messageQueueSelector, object, (long)this.defaultMQProducer.getSendMsgTimeout());
    }

    public SendResult send(Message message, MessageQueueSelector messageQueueSelector, Object object, long l2) {
        return this.sendSelectImpl(message, messageQueueSelector, object, CommunicationMode.SYNC, null, l2);
    }

    private SendResult sendSelectImpl(Message message, MessageQueueSelector object, Object object2, CommunicationMode communicationMode, SendCallback sendCallback, long l2) {
        this.makeSureStateOK();
        Validators.checkMessage(message, this.defaultMQProducer);
        Object object3 = this.tryToFindTopicPublishInfo(message.getTopic());
        if (object3 != null && ((TopicPublishInfo)object3).ok()) {
            try {
                object3 = this.mQClientFactory.getMQAdminImpl().parsePublishMessageQueues(((TopicPublishInfo)object3).getMessageQueueList());
                Message message2 = MessageAccessor.cloneMessage(message);
                String string = NamespaceUtil.withoutNamespace(message2.getTopic(), this.mQClientFactory.getClientConfig().getNamespace());
                message2.setTopic(string);
                object = this.mQClientFactory.getClientConfig().queueWithNamespace(object.select((List<MessageQueue>)object3, message2, object2));
            }
            catch (Throwable throwable) {
                throw new MQClientException("select message queue throwed exception.", throwable);
            }
            if (object != null) {
                return this.sendKernelImpl(message, (MessageQueue)object, communicationMode, sendCallback, null, l2);
            }
            throw new MQClientException("select message queue return null.", null);
        }
        throw new MQClientException("No route info for this topic, " + message.getTopic(), null);
    }

    public void send(Message message, MessageQueueSelector messageQueueSelector, Object object, SendCallback sendCallback) {
        this.send(message, messageQueueSelector, object, sendCallback, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void send(Message message, MessageQueueSelector messageQueueSelector, Object object, SendCallback sendCallback, long l2) {
        try {
            this.sendSelectImpl(message, messageQueueSelector, object, CommunicationMode.ASYNC, sendCallback, l2);
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknownn exception", mQBrokerException);
        }
    }

    public void sendOneway(Message message, MessageQueueSelector messageQueueSelector, Object object) {
        try {
            this.sendSelectImpl(message, messageQueueSelector, object, CommunicationMode.ONEWAY, null, this.defaultMQProducer.getSendMsgTimeout());
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("unknown exception", mQBrokerException);
        }
    }

    public TransactionSendResult sendMessageInTransaction(Message message, LocalTransactionExecuter object, Object object2) {
        SendResult sendResult;
        if (object == null) {
            throw new MQClientException("tranExecutor is null", null);
        }
        Validators.checkMessage(message, this.defaultMQProducer);
        MessageAccessor.putProperty(message, "TRAN_MSG", "true");
        MessageAccessor.putProperty(message, "PGROUP", this.defaultMQProducer.getProducerGroup());
        try {
            sendResult = this.send(message);
        }
        catch (Exception exception) {
            throw new MQClientException("send message Exception", exception);
        }
        LocalTransactionState localTransactionState = LocalTransactionState.UNKNOW;
        Throwable throwable = null;
        switch (sendResult.getSendStatus()) {
            case SEND_OK: {
                try {
                    if (sendResult.getTransactionId() != null) {
                        message.putUserProperty("__transactionId__", sendResult.getTransactionId());
                    }
                    if ((localTransactionState = object.executeLocalTransactionBranch(message, object2)) == null) {
                        localTransactionState = LocalTransactionState.UNKNOW;
                    }
                    if (localTransactionState == LocalTransactionState.COMMIT_MESSAGE) break;
                    this.log.info("executeLocalTransactionBranch return {}", (Object)localTransactionState);
                    this.log.info(message.toString());
                }
                catch (Throwable throwable2) {
                    this.log.info("executeLocalTransactionBranch exception", throwable2);
                    this.log.info(message.toString());
                    throwable = throwable2;
                }
                break;
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
            }
        }
        try {
            this.endTransaction(sendResult, localTransactionState, throwable);
        }
        catch (Exception exception) {
            this.log.warn("local transaction execute " + (Object)((Object)localTransactionState) + ", but end broker transaction failed", exception);
        }
        object = new TransactionSendResult();
        ((SendResult)object).setSendStatus(sendResult.getSendStatus());
        ((SendResult)object).setMessageQueue(sendResult.getMessageQueue());
        ((SendResult)object).setMsgId(sendResult.getMsgId());
        ((SendResult)object).setQueueOffset(sendResult.getQueueOffset());
        ((SendResult)object).setTransactionId(sendResult.getTransactionId());
        ((TransactionSendResult)object).setLocalTransactionState(localTransactionState);
        if (throwable != null) {
            ((TransactionSendResult)object).setErrorMessage("executeLocalTransactionBranch error. " + throwable.getMessage());
            ((TransactionSendResult)object).setRuntimeException(new RuntimeException(throwable));
        }
        return object;
    }

    public SendResult send(Message message) {
        return this.send(message, this.defaultMQProducer.getSendMsgTimeout());
    }

    public void endTransaction(SendResult sendResult, LocalTransactionState localTransactionState, Throwable throwable) {
        MessageId messageId = sendResult.getOffsetMsgId() != null ? MessageDecoder.decodeMessageId(sendResult.getOffsetMsgId()) : MessageDecoder.decodeMessageId(sendResult.getMsgId());
        String string = sendResult.getTransactionId();
        String string2 = this.mQClientFactory.findBrokerAddressInPublish(sendResult.getMessageQueue().getBrokerName());
        EndTransactionRequestHeader endTransactionRequestHeader = new EndTransactionRequestHeader();
        endTransactionRequestHeader.setTransactionId(string);
        endTransactionRequestHeader.setCommitLogOffset(messageId.getOffset());
        switch (localTransactionState) {
            case COMMIT_MESSAGE: {
                endTransactionRequestHeader.setCommitOrRollback(8);
                break;
            }
            case ROLLBACK_MESSAGE: {
                endTransactionRequestHeader.setCommitOrRollback(12);
                break;
            }
            case UNKNOW: {
                endTransactionRequestHeader.setCommitOrRollback(0);
            }
        }
        endTransactionRequestHeader.setProducerGroup(this.defaultMQProducer.getProducerGroup());
        endTransactionRequestHeader.setTranStateTableOffset(sendResult.getQueueOffset());
        endTransactionRequestHeader.setMsgId(sendResult.getMsgId());
        sendResult = throwable != null ? "executeLocalTransactionBranch exception: " + throwable.toString() : null;
        this.mQClientFactory.getMQClientAPIImpl().endTransactionOneway(string2, endTransactionRequestHeader, (String)((Object)sendResult), this.defaultMQProducer.getSendMsgTimeout());
    }

    public void setCallbackExecutor(ExecutorService executorService) {
        this.mQClientFactory.getMQClientAPIImpl().getRemotingClient().setCallbackExecutor(executorService);
    }

    public SendResult send(Message message, long l2) {
        return this.sendDefaultImpl(message, CommunicationMode.SYNC, null, l2);
    }

    public ConcurrentMap<String, TopicPublishInfo> getTopicPublishInfoTable() {
        return this.topicPublishInfoTable;
    }

    public int getZipCompressLevel() {
        return this.zipCompressLevel;
    }

    public void setZipCompressLevel(int n2) {
        this.zipCompressLevel = n2;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public long[] getNotAvailableDuration() {
        return this.mqFaultStrategy.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] lArray) {
        this.mqFaultStrategy.setNotAvailableDuration(lArray);
    }

    public long[] getLatencyMax() {
        return this.mqFaultStrategy.getLatencyMax();
    }

    public void setLatencyMax(long[] lArray) {
        this.mqFaultStrategy.setLatencyMax(lArray);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.mqFaultStrategy.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean bl) {
        this.mqFaultStrategy.setSendLatencyFaultEnable(bl);
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    public void setEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this.eventExecutorGroup = eventExecutorGroup;
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    static /* synthetic */ DefaultMQProducer access$000(DefaultMQProducerImpl defaultMQProducerImpl) {
        return defaultMQProducerImpl.defaultMQProducer;
    }

    static /* synthetic */ InternalLogger access$100(DefaultMQProducerImpl defaultMQProducerImpl) {
        return defaultMQProducerImpl.log;
    }

    static /* synthetic */ MQClientInstance access$200(DefaultMQProducerImpl defaultMQProducerImpl) {
        return defaultMQProducerImpl.mQClientFactory;
    }
}

