/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.TopicPublishInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultTolerance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.latency.LatencyFaultToleranceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;

public class MQFaultStrategy {
    private static final InternalLogger log = ClientLogger.getLog();
    private final LatencyFaultTolerance<String> latencyFaultTolerance = new LatencyFaultToleranceImpl();
    private boolean sendLatencyFaultEnable = false;
    private long[] latencyMax = new long[]{50L, 100L, 550L, 1000L, 2000L, 3000L, 15000L};
    private long[] notAvailableDuration = new long[]{0L, 0L, 30000L, 60000L, 120000L, 180000L, 600000L};

    public long[] getNotAvailableDuration() {
        return this.notAvailableDuration;
    }

    public void setNotAvailableDuration(long[] lArray) {
        this.notAvailableDuration = lArray;
    }

    public long[] getLatencyMax() {
        return this.latencyMax;
    }

    public void setLatencyMax(long[] lArray) {
        this.latencyMax = lArray;
    }

    public boolean isSendLatencyFaultEnable() {
        return this.sendLatencyFaultEnable;
    }

    public void setSendLatencyFaultEnable(boolean bl) {
        this.sendLatencyFaultEnable = bl;
    }

    public MessageQueue selectOneMessageQueue(TopicPublishInfo topicPublishInfo, String string) {
        if (this.sendLatencyFaultEnable) {
            try {
                MessageQueue messageQueue;
                int n2;
                int n3 = topicPublishInfo.getSendWhichQueue().getAndIncrement();
                for (int i2 = 0; i2 < topicPublishInfo.getMessageQueueList().size(); ++i2) {
                    if ((n2 = Math.abs(n3++) % topicPublishInfo.getMessageQueueList().size()) < 0) {
                        n2 = 0;
                    }
                    if (!this.latencyFaultTolerance.isAvailable((messageQueue = topicPublishInfo.getMessageQueueList().get(n2)).getBrokerName()) || string != null && !messageQueue.getBrokerName().equals(string)) continue;
                    return messageQueue;
                }
                String string2 = this.latencyFaultTolerance.pickOneAtLeast();
                n2 = topicPublishInfo.getQueueIdByBroker(string2);
                if (n2 > 0) {
                    messageQueue = topicPublishInfo.selectOneMessageQueue();
                    if (string2 != null) {
                        messageQueue.setBrokerName(string2);
                        messageQueue.setQueueId(topicPublishInfo.getSendWhichQueue().getAndIncrement() % n2);
                    }
                    return messageQueue;
                }
                this.latencyFaultTolerance.remove(string2);
            }
            catch (Exception exception) {
                log.error("Error occurred when selecting message queue", exception);
            }
            return topicPublishInfo.selectOneMessageQueue();
        }
        return topicPublishInfo.selectOneMessageQueue(string);
    }

    public void updateFaultItem(String string, long l2, boolean bl) {
        if (this.sendLatencyFaultEnable) {
            long l3 = this.computeNotAvailableDuration(bl ? 30000L : l2);
            this.latencyFaultTolerance.updateFaultItem(string, l2, l3);
        }
    }

    private long computeNotAvailableDuration(long l2) {
        for (int i2 = this.latencyMax.length - 1; i2 >= 0; --i2) {
            if (l2 < this.latencyMax[i2]) continue;
            return this.notAvailableDuration[i2];
        }
        return 0L;
    }
}

