/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.QueryResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.Validators;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.MessageQueueSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageBatch;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import com.aliyun.openservices.shade.org.apache.commons.lang3.RandomUtils;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class DefaultMQProducer
extends ClientConfig
implements MQProducer {
    protected final transient DefaultMQProducerImpl defaultMQProducerImpl;
    private String producerGroup;
    private String createTopicKey = "TBW102";
    private volatile int defaultTopicQueueNums = 4;
    private int sendMsgTimeout = 3000;
    private int compressMsgBodyOverHowmuch = 4096;
    private int retryTimesWhenSendFailed = 2;
    private int retryTimesWhenSendAsyncFailed = 2;
    private boolean retryAnotherBrokerWhenNotStoreOK = false;
    private int maxMessageSize = 0x400000;
    private int randomSign = RandomUtils.nextInt(0, Integer.MAX_VALUE);
    private boolean addExtendUniqInfo = false;
    private boolean useDefaultTopicIfNotFound = true;

    public DefaultMQProducer() {
        this(null, "DEFAULT_PRODUCER", null);
    }

    public DefaultMQProducer(String string, String string2, RPCHook rPCHook) {
        this.namespace = string;
        this.producerGroup = string2;
        this.defaultMQProducerImpl = new DefaultMQProducerImpl(this, rPCHook);
    }

    public DefaultMQProducer(String string, RPCHook rPCHook) {
        this(null, string, rPCHook);
    }

    public DefaultMQProducer(String string) {
        this(null, string, null);
    }

    public DefaultMQProducer(String string, String string2) {
        this(string, string2, null);
    }

    public DefaultMQProducer(RPCHook rPCHook) {
        this(null, "DEFAULT_PRODUCER", rPCHook);
    }

    @Override
    public void start() {
        DefaultMQProducer defaultMQProducer = this;
        defaultMQProducer.setProducerGroup(defaultMQProducer.withNamespace(this.producerGroup));
        this.defaultMQProducerImpl.start();
    }

    @Override
    public void shutdown() {
        this.defaultMQProducerImpl.shutdown();
    }

    @Override
    public List<MessageQueue> fetchPublishMessageQueues(String string) {
        return this.defaultMQProducerImpl.fetchPublishMessageQueues(this.withNamespace(string));
    }

    @Override
    public SendResult send(Message message) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message);
    }

    @Override
    public SendResult send(Message message, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message, l2);
    }

    @Override
    public void send(Message message, SendCallback sendCallback) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, sendCallback);
    }

    @Override
    public void send(Message message, SendCallback sendCallback, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, sendCallback, l2);
    }

    @Override
    public void sendOneway(Message message) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.sendOneway(message);
    }

    @Override
    public SendResult send(Message message, MessageQueue messageQueue) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message, this.queueWithNamespace(messageQueue));
    }

    @Override
    public SendResult send(Message message, MessageQueue messageQueue, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message, this.queueWithNamespace(messageQueue), l2);
    }

    @Override
    public void send(Message message, MessageQueue messageQueue, SendCallback sendCallback) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, this.queueWithNamespace(messageQueue), sendCallback);
    }

    @Override
    public void send(Message message, MessageQueue messageQueue, SendCallback sendCallback, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, this.queueWithNamespace(messageQueue), sendCallback, l2);
    }

    @Override
    public void sendOneway(Message message, MessageQueue messageQueue) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.sendOneway(message, this.queueWithNamespace(messageQueue));
    }

    @Override
    public SendResult send(Message message, MessageQueueSelector messageQueueSelector, Object object) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message, messageQueueSelector, object);
    }

    @Override
    public SendResult send(Message message, MessageQueueSelector messageQueueSelector, Object object, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        return this.defaultMQProducerImpl.send(message, messageQueueSelector, object, l2);
    }

    @Override
    public void send(Message message, MessageQueueSelector messageQueueSelector, Object object, SendCallback sendCallback) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, messageQueueSelector, object, sendCallback);
    }

    @Override
    public void send(Message message, MessageQueueSelector messageQueueSelector, Object object, SendCallback sendCallback, long l2) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.send(message, messageQueueSelector, object, sendCallback, l2);
    }

    @Override
    public void sendOneway(Message message, MessageQueueSelector messageQueueSelector, Object object) {
        message.setTopic(this.withNamespace(message.getTopic()));
        this.defaultMQProducerImpl.sendOneway(message, messageQueueSelector, object);
    }

    @Override
    public TransactionSendResult sendMessageInTransaction(Message message, LocalTransactionExecuter localTransactionExecuter, Object object) {
        throw new RuntimeException("sendMessageInTransaction not implement, please use TransactionMQProducer class");
    }

    @Override
    public void createTopic(String string, String string2, int n2) {
        this.createTopic(string, this.withNamespace(string2), n2, 0);
    }

    @Override
    public void createTopic(String string, String string2, int n2, int n3) {
        this.defaultMQProducerImpl.createTopic(string, this.withNamespace(string2), n2, n3);
    }

    @Override
    public long searchOffset(MessageQueue messageQueue, long l2) {
        return this.defaultMQProducerImpl.searchOffset(this.queueWithNamespace(messageQueue), l2);
    }

    @Override
    public long maxOffset(MessageQueue messageQueue) {
        return this.defaultMQProducerImpl.maxOffset(this.queueWithNamespace(messageQueue));
    }

    @Override
    public long minOffset(MessageQueue messageQueue) {
        return this.defaultMQProducerImpl.minOffset(this.queueWithNamespace(messageQueue));
    }

    @Override
    public long earliestMsgStoreTime(MessageQueue messageQueue) {
        return this.defaultMQProducerImpl.earliestMsgStoreTime(this.queueWithNamespace(messageQueue));
    }

    @Override
    public MessageExt viewMessage(String string) {
        return this.defaultMQProducerImpl.viewMessage(string);
    }

    @Override
    public QueryResult queryMessage(String string, String string2, int n2, long l2, long l3) {
        return this.defaultMQProducerImpl.queryMessage(this.withNamespace(string), string2, n2, l2, l3);
    }

    @Override
    public MessageExt viewMessage(String string, String string2) {
        try {
            MessageDecoder.decodeMessageId(string2);
            return this.viewMessage(string2);
        }
        catch (Exception exception) {
            return this.defaultMQProducerImpl.queryMessageByUniqKey(this.withNamespace(string), string2);
        }
    }

    @Override
    public SendResult send(Collection<Message> collection) {
        return this.defaultMQProducerImpl.send(this.batch(collection));
    }

    @Override
    public SendResult send(Collection<Message> collection, long l2) {
        return this.defaultMQProducerImpl.send((Message)this.batch(collection), l2);
    }

    @Override
    public void send(Collection<Message> collection, SendCallback sendCallback, long l2) {
        this.defaultMQProducerImpl.send((Message)this.batch(collection), sendCallback, l2);
    }

    @Override
    public SendResult send(Collection<Message> collection, MessageQueue messageQueue) {
        return this.defaultMQProducerImpl.send((Message)this.batch(collection), messageQueue);
    }

    @Override
    public SendResult send(Collection<Message> collection, MessageQueue messageQueue, long l2) {
        return this.defaultMQProducerImpl.send((Message)this.batch(collection), messageQueue, l2);
    }

    @Override
    public void send(Collection<Message> collection, MessageQueue messageQueue, SendCallback sendCallback, long l2) {
        this.defaultMQProducerImpl.send((Message)this.batch(collection), messageQueue, sendCallback, l2);
    }

    public void setCallbackExecutor(ExecutorService executorService) {
        this.defaultMQProducerImpl.setCallbackExecutor(executorService);
    }

    private MessageBatch batch(Collection<Message> iterable) {
        try {
            iterable = MessageBatch.generateFromList(iterable);
            for (Message message : iterable) {
                Validators.checkMessage(message, this);
                MessageClientIDSetter.setUniqID(message);
                if (this.isAddExtendUniqInfo()) {
                    MessageClientIDSetter.setExtendUniqInfo(message, this.getRandomSign());
                }
                message.setTopic(this.withNamespace(message.getTopic()));
            }
            Iterable<Message> iterable2 = iterable;
            ((Message)((Object)iterable2)).setBody(((MessageBatch)iterable2).encode());
        }
        catch (Exception exception) {
            throw new MQClientException("Failed to initiate the MessageBatch", exception);
        }
        ((Message)((Object)iterable)).setTopic(this.withNamespace(((Message)((Object)iterable)).getTopic()));
        return iterable;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String string) {
        this.producerGroup = string;
    }

    public String getCreateTopicKey() {
        return this.createTopicKey;
    }

    public void setCreateTopicKey(String string) {
        this.createTopicKey = string;
    }

    public int getSendMsgTimeout() {
        return this.sendMsgTimeout;
    }

    public void setSendMsgTimeout(int n2) {
        this.sendMsgTimeout = n2;
    }

    public int getCompressMsgBodyOverHowmuch() {
        return this.compressMsgBodyOverHowmuch;
    }

    public void setCompressMsgBodyOverHowmuch(int n2) {
        this.compressMsgBodyOverHowmuch = n2;
    }

    public DefaultMQProducerImpl getDefaultMQProducerImpl() {
        return this.defaultMQProducerImpl;
    }

    public boolean isRetryAnotherBrokerWhenNotStoreOK() {
        return this.retryAnotherBrokerWhenNotStoreOK;
    }

    public void setRetryAnotherBrokerWhenNotStoreOK(boolean bl) {
        this.retryAnotherBrokerWhenNotStoreOK = bl;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int n2) {
        this.maxMessageSize = n2;
    }

    public int getRandomSign() {
        return this.randomSign;
    }

    public void setRandomSign(int n2) {
        this.randomSign = n2;
    }

    public boolean isAddExtendUniqInfo() {
        return this.addExtendUniqInfo;
    }

    public void setAddExtendUniqInfo(boolean bl) {
        this.addExtendUniqInfo = bl;
    }

    public int getDefaultTopicQueueNums() {
        return this.defaultTopicQueueNums;
    }

    public void setDefaultTopicQueueNums(int n2) {
        this.defaultTopicQueueNums = n2;
    }

    public int getRetryTimesWhenSendFailed() {
        return this.retryTimesWhenSendFailed;
    }

    public void setRetryTimesWhenSendFailed(int n2) {
        this.retryTimesWhenSendFailed = n2;
    }

    public boolean isSendMessageWithVIPChannel() {
        return this.isVipChannelEnabled();
    }

    public void setSendMessageWithVIPChannel(boolean bl) {
        this.setVipChannelEnabled(bl);
    }

    public long[] getNotAvailableDuration() {
        return this.defaultMQProducerImpl.getNotAvailableDuration();
    }

    public void setNotAvailableDuration(long[] lArray) {
        this.defaultMQProducerImpl.setNotAvailableDuration(lArray);
    }

    public long[] getLatencyMax() {
        return this.defaultMQProducerImpl.getLatencyMax();
    }

    public void setLatencyMax(long[] lArray) {
        this.defaultMQProducerImpl.setLatencyMax(lArray);
    }

    public boolean isSendLatencyFaultEnable() {
        return this.defaultMQProducerImpl.isSendLatencyFaultEnable();
    }

    public void setSendLatencyFaultEnable(boolean bl) {
        this.defaultMQProducerImpl.setSendLatencyFaultEnable(bl);
    }

    public int getRetryTimesWhenSendAsyncFailed() {
        return this.retryTimesWhenSendAsyncFailed;
    }

    public void setRetryTimesWhenSendAsyncFailed(int n2) {
        this.retryTimesWhenSendAsyncFailed = n2;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.defaultMQProducerImpl.getEventLoopGroup();
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        if (this.defaultMQProducerImpl.getServiceState() != ServiceState.CREATE_JUST) {
            throw new MQClientException("The producer service state not OK", null);
        }
        this.defaultMQProducerImpl.setEventLoopGroup(eventLoopGroup);
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.defaultMQProducerImpl.getEventExecutorGroup();
    }

    public void setEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        if (this.defaultMQProducerImpl.getServiceState() != ServiceState.CREATE_JUST) {
            throw new MQClientException("The producer service state not OK", null);
        }
        this.defaultMQProducerImpl.setEventExecutorGroup(eventExecutorGroup);
    }

    public boolean isUseDefaultTopicIfNotFound() {
        return this.useDefaultTopicIfNotFound;
    }

    public void setUseDefaultTopicIfNotFound(boolean bl) {
        this.useDefaultTopicIfNotFound = bl;
    }
}

