/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionExecuter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;

public class TransactionMQProducer
extends DefaultMQProducer {
    private TransactionCheckListener transactionCheckListener;
    private int checkThreadPoolMinSize = 1;
    private int checkThreadPoolMaxSize = 1;
    private int checkRequestHoldMax = 2000;

    public TransactionMQProducer() {
    }

    public TransactionMQProducer(String string) {
        this(null, string, null);
    }

    public TransactionMQProducer(String string, String string2) {
        this(string, string2, null);
    }

    public TransactionMQProducer(String string, RPCHook rPCHook) {
        this(null, string, rPCHook);
    }

    public TransactionMQProducer(String string, String string2, RPCHook rPCHook) {
        super(string, string2, rPCHook);
    }

    @Override
    public void start() {
        this.defaultMQProducerImpl.initTransactionEnv();
        super.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.defaultMQProducerImpl.destroyTransactionEnv();
    }

    @Override
    public TransactionSendResult sendMessageInTransaction(Message message, LocalTransactionExecuter localTransactionExecuter, Object object) {
        if (this.transactionCheckListener == null) {
            throw new MQClientException("localTransactionBranchCheckListener is null", null);
        }
        message.setTopic(NamespaceUtil.wrapNamespace(this.getNamespace(), message.getTopic()));
        return this.defaultMQProducerImpl.sendMessageInTransaction(message, localTransactionExecuter, object);
    }

    public TransactionCheckListener getTransactionCheckListener() {
        return this.transactionCheckListener;
    }

    public void setTransactionCheckListener(TransactionCheckListener transactionCheckListener) {
        this.transactionCheckListener = transactionCheckListener;
    }

    public int getCheckThreadPoolMinSize() {
        return this.checkThreadPoolMinSize;
    }

    public void setCheckThreadPoolMinSize(int n2) {
        this.checkThreadPoolMinSize = n2;
    }

    public int getCheckThreadPoolMaxSize() {
        return this.checkThreadPoolMaxSize;
    }

    public void setCheckThreadPoolMaxSize(int n2) {
        this.checkThreadPoolMaxSize = n2;
    }

    public int getCheckRequestHoldMax() {
        return this.checkRequestHoldMax;
    }

    public void setCheckRequestHoldMax(int n2) {
        this.checkRequestHoldMax = n2;
    }
}

