/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.stat;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumeStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.concurrent.ScheduledExecutorService;

public class ConsumerStatsManager {
    private static final InternalLogger log = ClientLogger.getLog();
    private static final String TOPIC_AND_GROUP_CONSUME_OK_TPS = "CONSUME_OK_TPS";
    private static final String TOPIC_AND_GROUP_CONSUME_FAILED_TPS = "CONSUME_FAILED_TPS";
    private static final String TOPIC_AND_GROUP_CONSUME_RT = "CONSUME_RT";
    private static final String TOPIC_AND_GROUP_PULL_TPS = "PULL_TPS";
    private static final String TOPIC_AND_GROUP_PULL_RT = "PULL_RT";
    private final StatsItemSet topicAndGroupConsumeOKTPS;
    private final StatsItemSet topicAndGroupConsumeRT;
    private final StatsItemSet topicAndGroupConsumeFailedTPS;
    private final StatsItemSet topicAndGroupPullTPS;
    private final StatsItemSet topicAndGroupPullRT;
    private static final String POP_RT = "POP_RT";
    private static final String POP_QPS = "POP_QPS";
    private static final String PEEK_RT = "PEEK_RT";
    private static final String PEEK_QPS = "PEEK_QPS";
    private static final String ACK_RT = "ACK_RT";
    private static final String ACK_QPS = "ACK_QPS";
    private static final String CHANGE_RT = "CHANGE_RT";
    private static final String CHANGE_QPS = "CHANGE_QPS";
    private final StatsItemSet popRT;
    private final StatsItemSet popQPS;
    private final StatsItemSet peekRT;
    private final StatsItemSet peekQPS;
    private final StatsItemSet ackRT;
    private final StatsItemSet ackQPS;
    private final StatsItemSet changeRT;
    private final StatsItemSet changeQPS;

    public ConsumerStatsManager(ScheduledExecutorService scheduledExecutorService) {
        this.topicAndGroupConsumeOKTPS = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_OK_TPS, scheduledExecutorService, log);
        this.topicAndGroupConsumeRT = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_RT, scheduledExecutorService, log);
        this.topicAndGroupConsumeFailedTPS = new StatsItemSet(TOPIC_AND_GROUP_CONSUME_FAILED_TPS, scheduledExecutorService, log);
        this.topicAndGroupPullTPS = new StatsItemSet(TOPIC_AND_GROUP_PULL_TPS, scheduledExecutorService, log);
        this.topicAndGroupPullRT = new StatsItemSet(TOPIC_AND_GROUP_PULL_RT, scheduledExecutorService, log);
        this.popRT = new StatsItemSet(POP_RT, scheduledExecutorService, log);
        this.popQPS = new StatsItemSet(POP_QPS, scheduledExecutorService, log);
        this.peekRT = new StatsItemSet(PEEK_RT, scheduledExecutorService, log);
        this.peekQPS = new StatsItemSet(PEEK_QPS, scheduledExecutorService, log);
        this.ackRT = new StatsItemSet(ACK_RT, scheduledExecutorService, log);
        this.ackQPS = new StatsItemSet(ACK_QPS, scheduledExecutorService, log);
        this.changeRT = new StatsItemSet(CHANGE_RT, scheduledExecutorService, log);
        this.changeQPS = new StatsItemSet(CHANGE_QPS, scheduledExecutorService, log);
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void incPullRT(String string, String string2, long l2) {
        this.topicAndGroupPullRT.addValue(string2 + "@" + string, (int)l2, 1);
    }

    public void incPullTPS(String string, String string2, long l2) {
        this.topicAndGroupPullTPS.addValue(string2 + "@" + string, (int)l2, 1);
    }

    public void incConsumeRT(String string, String string2, long l2) {
        this.topicAndGroupConsumeRT.addValue(string2 + "@" + string, (int)l2, 1);
    }

    public void incConsumeOKTPS(String string, String string2, long l2) {
        this.topicAndGroupConsumeOKTPS.addValue(string2 + "@" + string, (int)l2, 1);
    }

    public void incConsumeFailedTPS(String string, String string2, long l2) {
        this.topicAndGroupConsumeFailedTPS.addValue(string2 + "@" + string, (int)l2, 1);
    }

    public ConsumeStatus consumeStatus(String string, String string2) {
        ConsumeStatus consumeStatus = new ConsumeStatus();
        StatsSnapshot statsSnapshot = this.getPullRT(string, string2);
        if (statsSnapshot != null) {
            consumeStatus.setPullRT(statsSnapshot.getAvgpt());
        }
        if ((statsSnapshot = this.getPullTPS(string, string2)) != null) {
            consumeStatus.setPullTPS(statsSnapshot.getTps());
        }
        if ((statsSnapshot = this.getConsumeRT(string, string2)) != null) {
            consumeStatus.setConsumeRT(statsSnapshot.getAvgpt());
        }
        if ((statsSnapshot = this.getConsumeOKTPS(string, string2)) != null) {
            consumeStatus.setConsumeOKTPS(statsSnapshot.getTps());
        }
        if ((statsSnapshot = this.getConsumeFailedTPS(string, string2)) != null) {
            consumeStatus.setConsumeFailedTPS(statsSnapshot.getTps());
        }
        if ((statsSnapshot = this.topicAndGroupConsumeFailedTPS.getStatsDataInHour(string2 + "@" + string)) != null) {
            consumeStatus.setConsumeFailedMsgs(statsSnapshot.getSum());
        }
        return consumeStatus;
    }

    private StatsSnapshot getPullRT(String string, String string2) {
        return this.topicAndGroupPullRT.getStatsDataInMinute(string2 + "@" + string);
    }

    private StatsSnapshot getPullTPS(String string, String string2) {
        return this.topicAndGroupPullTPS.getStatsDataInMinute(string2 + "@" + string);
    }

    private StatsSnapshot getConsumeRT(String string, String string2) {
        StatsSnapshot statsSnapshot = this.topicAndGroupConsumeRT.getStatsDataInMinute(string2 + "@" + string);
        if (0L == statsSnapshot.getSum()) {
            statsSnapshot = this.topicAndGroupConsumeRT.getStatsDataInHour(string2 + "@" + string);
        }
        return statsSnapshot;
    }

    private StatsSnapshot getConsumeOKTPS(String string, String string2) {
        return this.topicAndGroupConsumeOKTPS.getStatsDataInMinute(string2 + "@" + string);
    }

    private StatsSnapshot getConsumeFailedTPS(String string, String string2) {
        return this.topicAndGroupConsumeFailedTPS.getStatsDataInMinute(string2 + "@" + string);
    }

    public void incPopRT(String string, String string2, String string3, long l2) {
        this.popRT.addValue(string + ":" + string3 + "@" + string2, (int)l2, 1);
    }

    public void incPopQPS(String string, String string2, String string3) {
        this.popQPS.addValue(string + ":" + string3 + "@" + string2, 1, 1);
    }

    public void incPeekRT(String string, String string2, String string3, long l2) {
        this.peekRT.addValue(string + ":" + string3 + "@" + string2, (int)l2, 1);
    }

    public void incPeekQPS(String string, String string2, String string3) {
        this.peekQPS.addValue(string + ":" + string3 + "@" + string2, 1, 1);
    }

    public void incAckRT(String string, String string2, String string3, long l2) {
        this.ackRT.addValue(string + ":" + string3 + "@" + string2, (int)l2, 1);
    }

    public void incAckQPS(String string, String string2, String string3) {
        this.ackQPS.addValue(string + ":" + string3 + "@" + string2, 1, 1);
    }

    public void incChangeRT(String string, String string2, String string3, long l2) {
        this.changeRT.addValue(string + ":" + string3 + "@" + string2, (int)l2, 1);
    }

    public void incChangeQPS(String string, String string2, String string3) {
        this.changeQPS.addValue(string + ":" + string3 + "@" + string2, 1, 1);
    }
}

