/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.DataVersion;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Configuration {
    private final InternalLogger log;
    private List<Object> configObjectList = new ArrayList<Object>(4);
    private String storePath;
    private boolean storePathFromConfig = false;
    private Object storePathObject;
    private Field storePathField;
    private DataVersion dataVersion = new DataVersion();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Properties allConfigs = new Properties();

    public Configuration(InternalLogger internalLogger) {
        this.log = internalLogger;
    }

    public Configuration(InternalLogger objectArray, Object ... objectArray2) {
        this.log = objectArray;
        if (objectArray2 == null || objectArray2.length == 0) {
            return;
        }
        objectArray = objectArray2;
        int n2 = objectArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            this.registerConfig(object);
        }
    }

    public Configuration(InternalLogger internalLogger, String string, Object ... objectArray) {
        this(internalLogger, objectArray);
        this.storePath = string;
    }

    public Configuration registerConfig(Object object) {
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                Properties properties = MixAll.object2Properties(object);
                this.merge(properties, this.allConfigs);
                this.configObjectList.add(object);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("registerConfig lock error");
        }
        return this;
    }

    public Configuration registerConfig(Properties properties) {
        if (properties == null) {
            return this;
        }
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.merge(properties, this.allConfigs);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("register lock error. {}" + properties);
        }
        return this;
    }

    public void setStorePathFromConfig(Object object, String string) {
        assert (object != null);
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.storePathFromConfig = true;
                this.storePathObject = object;
                this.storePathField = object.getClass().getDeclaredField(string);
                assert (this.storePathField != null && !Modifier.isStatic(this.storePathField.getModifiers()));
                this.storePathField.setAccessible(true);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("setStorePathFromConfig lock error");
        }
    }

    private String getStorePath() {
        String string = null;
        try {
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                string = this.storePath;
                if (this.storePathFromConfig) {
                    try {
                        string = (String)this.storePathField.get(this.storePathObject);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.log.error("getStorePath error, ", illegalAccessException);
                    }
                }
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("getStorePath lock error");
        }
        return string;
    }

    public void setStorePath(String string) {
        this.storePath = string;
    }

    public void update(Properties properties) {
        try {
            this.readWriteLock.writeLock().lockInterruptibly();
            try {
                this.mergeIfExist(properties, this.allConfigs);
                for (Object object : this.configObjectList) {
                    MixAll.properties2Object(properties, object);
                }
                this.dataVersion.nextVersion();
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("update lock error, {}", (Object)properties);
            return;
        }
        this.persist();
    }

    public void persist() {
        try {
            this.readWriteLock.readLock().lockInterruptibly();
            try {
                String string = this.getAllConfigsInternal();
                MixAll.string2File(string, this.getStorePath());
            }
            catch (IOException iOException) {
                this.log.error("persist string2File error, ", iOException);
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("persist lock error");
        }
    }

    public String getAllConfigsFormatString() {
        this.readWriteLock.readLock().lockInterruptibly();
        try {
            String string = this.getAllConfigsInternal();
            this.readWriteLock.readLock().unlock();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                this.log.error("getAllConfigsFormatString lock error");
                return null;
            }
        }
    }

    public String getDataVersionJson() {
        return this.dataVersion.toJson();
    }

    public Properties getAllConfigs() {
        this.readWriteLock.readLock().lockInterruptibly();
        try {
            Properties properties = this.allConfigs;
            this.readWriteLock.readLock().unlock();
            return properties;
        }
        catch (Throwable throwable) {
            try {
                this.readWriteLock.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                this.log.error("getAllConfigs lock error");
                return null;
            }
        }
    }

    private String getAllConfigsInternal() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : this.configObjectList) {
            Properties properties = MixAll.object2Properties(object);
            if (properties != null) {
                this.merge(properties, this.allConfigs);
                continue;
            }
            this.log.warn("getAllConfigsInternal object2Properties is null, {}", (Object)object.getClass());
        }
        stringBuilder.append(MixAll.properties2String(this.allConfigs));
        return stringBuilder.toString();
    }

    private void merge(Properties properties, Properties properties2) {
        for (Object object : properties.keySet()) {
            Object object2 = properties.get(object);
            Object object3 = properties2.get(object);
            if (object3 != null && !object3.equals(object2)) {
                this.log.info("Replace, key: {}, value: {} -> {}", object, object3, object2);
            }
            properties2.put(object, object2);
        }
    }

    private void mergeIfExist(Properties properties, Properties properties2) {
        for (Object object : properties.keySet()) {
            if (!properties2.containsKey(object)) continue;
            Object object2 = properties.get(object);
            Object object3 = properties2.get(object);
            if (object3 != null && !object3.equals(object2)) {
                this.log.info("Replace, key: {}, value: {} -> {}", object, object3, object2);
            }
            properties2.put(object, object2);
        }
    }
}

