/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.annotation.ImportantField;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;

public class MixAll {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    public static final String ROCKETMQ_HOME_ENV = "ROCKETMQ_HOME";
    public static final String ROCKETMQ_HOME_PROPERTY = "rocketmq.home.dir";
    public static final String NAMESRV_ADDR_ENV = "NAMESRV_ADDR";
    public static final String NAMESRV_ADDR_PROPERTY = "rocketmq.namesrv.addr";
    public static final String MESSAGE_COMPRESS_LEVEL = "rocketmq.message.compressLevel";
    public static final String DEFAULT_NAMESRV_ADDR_LOOKUP = "jmenv.tbsite.net";
    public static final String WS_DOMAIN_NAME = System.getProperty("rocketmq.namesrv.domain", "jmenv.tbsite.net");
    public static final String WS_DOMAIN_SUBGROUP = System.getProperty("rocketmq.namesrv.domain.subgroup", "nsaddr");
    public static final String DEFAULT_TOPIC = "TBW102";
    public static final String BENCHMARK_TOPIC = "BenchmarkTest";
    public static final String DEFAULT_PRODUCER_GROUP = "DEFAULT_PRODUCER";
    public static final String DEFAULT_CONSUMER_GROUP = "DEFAULT_CONSUMER";
    public static final String TOOLS_CONSUMER_GROUP = "TOOLS_CONSUMER";
    public static final String FILTERSRV_CONSUMER_GROUP = "FILTERSRV_CONSUMER";
    public static final String MONITOR_CONSUMER_GROUP = "__MONITOR_CONSUMER";
    public static final String CLIENT_INNER_PRODUCER_GROUP = "CLIENT_INNER_PRODUCER";
    public static final String SELF_TEST_PRODUCER_GROUP = "SELF_TEST_P_GROUP";
    public static final String SELF_TEST_CONSUMER_GROUP = "SELF_TEST_C_GROUP";
    public static final String SELF_TEST_TOPIC = "SELF_TEST_TOPIC";
    public static final String OFFSET_MOVED_EVENT = "OFFSET_MOVED_EVENT";
    public static final String ONS_HTTP_PROXY_GROUP = "CID_ONS-HTTP-PROXY";
    public static final String CID_ONSAPI_PERMISSION_GROUP = "CID_ONSAPI_PERMISSION";
    public static final String CID_ONSAPI_OWNER_GROUP = "CID_ONSAPI_OWNER";
    public static final String CID_ONSAPI_PULL_GROUP = "CID_ONSAPI_PULL";
    public static final String CID_RMQ_SYS_PREFIX = "CID_RMQ_SYS_";
    public static final List<String> LOCAL_INET_ADDRESS = MixAll.getLocalInetAddress();
    public static final String LOCALHOST = MixAll.localhost();
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long MASTER_ID = 0L;
    public static final long CURRENT_JVM_PID = MixAll.getPID();
    public static final String RETRY_GROUP_TOPIC_PREFIX = "%RETRY%";
    public static final String DLQ_GROUP_TOPIC_PREFIX = "%DLQ%";
    public static final String SYSTEM_TOPIC_PREFIX = "rmq_sys_";
    public static final String UNIQUE_MSG_QUERY_FLAG = "_UNIQUE_KEY_QUERY";
    public static final String DEFAULT_TRACE_REGION_ID = "DefaultRegion";
    public static final String CONSUME_CONTEXT_TYPE = "ConsumeContextType";
    public static final String CONSUME_EXACTLYONCE_STATUS = "ConsumeExactlyOnceStatus";

    public static String getWSAddr() {
        String string = System.getProperty("rocketmq.namesrv.domain", DEFAULT_NAMESRV_ADDR_LOOKUP);
        String string2 = System.getProperty("rocketmq.namesrv.domain.subgroup", "nsaddr");
        String string3 = "http://" + string + ":8080/rocketmq/" + string2;
        if (string.indexOf(":") > 0) {
            string3 = "http://" + string + "/rocketmq/" + string2;
        }
        return string3;
    }

    public static String getRetryTopic(String string) {
        return RETRY_GROUP_TOPIC_PREFIX + string;
    }

    public static boolean isSysConsumerGroup(String string) {
        return string.startsWith(CID_RMQ_SYS_PREFIX);
    }

    public static boolean isSystemTopic(String string) {
        return string.startsWith(SYSTEM_TOPIC_PREFIX);
    }

    public static String getDLQTopic(String string) {
        return DLQ_GROUP_TOPIC_PREFIX + string;
    }

    public static String brokerVIPChannel(boolean bl, String string) {
        if (bl) {
            Object object = string.split(":");
            object = object[0] + ":" + (Integer.parseInt(object[1]) - 2);
            return object;
        }
        return string;
    }

    public static long getPID() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        if (string != null && string.length() > 0) {
            try {
                return Long.parseLong(string.split("@")[0]);
            }
            catch (Exception exception) {
                return 0L;
            }
        }
        return 0L;
    }

    public static void string2File(String object, String string) {
        String string2 = string + ".tmp";
        MixAll.string2FileNotSafe((String)object, string2);
        object = string + ".bak";
        String string3 = MixAll.file2String(string);
        if (string3 != null) {
            MixAll.string2FileNotSafe(string3, (String)object);
        }
        object = new File(string);
        ((File)object).delete();
        object = new File(string2);
        ((File)object).renameTo(new File(string));
    }

    public static void string2FileNotSafe(String object, String object2) {
        Object object3 = ((File)(object2 = new File((String)object2))).getParentFile();
        if (object3 != null) {
            ((File)object3).mkdirs();
        }
        object3 = null;
        try {
            object3 = new FileWriter((File)object2);
            ((Writer)object3).write((String)object);
        }
        catch (IOException iOException) {
            try {
                object = iOException;
                throw iOException;
            }
            catch (Throwable throwable) {
                if (object3 != null) {
                    ((OutputStreamWriter)object3).close();
                }
                throw throwable;
            }
        }
        ((OutputStreamWriter)object3).close();
        return;
    }

    public static String file2String(String object) {
        object = new File((String)object);
        return MixAll.file2String((File)object);
    }

    public static String file2String(File file) {
        block4: {
            int n2;
            if (!file.exists()) break block4;
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                n2 = fileInputStream.read(byArray);
                n2 = n2 == byArray.length ? 1 : 0;
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw throwable;
            }
            fileInputStream.close();
            if (n2 != 0) {
                return new String(byArray);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String file2String(URL object) {
        String string;
        InputStream inputStream = null;
        try {
            object = ((URL)object).openConnection();
            ((URLConnection)object).setUseCaches(false);
            inputStream = ((URLConnection)object).getInputStream();
            int n2 = inputStream.available();
            byte[] byArray = new byte[n2];
            inputStream.read(byArray, 0, n2);
            string = new String(byArray, DEFAULT_CHARSET);
            if (inputStream == null) return string;
        }
        catch (Exception exception) {
            if (inputStream == null) return null;
            try {
                inputStream.close();
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
    }

    public static void printObjectProperties(InternalLogger internalLogger, Object object) {
        MixAll.printObjectProperties(internalLogger, object, false);
    }

    public static void printObjectProperties(InternalLogger internalLogger, Object object, boolean bl) {
        Field[] fieldArray = object.getClass().getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ImportantField importantField;
            String string;
            Field field = fieldArray2[i2];
            if (Modifier.isStatic(field.getModifiers()) || (string = field.getName()).startsWith("this")) continue;
            Object object2 = null;
            try {
                field.setAccessible(true);
                object2 = field.get(object);
                if (object2 == null) {
                    object2 = "";
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Failed to obtain object properties", illegalAccessException);
            }
            if (bl && (importantField = field.getAnnotation(ImportantField.class)) == null || internalLogger == null) continue;
            internalLogger.info(string + "=" + object2);
        }
    }

    public static String properties2String(Properties object) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : ((Properties)((Object)object)).entrySet()) {
            if (entry.getValue() == null) continue;
            stringBuilder.append(entry.getKey().toString() + "=" + entry.getValue().toString() + "\n");
        }
        return stringBuilder.toString();
    }

    public static Properties string2Properties(String object) {
        Properties properties = new Properties();
        try {
            object = new ByteArrayInputStream(((String)object).getBytes(DEFAULT_CHARSET));
            properties.load((InputStream)object);
        }
        catch (Exception exception) {
            log.error("Failed to handle properties", exception);
            return null;
        }
        return properties;
    }

    public static Properties object2Properties(Object object) {
        Properties properties = new Properties();
        Field[] fieldArray = object.getClass().getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Field field = fieldArray2[i2];
            if (Modifier.isStatic(field.getModifiers()) || (string = field.getName()).startsWith("this")) continue;
            Object object2 = null;
            try {
                field.setAccessible(true);
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Failed to handle properties", illegalAccessException);
            }
            if (object2 == null) continue;
            properties.setProperty(string, object2.toString());
        }
        return properties;
    }

    public static void properties2Object(Properties properties, Object object) {
        Method[] methodArray = object.getClass().getMethods();
        Method[] methodArray2 = methodArray;
        methodArray2 = methodArray;
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Method method = methodArray2[i2];
            Object object2 = method.getName();
            if (!((String)object2).startsWith("set")) continue;
            try {
                Object object3 = ((String)object2).substring(4);
                object2 = ((String)object2).substring(3, 4);
                object2 = ((String)object2).toLowerCase() + (String)object3;
                object2 = properties.getProperty((String)object2);
                if (object2 == null || (object3 = method.getParameterTypes()) == null || ((Class<?>[])object3).length <= 0) continue;
                if (((String)(object3 = object3[0].getSimpleName())).equals("int") || ((String)object3).equals("Integer")) {
                    object2 = Integer.parseInt((String)object2);
                } else if (((String)object3).equals("long") || ((String)object3).equals("Long")) {
                    object2 = Long.parseLong((String)object2);
                } else if (((String)object3).equals("double") || ((String)object3).equals("Double")) {
                    object2 = Double.parseDouble((String)object2);
                } else if (((String)object3).equals("boolean") || ((String)object3).equals("Boolean")) {
                    object2 = Boolean.parseBoolean((String)object2);
                } else if (((String)object3).equals("float") || ((String)object3).equals("Float")) {
                    object2 = Float.valueOf(Float.parseFloat((String)object2));
                } else if (!((String)object3).equals("String")) continue;
                method.invoke(object, object2);
                continue;
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean isPropertiesEqual(Properties properties, Properties properties2) {
        return properties.equals(properties2);
    }

    public static List<String> getLocalInetAddress() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                object = ((NetworkInterface)object).getInetAddresses();
                while (object.hasMoreElements()) {
                    arrayList.add(((InetAddress)object.nextElement()).getHostAddress());
                }
            }
        }
        catch (SocketException socketException) {
            throw new RuntimeException("get local inet address fail", socketException);
        }
        return arrayList;
    }

    private static String localhost() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Throwable throwable) {
            try {
                String string = MixAll.getLocalhostByNetworkInterface();
                if (string != null) {
                    return string;
                }
            }
            catch (Exception exception) {}
            throw new RuntimeException("InetAddress java.net.InetAddress.getLocalHost() throws UnknownHostException" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), throwable);
        }
    }

    public static String getLocalhostByNetworkInterface() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if ("docker0".equals(((NetworkInterface)object).getName()) || !((NetworkInterface)object).isUp()) continue;
            object = ((NetworkInterface)object).getInetAddresses();
            while (object.hasMoreElements()) {
                InetAddress inetAddress = (InetAddress)object.nextElement();
                if (inetAddress.isLoopbackAddress()) continue;
                if (inetAddress instanceof Inet6Address) {
                    arrayList.add(inetAddress.getHostAddress());
                    continue;
                }
                return inetAddress.getHostAddress();
            }
        }
        if (!arrayList.isEmpty()) {
            return (String)arrayList.get(0);
        }
        return null;
    }

    public static boolean compareAndIncreaseOnly(AtomicLong atomicLong, long l2) {
        long l3 = atomicLong.get();
        while (l2 > l3) {
            boolean bl = atomicLong.compareAndSet(l3, l2);
            if (bl) {
                return true;
            }
            l3 = atomicLong.get();
        }
        return false;
    }

    public static String humanReadableByteCount(long l2, boolean bl) {
        int n2;
        int n3 = n2 = bl ? 1000 : 1024;
        if (l2 < (long)n2) {
            return l2 + " B";
        }
        int n4 = (int)(Math.log(l2) / Math.log(n2));
        String string = (bl ? "kMGTPE" : "KMGTPE").charAt(n4 - 1) + (bl ? "" : "i");
        return String.format("%.1f %sB", (double)l2 / Math.pow(n2, n4), string);
    }
}

