/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.CountDownLatch2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ServiceThread
implements Runnable {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    private static final long JOIN_TIME = 90000L;
    protected final Thread thread;
    protected final CountDownLatch2 waitPoint = new CountDownLatch2(1);
    protected volatile AtomicBoolean hasNotified = new AtomicBoolean(false);
    protected volatile boolean stopped = false;

    public ServiceThread() {
        ServiceThread serviceThread = this;
        this.thread = new Thread((Runnable)serviceThread, serviceThread.getServiceName());
    }

    public abstract String getServiceName();

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean bl) {
        this.stopped = true;
        log.info("shutdown thread " + this.getServiceName() + " interrupt " + bl);
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
        try {
            if (bl) {
                this.thread.interrupt();
            }
            long l2 = System.currentTimeMillis();
            if (!this.thread.isDaemon()) {
                this.thread.join(this.getJointime());
            }
            long l3 = System.currentTimeMillis() - l2;
            log.info("join thread " + this.getServiceName() + " eclipse time(ms) " + l3 + " " + this.getJointime());
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("Interrupted", interruptedException);
            return;
        }
    }

    public long getJointime() {
        return 90000L;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean bl) {
        this.stopped = true;
        log.info("stop thread " + this.getServiceName() + " interrupt " + bl);
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
        if (bl) {
            this.thread.interrupt();
        }
    }

    public void makeStop() {
        this.stopped = true;
        log.info("makestop thread " + this.getServiceName());
    }

    public void wakeup() {
        if (this.hasNotified.compareAndSet(false, true)) {
            this.waitPoint.countDown();
        }
    }

    protected void waitForRunning(long l2) {
        if (this.hasNotified.compareAndSet(true, false)) {
            this.onWaitEnd();
            return;
        }
        this.waitPoint.reset();
        try {
            this.waitPoint.await(l2, TimeUnit.MILLISECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("Interrupted", interruptedException);
            return;
        }
        finally {
            this.hasNotified.set(false);
            this.onWaitEnd();
        }
    }

    protected void onWaitEnd() {
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

