/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class UtilAll {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqCommon");
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd#HH:mm:ss:SSS";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static int getPid() {
        Object object = ManagementFactory.getRuntimeMXBean();
        object = object.getName();
        try {
            return Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(64)));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static String currentStackTrace() {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
        stackTraceElementArray2 = stackTraceElementArray;
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray2[i2];
            stringBuilder.append("\n\t");
            stringBuilder.append(stackTraceElement.toString());
        }
        return stringBuilder.toString();
    }

    public static String offset2FileName(long l2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(20);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(l2);
    }

    public static long computeEclipseTimeMilliseconds(long l2) {
        return System.currentTimeMillis() - l2;
    }

    public static boolean isItTimeToDo(String stringArray) {
        if ((stringArray = stringArray.split(";")).length > 0) {
            Calendar calendar = Calendar.getInstance();
            for (String string : stringArray) {
                int n2 = Integer.parseInt(string);
                if (n2 != calendar.get(11)) continue;
                return true;
            }
        }
        return false;
    }

    public static String timeMillisToHumanString() {
        return UtilAll.timeMillisToHumanString(System.currentTimeMillis());
    }

    public static String timeMillisToHumanString(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return String.format("%04d%02d%02d%02d%02d%02d%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static long computNextMorningTimeMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long computNextMinutesTimeMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(5, 0);
        calendar.add(11, 0);
        calendar.add(12, 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long computNextHourTimeMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(5, 0);
        calendar.add(11, 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static long computNextHalfHourTimeMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(5, 0);
        calendar.add(11, 1);
        calendar.set(12, 30);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String timeMillisToHumanString2(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return String.format("%04d-%02d-%02d %02d:%02d:%02d,%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String timeMillisToHumanString3(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return String.format("%04d%02d%02d%02d%02d%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static double getDiskPartitionSpaceUsedPercent(String object) {
        if (object == null || ((String)object).isEmpty()) {
            return -1.0;
        }
        try {
            object = new File((String)object);
            if (!((File)object).exists()) {
                return -1.0;
            }
            long l2 = ((File)object).getTotalSpace();
            if (l2 > 0L) {
                long l3 = ((File)object).getFreeSpace();
                long l4 = l2 - l3;
                return (double)l4 / (double)l2;
            }
        }
        catch (Exception exception) {
            return -1.0;
        }
        return -1.0;
    }

    public static int crc32(byte[] byArray) {
        if (byArray != null) {
            return UtilAll.crc32(byArray, 0, byArray.length);
        }
        return 0;
    }

    public static int crc32(byte[] byArray, int n2, int n3) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n2, n3);
        return (int)(cRC32.getValue() & Integer.MAX_VALUE);
    }

    public static String bytes2string(byte[] byArray) {
        char[] cArray = new char[byArray.length << 1];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 << 1] = HEX_ARRAY[n2 >>> 4];
            cArray[(i2 << 1) + 1] = HEX_ARRAY[n2 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] string2bytes(String object) {
        if (object == null || ((String)object).equals("")) {
            return null;
        }
        object = ((String)object).toUpperCase();
        int n2 = ((String)object).length() / 2;
        object = ((String)object).toCharArray();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 << 1;
            byArray[i2] = (byte)(UtilAll.charToByte((char)object[n3]) << 4 | UtilAll.charToByte((char)object[n3 + 1]));
        }
        return byArray;
    }

    private static byte charToByte(char c2) {
        return (byte)"0123456789ABCDEF".indexOf(c2);
    }

    public static byte[] uncompress(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        try {
            int n2;
            while ((n2 = inflaterInputStream.read(byArray2, 0, byArray2.length)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                log.error("Failed to close the stream", iOException);
            }
            try {
                inflaterInputStream.close();
            }
            catch (IOException iOException) {
                log.error("Failed to close the stream", iOException);
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                log.error("Failed to close the stream", iOException);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] byArray, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        Deflater deflater = new Deflater(n2);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        try {
            deflaterOutputStream.write(byArray);
            deflaterOutputStream.finish();
            deflaterOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            try {
                deflater.end();
                throw iOException;
            }
            catch (Throwable throwable) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException2) {}
                deflater.end();
                throw throwable;
            }
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        deflater.end();
        return byArray;
    }

    public static int asInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static long asLong(String string, long l2) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return l2;
        }
    }

    public static String formatDate(Date date, String object) {
        object = new SimpleDateFormat((String)object);
        return ((DateFormat)object).format(date);
    }

    public static Date parseDate(String string, String object) {
        object = new SimpleDateFormat((String)object);
        try {
            return ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String responseCode2String(int n2) {
        return Integer.toString(n2);
    }

    public static String frontStringAtLeast(String string, int n2) {
        if (string != null && string.length() > n2) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String jstack() {
        return UtilAll.jstack(Thread.getAllStackTraces());
    }

    public static String jstack(Map<Thread, StackTraceElement[]> object) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry entry : object.entrySet()) {
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])entry.getValue();
                Thread thread = (Thread)entry.getKey();
                if (stackTraceElementArray == null || stackTraceElementArray.length <= 0) continue;
                String string = ((Thread)entry.getKey()).getName();
                stringBuilder.append(String.format("%-40sTID: %d STATE: %s%n", new Object[]{string, thread.getId(), thread.getState()}));
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    stringBuilder.append(String.format("%-40s%s%n", string, stackTraceElement.toString()));
                }
                stringBuilder.append("\n");
            }
        }
        catch (Throwable throwable) {
            stringBuilder.append(RemotingHelper.exceptionSimpleDesc(throwable));
        }
        return stringBuilder.toString();
    }

    public static boolean isInternalIP(byte[] byArray) {
        if (byArray.length != 4) {
            throw new RuntimeException("illegal ipv4 bytes");
        }
        if (byArray[0] == 10) {
            return true;
        }
        return byArray[0] == -84 ? byArray[1] >= 16 && byArray[1] <= 31 : byArray[0] == -64 && byArray[1] == -88;
    }

    private static boolean ipCheck(byte[] byArray) {
        if (byArray.length != 4) {
            throw new RuntimeException("illegal ipv4 bytes");
        }
        if (byArray[0] > 0 && byArray[0] <= 126) {
            if (byArray[1] == 1 && byArray[2] == 1 && byArray[3] == 1) {
                return false;
            }
            return byArray[1] != 0 || byArray[2] != 0 || byArray[3] != 0;
        }
        if (byArray[0] >= -128 && byArray[0] <= -65) {
            if (byArray[2] == 1 && byArray[3] == 1) {
                return false;
            }
            return byArray[2] != 0 || byArray[3] != 0;
        }
        if (byArray[0] >= -64 && byArray[0] <= -33) {
            if (byArray[3] == 1) {
                return false;
            }
            return byArray[3] != 0;
        }
        return false;
    }

    public static String ipToIPv4Str(byte[] byArray) {
        if (byArray.length != 4) {
            return null;
        }
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public static byte[] getIP() {
        block6: {
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                Object object = null;
                while (enumeration.hasMoreElements()) {
                    Object object2 = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object2).getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        object2 = enumeration2.nextElement();
                        if (object2 == null || !(object2 instanceof Inet4Address)) continue;
                        byte[] byArray = ((InetAddress)object2).getAddress();
                        object2 = byArray;
                        if (byArray.length != 4 || !UtilAll.ipCheck((byte[])object2)) continue;
                        if (!UtilAll.isInternalIP((byte[])object2)) {
                            return object2;
                        }
                        if (object != null) continue;
                        object = object2;
                    }
                }
                if (object == null) break block6;
                return object;
            }
            catch (Exception exception) {
                throw new RuntimeException("Can not get local ip", exception);
            }
        }
        throw new RuntimeException("Can not get local ip");
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            File[] fileArray2 = fileArray;
            fileArray2 = fileArray;
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file2 = fileArray2[i2];
                UtilAll.deleteFile(file2);
            }
            file.delete();
        }
    }
}

