/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consistenthash;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consistenthash.ConsistentHashRouter$MD5Hash;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consistenthash.HashFunction;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consistenthash.Node;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consistenthash.VirtualNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ConsistentHashRouter<T extends Node> {
    private final SortedMap<Long, VirtualNode<T>> ring = new TreeMap<Long, VirtualNode<T>>();
    private final HashFunction hashFunction;

    public ConsistentHashRouter(Collection<T> collection, int n2) {
        this(collection, n2, new ConsistentHashRouter$MD5Hash());
    }

    public ConsistentHashRouter(Collection<T> object, int n2, HashFunction object2) {
        if (object2 == null) {
            throw new NullPointerException("Hash Function is null");
        }
        this.hashFunction = object2;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                object2 = (Node)object.next();
                this.addNode(object2, n2);
            }
        }
    }

    public void addNode(T t2, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal virtual node counts :" + n2);
        }
        int n3 = this.getExistingReplicas(t2);
        for (int i2 = 0; i2 < n2; ++i2) {
            VirtualNode<T> virtualNode = new VirtualNode<T>(t2, i2 + n3);
            this.ring.put(this.hashFunction.hash(virtualNode.getKey()), virtualNode);
        }
    }

    public void removeNode(T t2) {
        Iterator<Long> iterator = this.ring.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!((VirtualNode)(object = (VirtualNode)this.ring.get(object))).isVirtualNodeOf(t2)) continue;
            iterator.remove();
        }
    }

    public T routeNode(String object) {
        if (this.ring.isEmpty()) {
            return null;
        }
        object = this.hashFunction.hash((String)object);
        object = !(object = this.ring.tailMap((Long)object)).isEmpty() ? object.firstKey() : this.ring.firstKey();
        return ((VirtualNode)this.ring.get(object)).getPhysicalNode();
    }

    public int getExistingReplicas(T t2) {
        int n2 = 0;
        for (VirtualNode<T> virtualNode : this.ring.values()) {
            if (!virtualNode.isVirtualNodeOf(t2)) continue;
            ++n2;
        }
        return n2;
    }
}

