/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MessageBatch
extends Message
implements Iterable<Message> {
    private static final long serialVersionUID = 621335151046335557L;
    private final List<Message> messages;

    private MessageBatch(List<Message> list) {
        this.messages = list;
    }

    public byte[] encode() {
        return MessageDecoder.encodeMessages(this.messages);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.messages.iterator();
    }

    public static MessageBatch generateFromList(Collection<Message> object) {
        assert (object != null);
        assert (object.size() > 0);
        ArrayList<Message> arrayList = new ArrayList<Message>(object.size());
        Message message = null;
        object = object.iterator();
        while (object.hasNext()) {
            Message message2 = (Message)object.next();
            if (message2.getDelayTimeLevel() > 0) {
                throw new UnsupportedOperationException("TimeDelayLevel in not supported for batching");
            }
            if (message2.getTopic().startsWith("%RETRY%")) {
                throw new UnsupportedOperationException("Retry Group is not supported for batching");
            }
            if (message == null) {
                message = message2;
            } else {
                if (!message.getTopic().equals(message2.getTopic())) {
                    throw new UnsupportedOperationException("The topic of the messages in one batch should be the same");
                }
                if (message.isWaitStoreMsgOK() != message2.isWaitStoreMsgOK()) {
                    throw new UnsupportedOperationException("The waitStoreMsgOK of the messages in one batch should the same");
                }
            }
            arrayList.add(message2);
        }
        object = new MessageBatch(arrayList);
        ((Message)object).setTopic(message.getTopic());
        ((Message)object).setWaitStoreMsgOK(message.isWaitStoreMsgOK());
        return object;
    }
}

