/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class MessageClientIDSetter {
    private static final String TOPIC_KEY_SPLITTER = "#";
    private static final int LEN = 16;
    private static final int EXTEND_UNIQINFO_LEN = 40;
    private static final String FIX_STRING;
    private static final AtomicInteger COUNTER;
    private static long startTime;
    private static long nextStartTime;

    private static synchronized void setStartTime(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        startTime = calendar.getTimeInMillis();
        calendar.add(2, 1);
        nextStartTime = calendar.getTimeInMillis();
    }

    public static Date getNearlyTimeFromID(String object) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        object = UtilAll.string2bytes((String)object);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte[])object, 10, 4);
        byteBuffer.position(0);
        long l2 = byteBuffer.getLong();
        object = Calendar.getInstance();
        long l3 = ((Calendar)object).getTimeInMillis();
        ((Calendar)object).set(5, 1);
        ((Calendar)object).set(11, 0);
        ((Calendar)object).set(12, 0);
        ((Calendar)object).set(13, 0);
        ((Calendar)object).set(14, 0);
        long l4 = ((Calendar)object).getTimeInMillis();
        if (l4 + l2 >= l3) {
            ((Calendar)object).add(2, -1);
            l4 = ((Calendar)object).getTimeInMillis();
        }
        ((Calendar)object).setTimeInMillis(l4 + l2);
        return ((Calendar)object).getTime();
    }

    public static String getIPStrFromID(String object) {
        byte[] byArray = MessageClientIDSetter.getIPFromID((String)object);
        object = byArray;
        return UtilAll.ipToIPv4Str(byArray);
    }

    public static byte[] getIPFromID(String object) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = UtilAll.string2bytes((String)object);
        object = byArray2;
        System.arraycopy(byArray2, 0, byArray, 0, 4);
        return byArray;
    }

    public static String createUniqID() {
        StringBuilder stringBuilder = new StringBuilder(LEN << 1);
        stringBuilder.append(FIX_STRING);
        stringBuilder.append(UtilAll.bytes2string(MessageClientIDSetter.createUniqIDBuffer()));
        return stringBuilder.toString();
    }

    public static String createExtendUniqInfo(Message object, int n2) {
        StringBuilder stringBuilder = new StringBuilder(40);
        stringBuilder.append(((Message)object).getProperty("UNIQ_KEY"));
        object = ByteBuffer.allocate(4);
        ((ByteBuffer)object).putInt(n2);
        stringBuilder.append(UtilAll.bytes2string(((ByteBuffer)object).array()));
        return stringBuilder.toString();
    }

    private static byte[] createUniqIDBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        long l2 = System.currentTimeMillis();
        if (l2 >= nextStartTime) {
            MessageClientIDSetter.setStartTime(l2);
        }
        byteBuffer.position(0);
        byteBuffer.putInt((int)(System.currentTimeMillis() - startTime));
        byteBuffer.putShort((short)COUNTER.getAndIncrement());
        return byteBuffer.array();
    }

    public static void setUniqID(Message message) {
        if (message.getProperty("UNIQ_KEY") == null) {
            message.putProperty("UNIQ_KEY", MessageClientIDSetter.createUniqID());
        }
    }

    public static void setExtendUniqInfo(Message message, int n2) {
        if (message.getProperty("EXTEND_UNIQ_INFO") == null) {
            message.putProperty("EXTEND_UNIQ_INFO", MessageClientIDSetter.createExtendUniqInfo(message, n2));
        }
    }

    public static String getUniqID(Message message) {
        return message.getProperty("UNIQ_KEY");
    }

    public static byte[] createFakeIP() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(System.currentTimeMillis());
        byteBuffer.position(4);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray);
        return byArray;
    }

    static {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.position(2);
        byteBuffer.putInt(UtilAll.getPid());
        byteBuffer.position(0);
        try {
            byteBuffer.put(UtilAll.getIP());
        }
        catch (Exception exception) {
            byteBuffer.put(MessageClientIDSetter.createFakeIP());
        }
        byteBuffer.position(6);
        byteBuffer.putInt(MessageClientIDSetter.class.getClassLoader().hashCode());
        FIX_STRING = UtilAll.bytes2string(byteBuffer.array());
        MessageClientIDSetter.setStartTime(System.currentTimeMillis());
        COUNTER = new AtomicInteger(0);
    }
}

