/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageId;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageVersion;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageDecoder {
    public static final int MSG_ID_LENGTH = 16;
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    public static final int MESSAGE_MAGIC_CODE_POSTION = 4;
    public static final int MESSAGE_FLAG_POSTION = 16;
    public static final int MESSAGE_PHYSIC_OFFSET_POSTION = 28;
    public static final int MESSAGE_STORE_TIMESTAMP_POSTION = 56;
    public static final int MESSAGE_MAGIC_CODE = -626843481;
    public static final int MESSAGE_MAGIC_CODE_V2 = -626843477;
    public static final char NAME_VALUE_SEPARATOR = '\u0001';
    public static final char PROPERTY_SEPARATOR = '\u0002';
    public static final int BODY_SIZE_POSITION = 84;

    public static String createMessageId(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, long l2) {
        byteBuffer.flip();
        byteBuffer.limit(16);
        byteBuffer.put(byteBuffer2);
        byteBuffer.putLong(l2);
        return UtilAll.bytes2string(byteBuffer.array());
    }

    public static String createMessageId(SocketAddress socketAddress, long l2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        socketAddress = (InetSocketAddress)socketAddress;
        byteBuffer.put(((InetSocketAddress)socketAddress).getAddress().getAddress());
        byteBuffer.putInt(((InetSocketAddress)socketAddress).getPort());
        byteBuffer.putLong(l2);
        byteBuffer.flip();
        return UtilAll.bytes2string(byteBuffer.array());
    }

    public static MessageId decodeMessageId(String object) {
        Object object2 = UtilAll.string2bytes(((String)object).substring(0, 8));
        Object object3 = UtilAll.string2bytes(((String)object).substring(8, 16));
        ByteBuffer byteBuffer = ByteBuffer.wrap(object3);
        object3 = byteBuffer;
        int n2 = byteBuffer.getInt(0);
        object2 = new InetSocketAddress(InetAddress.getByAddress(object2), n2);
        byte[] byArray = UtilAll.string2bytes(((String)object).substring(16, 32));
        object = byArray;
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        long l2 = byteBuffer2.getLong(0);
        return new MessageId((SocketAddress)object2, l2);
    }

    public static Map<String, String> decodeProperties(ByteBuffer map) {
        int n2 = ((ByteBuffer)((Object)map)).getInt(4);
        MessageVersion messageVersion = MessageVersion.valueOfMagicCode(n2);
        int n3 = messageVersion.getTopicLengthSize();
        int n4 = 88 + ((ByteBuffer)((Object)map)).getInt(84);
        int n5 = messageVersion.getTopicLength((ByteBuffer)((Object)map), n4);
        short s2 = ((ByteBuffer)((Object)map)).getShort(n4 + n3 + n5);
        ((ByteBuffer)((Object)map)).position(n4 + n3 + n5 + 2);
        if (s2 > 0) {
            byte[] byArray = new byte[s2];
            ((ByteBuffer)((Object)map)).get(byArray);
            map = new String(byArray, CHARSET_UTF8);
            map = MessageDecoder.string2messageProperties((String)((Object)map));
            return map;
        }
        return null;
    }

    public static MessageExt decode(ByteBuffer byteBuffer) {
        return MessageDecoder.decode(byteBuffer, true, true, false);
    }

    public static MessageExt clientDecode(ByteBuffer byteBuffer, boolean bl) {
        return MessageDecoder.decode(byteBuffer, bl, true, true);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean bl) {
        return MessageDecoder.decode(byteBuffer, bl, true, false);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encode(MessageExt messageExt, boolean bl, MessageVersion messageVersion) {
        ByteBuffer byteBuffer;
        void var2_3;
        int inetSocketAddress = var2_3.getMagicCode();
        byte[] n5 = messageExt.getBody();
        byte[] byArray = messageExt.getTopic().getBytes(CHARSET_UTF8);
        int n2 = byArray.length;
        Object object = MessageDecoder.messageProperties2String(messageExt.getProperties());
        byte[] byArray2 = ((String)object).getBytes(CHARSET_UTF8);
        object = byArray2;
        short s2 = (short)byArray2.length;
        int n3 = messageExt.getSysFlag();
        byte[] byArray3 = messageExt.getBody();
        if (bl && (n3 & 1) == 1) {
            byArray3 = UtilAll.compress(n5, 5);
        }
        int n4 = byArray3.length;
        int n6 = messageExt.getStoreSize();
        if (n6 > 0) {
            byteBuffer = ByteBuffer.allocate(n6);
        } else {
            n6 = n4 + 88 + var2_3.getTopicLengthSize() + n2 + 2 + s2;
            byteBuffer = ByteBuffer.allocate(n6);
        }
        byteBuffer.putInt(n6);
        byteBuffer.putInt(inetSocketAddress);
        inetSocketAddress = messageExt.getBodyCRC();
        byteBuffer.putInt(inetSocketAddress);
        inetSocketAddress = messageExt.getQueueId();
        byteBuffer.putInt(inetSocketAddress);
        inetSocketAddress = messageExt.getFlag();
        byteBuffer.putInt(inetSocketAddress);
        long l2 = messageExt.getQueueOffset();
        byteBuffer.putLong(l2);
        long l3 = messageExt.getCommitLogOffset();
        byteBuffer.putLong(l3);
        byteBuffer.putInt(n3);
        long l4 = messageExt.getBornTimestamp();
        byteBuffer.putLong(l4);
        InetSocketAddress n62 = (InetSocketAddress)messageExt.getBornHost();
        byteBuffer.put(n62.getAddress().getAddress());
        byteBuffer.putInt(n62.getPort());
        long l5 = messageExt.getStoreTimestamp();
        byteBuffer.putLong(l5);
        n62 = (InetSocketAddress)messageExt.getStoreHost();
        byteBuffer.put(n62.getAddress().getAddress());
        byteBuffer.putInt(n62.getPort());
        int n7 = messageExt.getReconsumeTimes();
        byteBuffer.putInt(n7);
        long l6 = messageExt.getPreparedTransactionOffset();
        byteBuffer.putLong(l6);
        byteBuffer.putInt(n4);
        byteBuffer.put(byArray3);
        var2_3.putTopicLength(byteBuffer, n2);
        byteBuffer.put(byArray);
        byteBuffer.putShort(s2);
        byteBuffer.put((byte[])object);
        return byteBuffer.array();
    }

    public static byte[] encode(MessageExt messageExt, boolean bl) {
        return MessageDecoder.encode(messageExt, bl, MessageVersion.MESSAGE_VERSION_V1);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        return MessageDecoder.decode(byteBuffer, bl, bl2, false);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) {
        return MessageDecoder.decode(byteBuffer, bl, bl2, bl3, false, true);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return MessageDecoder.decode(byteBuffer, bl, bl2, bl3, bl4, true);
    }

    public static MessageExt decode(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        try {
            MessageExt messageExt = bl3 ? new MessageClientExt() : new MessageExt();
            int messageVersion = byteBuffer.getInt();
            messageExt.setStoreSize(messageVersion);
            int n2 = byteBuffer.getInt();
            MessageVersion messageVersion2 = MessageVersion.valueOfMagicCode(n2);
            messageExt.setVersion(messageVersion2);
            int n3 = byteBuffer.getInt();
            messageExt.setBodyCRC(n3);
            n3 = byteBuffer.getInt();
            messageExt.setQueueId(n3);
            n3 = byteBuffer.getInt();
            messageExt.setFlag(n3);
            long l2 = byteBuffer.getLong();
            messageExt.setQueueOffset(l2);
            long l3 = byteBuffer.getLong();
            messageExt.setCommitLogOffset(l3);
            n3 = byteBuffer.getInt();
            messageExt.setSysFlag(n3);
            long l4 = byteBuffer.getLong();
            messageExt.setBornTimestamp(l4);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, 4);
            int n4 = byteBuffer.getInt();
            messageExt.setBornHost(new InetSocketAddress(InetAddress.getByAddress(byArray), n4));
            long l5 = byteBuffer.getLong();
            messageExt.setStoreTimestamp(l5);
            byArray = new byte[4];
            byteBuffer.get(byArray, 0, 4);
            n4 = byteBuffer.getInt();
            messageExt.setStoreHost(new InetSocketAddress(InetAddress.getByAddress(byArray), n4));
            int n5 = byteBuffer.getInt();
            messageExt.setReconsumeTimes(n5);
            long l6 = byteBuffer.getLong();
            messageExt.setPreparedTransactionOffset(l6);
            n5 = byteBuffer.getInt();
            if (n5 > 0) {
                if (bl) {
                    byte[] byArray2 = new byte[n5];
                    byteBuffer.get(byArray2);
                    if (bl2 && (n3 & 1) == 1) {
                        byArray2 = UtilAll.uncompress(byArray2);
                    }
                    messageExt.setBody(byArray2);
                } else {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.position(byteBuffer2.position() + n5);
                }
            }
            int n52 = messageVersion2.getTopicLength(byteBuffer);
            byte[] byArray3 = new byte[n52];
            byteBuffer.get(byArray3);
            messageExt.setTopic(new String(byArray3, CHARSET_UTF8));
            short s2 = byteBuffer.getShort();
            if (s2 > 0) {
                Object object = new byte[s2];
                byteBuffer.get((byte[])object);
                String string = new String((byte[])object, CHARSET_UTF8);
                object = string;
                object = MessageDecoder.string2messageProperties(string);
                messageExt.setProperties((Map<String, String>)object);
            }
            Object object = ByteBuffer.allocate(16);
            object = MessageDecoder.createMessageId((ByteBuffer)object, messageExt.getStoreHostBytes(), messageExt.getCommitLogOffset());
            messageExt.setMsgId((String)object);
            if (bl3) {
                ((MessageClientExt)messageExt).setOffsetMsgId((String)object);
            }
            return messageExt;
        }
        catch (Exception exception) {
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.limit());
            return null;
        }
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer) {
        return MessageDecoder.decodes(byteBuffer, true);
    }

    public static List<MessageExt> decodesBatch(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) {
        MessageExt messageExt;
        ArrayList<MessageExt> arrayList = new ArrayList<MessageExt>();
        while (byteBuffer.hasRemaining() && (messageExt = MessageDecoder.decode(byteBuffer, bl, bl2, bl3)) != null) {
            arrayList.add(messageExt);
        }
        return arrayList;
    }

    public static List<MessageExt> decodes(ByteBuffer byteBuffer, boolean bl) {
        MessageExt messageExt;
        ArrayList<MessageExt> arrayList = new ArrayList<MessageExt>();
        while (byteBuffer.hasRemaining() && (messageExt = MessageDecoder.clientDecode(byteBuffer, bl)) != null) {
            arrayList.add(messageExt);
        }
        return arrayList;
    }

    public static String messageProperties2String(Map<String, String> object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                String object2 = (String)entry.getValue();
                stringBuilder.append(string);
                stringBuilder.append('\u0001');
                stringBuilder.append(object2);
                stringBuilder.append('\u0002');
            }
        }
        return stringBuilder.toString();
    }

    public static Map<String, String> string2messageProperties(String stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            String[] stringArray2 = stringArray.split("\u0002");
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray3 = stringArray[i2];
                if (2 != (stringArray3 = stringArray3.split("\u0001")).length) continue;
                hashMap.put(stringArray3[0], stringArray3[1]);
            }
        }
        return hashMap;
    }

    public static byte[] encodeMessage(Message message) {
        byte[] byArray = message.getBody();
        int n2 = byArray.length;
        Object object = MessageDecoder.messageProperties2String(message.getProperties());
        byte[] byArray2 = ((String)object).getBytes(CHARSET_UTF8);
        object = byArray2;
        short s2 = (short)byArray2.length;
        message.getFlag();
        int n3 = n2 + 20 + 2 + s2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        byteBuffer.putInt(n3);
        byteBuffer.putInt(0);
        byteBuffer.putInt(0);
        int n4 = message.getFlag();
        byteBuffer.putInt(n4);
        byteBuffer.putInt(n2);
        byteBuffer.put(byArray);
        byteBuffer.putShort(s2);
        byteBuffer.put((byte[])object);
        return byteBuffer.array();
    }

    public static Message decodeMessage(ByteBuffer byteBuffer) {
        Message message = new Message();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        message.setFlag(n2);
        n2 = byteBuffer.getInt();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        message.setBody(byArray);
        short s2 = byteBuffer.getShort();
        byte[] byArray2 = new byte[s2];
        byteBuffer.get(byArray2);
        message.setProperties(MessageDecoder.string2messageProperties(new String(byArray2, CHARSET_UTF8)));
        return message;
    }

    public static byte[] encodeMessages(List<Message> object) {
        Object object2;
        Object object3 = new ArrayList<Object>(object.size());
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Message message = (Message)object.next();
            object2 = MessageDecoder.encodeMessage(message);
            object3.add(object2);
            n2 += ((Object)object2).length;
        }
        object = new byte[n2];
        int n3 = 0;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            byte[] byArray = (byte[])object2.next();
            object3 = byArray;
            System.arraycopy(byArray, 0, object, n3, ((Object)object3).length);
            n3 += ((Object)object3).length;
        }
        return object;
    }

    public static List<Message> decodeMessages(ByteBuffer byteBuffer) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        while (byteBuffer.hasRemaining()) {
            Message message = MessageDecoder.decodeMessage(byteBuffer);
            arrayList.add(message);
        }
        return arrayList;
    }
}

