/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;

public class NamespaceUtil {
    public static final char NAMESPACE_SEPARATOR = '%';
    public static final int RETRY_PREFIX_LENGTH = 7;
    public static final int DLQ_PREFIX_LENGTH = 5;

    public static String withNamespace(RemotingCommand remotingCommand, String string) {
        return NamespaceUtil.wrapNamespace(NamespaceUtil.getNamespaceFromRequest(remotingCommand), string);
    }

    public static String withoutNamespace(String string) {
        if (StringUtils.isEmpty(string) || NamespaceUtil.isSystemResource(string)) {
            return string;
        }
        if (NamespaceUtil.isRetryTopic(string)) {
            int n2 = string.indexOf(37, RETRY_PREFIX_LENGTH);
            if (n2 > 0) {
                return MixAll.getRetryTopic(string.substring(n2 + 1));
            }
            return string;
        }
        if (NamespaceUtil.isDLQTopic(string)) {
            int n3 = string.indexOf(37, DLQ_PREFIX_LENGTH);
            if (n3 > 0) {
                return MixAll.getDLQTopic(string.substring(n3 + 1));
            }
            return string;
        }
        int n4 = string.indexOf(37);
        if (n4 > 0) {
            return string.substring(n4 + 1);
        }
        return string;
    }

    public static String withoutNamespace(String string, String string2) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (NamespaceUtil.isRetryTopic(string)) {
            stringBuffer.append("%RETRY%");
        } else if (NamespaceUtil.isDLQTopic(string)) {
            stringBuffer.append("%DLQ%");
        }
        stringBuffer.append(string2).append('%');
        if (string.startsWith(stringBuffer.toString())) {
            return NamespaceUtil.withoutNamespace(string);
        }
        return string;
    }

    public static String wrapNamespace(String charSequence, String string) {
        if (StringUtils.isEmpty(charSequence) || StringUtils.isEmpty(string)) {
            return string;
        }
        if (NamespaceUtil.isSystemResource(string)) {
            return string;
        }
        if (NamespaceUtil.isAlreadyWithNamespace(string, (String)charSequence)) {
            return string;
        }
        charSequence = new StringBuffer().append((String)charSequence).append('%');
        if (NamespaceUtil.isRetryTopic(string)) {
            ((StringBuffer)charSequence).append(string.substring(RETRY_PREFIX_LENGTH));
            return ((StringBuffer)charSequence).insert(0, "%RETRY%").toString();
        }
        if (NamespaceUtil.isDLQTopic(string)) {
            ((StringBuffer)charSequence).append(string.substring(DLQ_PREFIX_LENGTH));
            return ((StringBuffer)charSequence).insert(0, "%DLQ%").toString();
        }
        return ((StringBuffer)charSequence).append(string).toString();
    }

    public static boolean isAlreadyWithNamespace(String string, String string2) {
        if (StringUtils.isEmpty(string2) || StringUtils.isEmpty(string) || NamespaceUtil.isSystemResource(string)) {
            return false;
        }
        if (NamespaceUtil.isRetryTopic(string)) {
            string = string.substring(RETRY_PREFIX_LENGTH);
        }
        if (NamespaceUtil.isDLQTopic(string)) {
            string = string.substring(DLQ_PREFIX_LENGTH);
        }
        return string.startsWith(string2 + '%');
    }

    public static String withNamespaceAndRetry(RemotingCommand remotingCommand, String string) {
        return NamespaceUtil.wrapNamespaceAndRetry(NamespaceUtil.getNamespaceFromRequest(remotingCommand), string);
    }

    public static String wrapNamespaceAndRetry(String string, String string2) {
        if (StringUtils.isEmpty(string2)) {
            return null;
        }
        return new StringBuffer("%RETRY%").append(NamespaceUtil.wrapNamespace(string, string2)).toString();
    }

    public static String getNamespaceFromRequest(RemotingCommand object) {
        if (object == null || null == ((RemotingCommand)object).getExtFields()) {
            return null;
        }
        switch (((RemotingCommand)object).getCode()) {
            case 310: {
                object = ((RemotingCommand)object).getExtFields().get("n");
                break;
            }
            default: {
                object = ((RemotingCommand)object).getExtFields().get("namespace");
            }
        }
        return object;
    }

    public static String getNamespaceFromResource(String string) {
        if (StringUtils.isEmpty(string) || NamespaceUtil.isSystemResource(string)) {
            return "";
        }
        if (NamespaceUtil.isRetryTopic(string)) {
            int n2 = string.indexOf(37, RETRY_PREFIX_LENGTH);
            if (n2 > 0) {
                return string.substring(RETRY_PREFIX_LENGTH, n2);
            }
            return "";
        }
        if (NamespaceUtil.isDLQTopic(string)) {
            int n3 = string.indexOf(37, DLQ_PREFIX_LENGTH);
            if (n3 > 0) {
                return string.substring(DLQ_PREFIX_LENGTH, n3);
            }
            return "";
        }
        int n4 = string.indexOf(37);
        if (n4 > 0) {
            return string.substring(0, n4);
        }
        return "";
    }

    private static boolean isSystemResource(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        if (MixAll.isSystemTopic(string)) {
            return true;
        }
        if (MixAll.isSysConsumerGroup(string)) {
            return true;
        }
        return "TBW102".equals(string);
    }

    public static boolean isRetryTopic(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.startsWith("%RETRY%");
    }

    public static boolean isDLQTopic(String string) {
        if (StringUtils.isEmpty(string)) {
            return false;
        }
        return string.startsWith("%DLQ%");
    }
}

