/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.queue;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.queue.RoundQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentTreeMap<K, V> {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqBroker");
    private final ReentrantLock lock;
    private TreeMap<K, V> tree;
    private RoundQueue<K> roundQueue;

    public ConcurrentTreeMap(int n2, Comparator<? super K> comparator) {
        this.tree = new TreeMap(comparator);
        this.roundQueue = new RoundQueue(n2);
        this.lock = new ReentrantLock(true);
    }

    public Map.Entry<K, V> pollFirstEntry() {
        this.lock.lock();
        try {
            Map.Entry<K, V> entry = this.tree.pollFirstEntry();
            return entry;
        }
        finally {
            this.lock.unlock();
        }
    }

    public V putIfAbsentAndRetExsit(K object, V v2) {
        this.lock.lock();
        try {
            if (this.roundQueue.put(object)) {
                V v3 = this.tree.get(object);
                if (v3 == null) {
                    this.tree.put(object, v2);
                    v3 = v2;
                }
                log.warn("putIfAbsentAndRetExsit success. " + object);
                object = v3;
                return (V)object;
            }
            V v4 = this.tree.get(object);
            object = v4;
            return (V)object;
        }
        finally {
            this.lock.unlock();
        }
    }
}

