/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsBrief {
    public static final int META_RANGE_INDEX = 0;
    public static final int META_SLOT_NUM_INDEX = 1;
    private long[][] topPercentileMeta;
    private AtomicInteger[] counts;
    private AtomicLong totalCount;
    private long max;
    private long min;
    private long total;

    public StatisticsBrief(long[][] lArray) {
        if (!StatisticsBrief.isLegalMeta(lArray)) {
            throw new IllegalArgumentException("illegal topPercentileMeta");
        }
        this.topPercentileMeta = lArray;
        this.counts = new AtomicInteger[StatisticsBrief.slotNum(lArray)];
        this.totalCount = new AtomicLong(0L);
        this.reset();
    }

    public void reset() {
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            if (this.counts[i2] == null) {
                this.counts[i2] = new AtomicInteger(0);
                continue;
            }
            this.counts[i2].set(0);
        }
        this.totalCount.set(0L);
        StatisticsBrief statisticsBrief = this;
        synchronized (statisticsBrief) {
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.total = 0L;
            return;
        }
    }

    private static boolean isLegalMeta(long[][] lArray) {
        if (ArrayUtils.isEmpty((Object[])lArray)) {
            return false;
        }
        for (long[] lArray2 : lArray) {
            if (!ArrayUtils.isEmpty(lArray2) && lArray2.length == 2) continue;
            return false;
        }
        return true;
    }

    private static int slotNum(long[][] lArray) {
        int n2 = 1;
        for (long[] lArray2 : lArray) {
            n2 = (int)((long)n2 + lArray2[1]);
        }
        return n2;
    }

    public void sample(long l2) {
        int n2 = this.getSlotIndex(l2);
        this.counts[n2].incrementAndGet();
        this.totalCount.incrementAndGet();
        StatisticsBrief statisticsBrief = this;
        synchronized (statisticsBrief) {
            this.max = Math.max(this.max, l2);
            this.min = Math.min(this.min, l2);
            this.total += l2;
            return;
        }
    }

    public long tp999() {
        return this.getTPValue(0.999f);
    }

    public long getTPValue(float f2) {
        long l2;
        long l3;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            f2 = 0.99f;
        }
        if ((l3 = (long)((float)(l2 = this.totalCount.get()) - (float)l2 * f2)) == 0L) {
            return this.getMax();
        }
        int n2 = 0;
        for (int i2 = this.counts.length - 1; i2 > 0; --i2) {
            if ((long)(n2 += this.counts[i2].get()) <= l3) continue;
            return Math.min(this.getSlotTPValue(i2), this.getMax());
        }
        return 0L;
    }

    private long getSlotTPValue(int n2) {
        for (int i2 = 0; i2 < this.topPercentileMeta.length; ++i2) {
            int n3 = (int)this.topPercentileMeta[i2][1];
            if (n2 < n3) {
                long l2 = this.topPercentileMeta[i2][0];
                long l3 = 0L;
                if (i2 > 0) {
                    l3 = this.topPercentileMeta[i2 - 1][0];
                }
                return l3 + (l2 - l3) / (long)n3 * (long)(n2 + 1);
            }
            n2 -= n3;
        }
        return Integer.MAX_VALUE;
    }

    private int getSlotIndex(long l2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.topPercentileMeta.length; ++i2) {
            long l3 = this.topPercentileMeta[i2][0];
            int n3 = (int)this.topPercentileMeta[i2][1];
            long l4 = i2 > 0 ? this.topPercentileMeta[i2 - 1][0] : 0L;
            if (l4 <= l2 && l2 < l3) {
                n2 = (int)((long)n2 + (l2 - l4) / ((l3 - l4) / (long)n3));
                break;
            }
            n2 += n3;
        }
        return n2;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        if (this.totalCount.get() > 0L) {
            return this.min;
        }
        return 0L;
    }

    public long getTotal() {
        return this.total;
    }

    public long getCnt() {
        return this.totalCount.get();
    }

    public double getAvg() {
        if (this.totalCount.get() != 0L) {
            return (double)this.total / (double)this.totalCount.get();
        }
        return 0.0;
    }
}

