/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.Interceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBrief;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import com.aliyun.openservices.shade.org.apache.commons.lang3.tuple.Pair;

public class StatisticsBriefInterceptor
implements Interceptor {
    private int[] indexOfItems;
    private StatisticsBrief[] statisticsBriefs;

    public StatisticsBriefInterceptor(StatisticsItem statisticsItem, Pair<String, long[][]>[] pairArray) {
        this.indexOfItems = new int[pairArray.length];
        this.statisticsBriefs = new StatisticsBrief[pairArray.length];
        for (int i2 = 0; i2 < pairArray.length; ++i2) {
            String string = pairArray[i2].getKey();
            int n2 = ArrayUtils.indexOf(statisticsItem.getItemNames(), string);
            if (n2 < 0) {
                throw new IllegalArgumentException("illegal breifItemName: " + string);
            }
            this.indexOfItems[i2] = n2;
            this.statisticsBriefs[i2] = new StatisticsBrief(pairArray[i2].getValue());
        }
    }

    @Override
    public void inc(long ... lArray) {
        for (int i2 = 0; i2 < this.indexOfItems.length; ++i2) {
            int n2 = this.indexOfItems[i2];
            if (n2 >= lArray.length) continue;
            this.statisticsBriefs[i2].sample(lArray[n2]);
        }
    }

    @Override
    public void reset() {
        StatisticsBrief[] statisticsBriefArray = this.statisticsBriefs;
        int n2 = this.statisticsBriefs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StatisticsBrief statisticsBrief = statisticsBriefArray[i2];
            statisticsBrief.reset();
        }
    }

    public int[] getIndexOfItems() {
        return this.indexOfItems;
    }

    public void setIndexOfItems(int[] nArray) {
        this.indexOfItems = nArray;
    }

    public StatisticsBrief[] getStatisticsBriefs() {
        return this.statisticsBriefs;
    }

    public void setStatisticsBriefs(StatisticsBrief[] statisticsBriefArray) {
        this.statisticsBriefs = statisticsBriefArray;
    }
}

