/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.Interceptor;
import com.aliyun.openservices.shade.org.apache.commons.lang3.ArrayUtils;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsItem {
    private String statKind;
    private String statObject;
    private String[] itemNames;
    private AtomicLong[] itemAccumulates;
    private AtomicLong invokeTimes;
    private Interceptor interceptor;
    private AtomicLong lastTimeStamp;

    public StatisticsItem(String atomicLongArray, String string, String ... stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            throw new InvalidParameterException("StatisticsItem \"itemNames\" is empty");
        }
        this.statKind = atomicLongArray;
        this.statObject = string;
        this.itemNames = stringArray;
        atomicLongArray = new AtomicLong[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            atomicLongArray[i2] = new AtomicLong(0L);
        }
        this.itemAccumulates = atomicLongArray;
        this.invokeTimes = new AtomicLong();
        this.lastTimeStamp = new AtomicLong(System.currentTimeMillis());
    }

    public void incItems(long ... lArray) {
        int n2 = Math.min(lArray.length, this.itemAccumulates.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.itemAccumulates[i2].addAndGet(lArray[i2]);
        }
        this.invokeTimes.addAndGet(1L);
        this.lastTimeStamp.set(System.currentTimeMillis());
        if (this.interceptor != null) {
            this.interceptor.inc(lArray);
        }
    }

    public String getStatKind() {
        return this.statKind;
    }

    public String getStatObject() {
        return this.statObject;
    }

    public String[] getItemNames() {
        return this.itemNames;
    }

    public AtomicLong[] getItemAccumulates() {
        return this.itemAccumulates;
    }

    public AtomicLong getInvokeTimes() {
        return this.invokeTimes;
    }

    public AtomicLong getItemAccumulate(String string) {
        int n2 = ArrayUtils.indexOf(this.itemNames, string);
        if (n2 < 0) {
            return new AtomicLong(0L);
        }
        return this.itemAccumulates[n2];
    }

    public StatisticsItem snapshot() {
        StatisticsItem statisticsItem = new StatisticsItem(this.statKind, this.statObject, this.itemNames);
        new StatisticsItem(this.statKind, this.statObject, this.itemNames).itemAccumulates = new AtomicLong[this.itemAccumulates.length];
        for (int i2 = 0; i2 < this.itemAccumulates.length; ++i2) {
            statisticsItem.itemAccumulates[i2] = new AtomicLong(this.itemAccumulates[i2].get());
        }
        statisticsItem.invokeTimes = new AtomicLong(this.invokeTimes.longValue());
        statisticsItem.lastTimeStamp = new AtomicLong(this.lastTimeStamp.longValue());
        return statisticsItem;
    }

    public StatisticsItem subtract(StatisticsItem statisticsItem) {
        if (statisticsItem == null) {
            return this.snapshot();
        }
        if (!(this.statKind.equals(statisticsItem.statKind) && this.statObject.equals(statisticsItem.statObject) && Arrays.equals(this.itemNames, statisticsItem.itemNames))) {
            throw new IllegalArgumentException("StatisticsItem's kind, key and itemNames must be exactly the same");
        }
        StatisticsItem statisticsItem2 = new StatisticsItem(this.statKind, this.statObject, this.itemNames);
        new StatisticsItem(this.statKind, this.statObject, this.itemNames).invokeTimes = new AtomicLong(this.invokeTimes.get() - statisticsItem.invokeTimes.get());
        statisticsItem2.itemAccumulates = new AtomicLong[this.itemAccumulates.length];
        for (int i2 = 0; i2 < this.itemAccumulates.length; ++i2) {
            statisticsItem2.itemAccumulates[i2] = new AtomicLong(this.itemAccumulates[i2].get() - statisticsItem.itemAccumulates[i2].get());
        }
        return statisticsItem2;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }
}

