/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.Interceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBrief;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBriefInterceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemPrinter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemScheduledIncrementPrinter$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemScheduledIncrementPrinter$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItemScheduledPrinter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StatisticsItemScheduledIncrementPrinter
extends StatisticsItemScheduledPrinter {
    private String[] tpsItemNames;
    public static final int TPS_INITIAL_DELAY = 0;
    public static final int TPS_INTREVAL = 1000;
    public static final String SEPERATOR = "|";
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> lastItemSnapshots = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief>> sampleBriefs = new ConcurrentHashMap();

    public StatisticsItemScheduledIncrementPrinter(String string, StatisticsItemPrinter statisticsItemPrinter, ScheduledExecutorService scheduledExecutorService, StatisticsItemScheduledPrinter.InitialDelay initialDelay, long l2, String[] stringArray, StatisticsItemScheduledPrinter.Enable enable) {
        super(string, statisticsItemPrinter, scheduledExecutorService, initialDelay, l2, enable);
        this.tpsItemNames = stringArray;
    }

    @Override
    public void schedule(StatisticsItem statisticsItem) {
        this.setItemSampleBrief(statisticsItem.getStatKind(), statisticsItem.getStatObject(), new StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief(statisticsItem, this.tpsItemNames));
        this.executor.scheduleAtFixedRate(new StatisticsItemScheduledIncrementPrinter$1(this, statisticsItem), this.getInitialDelay(), this.interval, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(new StatisticsItemScheduledIncrementPrinter$2(this, statisticsItem), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private StatisticsItem getItemSnapshot(ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> concurrentHashMap, String string, String string2) {
        if ((concurrentHashMap = concurrentHashMap.get(string)) != null) {
            return (StatisticsItem)concurrentHashMap.get(string2);
        }
        return null;
    }

    private StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief getSampleBrief(String object, String string) {
        if ((object = this.sampleBriefs.get(object)) != null) {
            return (StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief)((ConcurrentHashMap)object).get(string);
        }
        return null;
    }

    private void setItemSnapshot(ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> concurrentHashMap, StatisticsItem statisticsItem) {
        String string = statisticsItem.getStatKind();
        String string2 = statisticsItem.getStatObject();
        ConcurrentHashMap<String, Object> concurrentHashMap2 = concurrentHashMap.get(string);
        if (concurrentHashMap2 == null && (concurrentHashMap = concurrentHashMap.putIfAbsent(string, concurrentHashMap2 = new ConcurrentHashMap())) != null) {
            concurrentHashMap2 = concurrentHashMap;
        }
        concurrentHashMap2.put(string2, statisticsItem);
    }

    private void setItemSampleBrief(String object, String string, StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief statisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief) {
        ConcurrentHashMap<String, StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief> concurrentHashMap = this.sampleBriefs.get(object);
        if (concurrentHashMap == null && (object = this.sampleBriefs.putIfAbsent((String)object, concurrentHashMap = new ConcurrentHashMap())) != null) {
            concurrentHashMap = object;
        }
        concurrentHashMap.put(string, statisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief);
    }

    private boolean hasIncreased(StatisticsItem atomicLongArray) {
        if (atomicLongArray.getInvokeTimes().get() == 0L) {
            return false;
        }
        for (AtomicLong atomicLong : atomicLongArray.getItemAccumulates()) {
            if (atomicLong.get() == 0L) continue;
            return true;
        }
        return false;
    }

    private String formatInterceptor(Interceptor statisticsBriefArray) {
        if (statisticsBriefArray == null) {
            return "";
        }
        if (statisticsBriefArray instanceof StatisticsBriefInterceptor) {
            StringBuilder stringBuilder = new StringBuilder();
            statisticsBriefArray = (StatisticsBriefInterceptor)statisticsBriefArray;
            for (StatisticsBrief statisticsBrief : statisticsBriefArray.getStatisticsBriefs()) {
                long l2 = statisticsBrief.getMax();
                long l3 = Math.min(statisticsBrief.tp999(), l2);
                stringBuilder.append(SEPERATOR).append(l2);
                stringBuilder.append(SEPERATOR).append(String.format("%.2f", statisticsBrief.getAvg()));
                stringBuilder.append(SEPERATOR).append(l3);
            }
            return stringBuilder.toString();
        }
        return "";
    }

    static /* synthetic */ ConcurrentHashMap access$000(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter) {
        return statisticsItemScheduledIncrementPrinter.lastItemSnapshots;
    }

    static /* synthetic */ StatisticsItem access$100(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter, ConcurrentHashMap concurrentHashMap, String string, String string2) {
        return statisticsItemScheduledIncrementPrinter.getItemSnapshot(concurrentHashMap, string, string2);
    }

    static /* synthetic */ String access$200(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter, Interceptor interceptor) {
        return statisticsItemScheduledIncrementPrinter.formatInterceptor(interceptor);
    }

    static /* synthetic */ StatisticsItemScheduledIncrementPrinter$StatisticsItemSampleBrief access$300(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter, String string, String string2) {
        return statisticsItemScheduledIncrementPrinter.getSampleBrief(string, string2);
    }

    static /* synthetic */ boolean access$400(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter, StatisticsItem statisticsItem) {
        return statisticsItemScheduledIncrementPrinter.hasIncreased(statisticsItem);
    }

    static /* synthetic */ void access$500(StatisticsItemScheduledIncrementPrinter statisticsItemScheduledIncrementPrinter, ConcurrentHashMap concurrentHashMap, StatisticsItem statisticsItem) {
        statisticsItemScheduledIncrementPrinter.setItemSnapshot(concurrentHashMap, statisticsItem);
    }
}

