/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsBriefInterceptor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.statistics.StatisticsKindMeta;
import com.aliyun.openservices.shade.org.apache.commons.lang3.tuple.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StatisticsManager {
    private Map<String, StatisticsKindMeta> kindMetaMap;
    private Pair<String, long[][]>[] briefMetas;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, StatisticsItem>> statsTable = new ConcurrentHashMap();

    public StatisticsManager() {
        this.kindMetaMap = new HashMap<String, StatisticsKindMeta>();
    }

    public StatisticsManager(Map<String, StatisticsKindMeta> map) {
        this.kindMetaMap = map;
    }

    public void addStatisticsKindMeta(StatisticsKindMeta statisticsKindMeta) {
        this.kindMetaMap.put(statisticsKindMeta.getName(), statisticsKindMeta);
        this.statsTable.putIfAbsent(statisticsKindMeta.getName(), new ConcurrentHashMap(16));
    }

    public void setBriefMeta(Pair<String, long[][]>[] pairArray) {
        this.briefMetas = pairArray;
    }

    public boolean inc(String object, String string, long ... lArray) {
        ConcurrentHashMap<String, StatisticsItem> concurrentHashMap = this.statsTable.get(object);
        if (concurrentHashMap != null) {
            Object object2 = concurrentHashMap.get(string);
            if (object2 == null) {
                object2 = new StatisticsItem((String)object, string, this.kindMetaMap.get(object).getItemNames());
                ((StatisticsItem)object2).setInterceptor(new StatisticsBriefInterceptor((StatisticsItem)object2, this.briefMetas));
                object = concurrentHashMap.putIfAbsent(string, (StatisticsItem)object2);
                if (object != null) {
                    object2 = object;
                } else {
                    this.scheduleStatisticsItem((StatisticsItem)object2);
                }
            }
            ((StatisticsItem)object2).incItems(lArray);
            return true;
        }
        return false;
    }

    private void scheduleStatisticsItem(StatisticsItem statisticsItem) {
        this.kindMetaMap.get(statisticsItem.getStatKind()).getScheduledPrinter().schedule(statisticsItem);
    }
}

