/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.MomentStatsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.MomentStatsItemSet$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MomentStatsItemSet {
    private final ConcurrentMap<String, MomentStatsItem> statsItemTable = new ConcurrentHashMap<String, MomentStatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public MomentStatsItemSet(String string, ScheduledExecutorService scheduledExecutorService, InternalLogger internalLogger) {
        this.statsName = string;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = internalLogger;
        this.init();
    }

    public ConcurrentMap<String, MomentStatsItem> getStatsItemTable() {
        return this.statsItemTable;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new MomentStatsItemSet$1(this), Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 300000L, TimeUnit.MILLISECONDS);
    }

    private void printAtMinutes() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((MomentStatsItem)entry.getValue()).printAtMinutes();
        }
    }

    public void setValue(String object, int n2) {
        object = this.getAndCreateStatsItem((String)object);
        ((MomentStatsItem)object).getValue().set(n2);
    }

    public MomentStatsItem getAndCreateStatsItem(String string) {
        MomentStatsItem momentStatsItem = (MomentStatsItem)this.statsItemTable.get(string);
        if (momentStatsItem == null) {
            momentStatsItem = new MomentStatsItem(this.statsName, string, this.scheduledExecutorService, this.log);
            this.statsItemTable.put(string, momentStatsItem);
        }
        return momentStatsItem;
    }

    static /* synthetic */ void access$000(MomentStatsItemSet momentStatsItemSet) {
        momentStatsItemSet.printAtMinutes();
    }
}

