/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.CallSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem$6;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.AbstractCollection;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class StatsItem {
    private final AtomicLong value = new AtomicLong(0L);
    private final AtomicLong times = new AtomicLong(0L);
    private final LinkedList<CallSnapshot> csListMinute = new LinkedList();
    private final LinkedList<CallSnapshot> csListHour = new LinkedList();
    private final LinkedList<CallSnapshot> csListDay = new LinkedList();
    private final String statsName;
    private final String statsKey;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public StatsItem(String string, String string2, ScheduledExecutorService scheduledExecutorService, InternalLogger internalLogger) {
        this.statsName = string;
        this.statsKey = string2;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = internalLogger;
    }

    private static StatsSnapshot computeStatsData(LinkedList<CallSnapshot> object) {
        StatsSnapshot statsSnapshot = new StatsSnapshot();
        LinkedList<CallSnapshot> linkedList = object;
        synchronized (linkedList) {
            double d2 = 0.0;
            double d3 = 0.0;
            long l2 = 0L;
            if (!((AbstractCollection)object).isEmpty()) {
                long l3;
                CallSnapshot callSnapshot = ((LinkedList)object).getFirst();
                object = ((LinkedList)object).getLast();
                l2 = ((CallSnapshot)object).getValue() - callSnapshot.getValue();
                long l4 = ((CallSnapshot)object).getTimestamp() - callSnapshot.getTimestamp();
                if (l4 > 0L) {
                    d2 = (double)l2 * 1000.0 / (double)l4;
                }
                if ((l3 = ((CallSnapshot)object).getTimes() - callSnapshot.getTimes()) > 0L) {
                    d3 = (double)l2 / (double)l3;
                }
            }
            statsSnapshot.setSum(l2);
            statsSnapshot.setTps(d2);
            statsSnapshot.setAvgpt(d3);
        }
        return statsSnapshot;
    }

    public StatsSnapshot getStatsDataInMinute() {
        return StatsItem.computeStatsData(this.csListMinute);
    }

    public StatsSnapshot getStatsDataInHour() {
        return StatsItem.computeStatsData(this.csListHour);
    }

    public StatsSnapshot getStatsDataInDay() {
        return StatsItem.computeStatsData(this.csListDay);
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$1(this), 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$2(this), 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$3(this), 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$4(this), Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$5(this), Math.abs(UtilAll.computNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItem$6(this), Math.abs(UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis()) - 2000L, 86400000L, TimeUnit.MILLISECONDS);
    }

    public void samplingInSeconds() {
        LinkedList<CallSnapshot> linkedList = this.csListMinute;
        synchronized (linkedList) {
            this.csListMinute.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
            if (this.csListMinute.size() > 7) {
                this.csListMinute.removeFirst();
            }
            return;
        }
    }

    public void samplingInMinutes() {
        LinkedList<CallSnapshot> linkedList = this.csListHour;
        synchronized (linkedList) {
            this.csListHour.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
            if (this.csListHour.size() > 7) {
                this.csListHour.removeFirst();
            }
            return;
        }
    }

    public void samplingInHour() {
        LinkedList<CallSnapshot> linkedList = this.csListDay;
        synchronized (linkedList) {
            this.csListDay.add(new CallSnapshot(System.currentTimeMillis(), this.times.get(), this.value.get()));
            if (this.csListDay.size() > 25) {
                this.csListDay.removeFirst();
            }
            return;
        }
    }

    public void printAtMinutes() {
        StatsSnapshot statsSnapshot = StatsItem.computeStatsData(this.csListMinute);
        this.log.info(String.format("[%s] [%s] Stats In One Minute, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, statsSnapshot.getSum(), statsSnapshot.getTps(), statsSnapshot.getAvgpt()));
    }

    public void printAtHour() {
        StatsSnapshot statsSnapshot = StatsItem.computeStatsData(this.csListHour);
        this.log.info(String.format("[%s] [%s] Stats In One Hour, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, statsSnapshot.getSum(), statsSnapshot.getTps(), statsSnapshot.getAvgpt()));
    }

    public void printAtDay() {
        StatsSnapshot statsSnapshot = StatsItem.computeStatsData(this.csListDay);
        this.log.info(String.format("[%s] [%s] Stats In One Day, SUM: %d TPS: %.2f AVGPT: %.2f", this.statsName, this.statsKey, statsSnapshot.getSum(), statsSnapshot.getTps(), statsSnapshot.getAvgpt()));
    }

    public AtomicLong getValue() {
        return this.value;
    }

    public String getStatsKey() {
        return this.statsKey;
    }

    public String getStatsName() {
        return this.statsName;
    }

    public AtomicLong getTimes() {
        return this.times;
    }

    public LinkedList<CallSnapshot> getCsListHour() {
        return this.csListHour;
    }
}

