/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.CallSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItem;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsItemSet$6;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.stats.StatsSnapshot;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StatsItemSet {
    private final ConcurrentMap<String, StatsItem> statsItemTable = new ConcurrentHashMap<String, StatsItem>(128);
    private final String statsName;
    private final ScheduledExecutorService scheduledExecutorService;
    private final InternalLogger log;

    public StatsItemSet(String string, ScheduledExecutorService scheduledExecutorService, InternalLogger internalLogger) {
        this.statsName = string;
        this.scheduledExecutorService = scheduledExecutorService;
        this.log = internalLogger;
        this.init();
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$1(this), 0L, 10L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$2(this), 0L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$3(this), 0L, 1L, TimeUnit.HOURS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$4(this), Math.abs(UtilAll.computNextMinutesTimeMillis() - System.currentTimeMillis()), 60000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$5(this), Math.abs(UtilAll.computNextHourTimeMillis() - System.currentTimeMillis()), 3600000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(new StatsItemSet$6(this), Math.abs(UtilAll.computNextMorningTimeMillis() - System.currentTimeMillis()), 86400000L, TimeUnit.MILLISECONDS);
    }

    private void samplingInSeconds() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((StatsItem)entry.getValue()).samplingInSeconds();
        }
    }

    private void samplingInMinutes() {
        Iterator iterator = this.statsItemTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            object = (StatsItem)object.getValue();
            ((StatsItem)object).samplingInMinutes();
            if ((object = ((StatsItem)object).getCsListHour()) == null || ((LinkedList)object).size() < 7) continue;
            CallSnapshot callSnapshot = ((LinkedList)object).getFirst();
            object = ((LinkedList)object).getLast();
            if (callSnapshot.getTimes() != ((CallSnapshot)object).getTimes() || callSnapshot.getValue() != ((CallSnapshot)object).getValue()) continue;
            iterator.remove();
        }
    }

    private void samplingInHour() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((StatsItem)entry.getValue()).samplingInHour();
        }
    }

    private void printAtMinutes() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((StatsItem)entry.getValue()).printAtMinutes();
        }
    }

    private void printAtHour() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((StatsItem)entry.getValue()).printAtHour();
        }
    }

    private void printAtDay() {
        for (Map.Entry entry : this.statsItemTable.entrySet()) {
            ((StatsItem)entry.getValue()).printAtDay();
        }
    }

    public void addValue(String object, int n2, int n3) {
        object = this.getAndCreateStatsItem((String)object);
        ((StatsItem)object).getValue().addAndGet(n2);
        ((StatsItem)object).getTimes().addAndGet(n3);
    }

    public StatsItem getAndCreateStatsItem(String string) {
        StatsItem statsItem = (StatsItem)this.statsItemTable.get(string);
        if (statsItem == null) {
            statsItem = new StatsItem(this.statsName, string, this.scheduledExecutorService, this.log);
            this.statsItemTable.put(string, statsItem);
        }
        return statsItem;
    }

    public StatsSnapshot getStatsDataInMinute(String object) {
        if ((object = (StatsItem)this.statsItemTable.get(object)) != null) {
            return ((StatsItem)object).getStatsDataInMinute();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInHour(String object) {
        if ((object = (StatsItem)this.statsItemTable.get(object)) != null) {
            return ((StatsItem)object).getStatsDataInHour();
        }
        return new StatsSnapshot();
    }

    public StatsSnapshot getStatsDataInDay(String object) {
        if ((object = (StatsItem)this.statsItemTable.get(object)) != null) {
            return ((StatsItem)object).getStatsDataInDay();
        }
        return new StatsSnapshot();
    }

    public StatsItem getStatsItem(String string) {
        return (StatsItem)this.statsItemTable.get(string);
    }

    static /* synthetic */ void access$000(StatsItemSet statsItemSet) {
        statsItemSet.samplingInSeconds();
    }

    static /* synthetic */ void access$100(StatsItemSet statsItemSet) {
        statsItemSet.samplingInMinutes();
    }

    static /* synthetic */ void access$200(StatsItemSet statsItemSet) {
        statsItemSet.samplingInHour();
    }

    static /* synthetic */ void access$300(StatsItemSet statsItemSet) {
        statsItemSet.printAtMinutes();
    }

    static /* synthetic */ void access$400(StatsItemSet statsItemSet) {
        statsItemSet.printAtHour();
    }

    static /* synthetic */ void access$500(StatsItemSet statsItemSet) {
        statsItemSet.printAtDay();
    }
}

