/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InnerLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.Slf4jLoggerFactory;
import java.util.concurrent.ConcurrentHashMap;

public abstract class InternalLoggerFactory {
    public static final String LOGGER_SLF4J = "slf4j";
    public static final String LOGGER_INNER = "inner";
    public static final String DEFAULT_LOGGER = "slf4j";
    private static String loggerType = null;
    private static ConcurrentHashMap<String, InternalLoggerFactory> loggerFactoryCache = new ConcurrentHashMap();

    public static InternalLogger getLogger(Class clazz) {
        return InternalLoggerFactory.getLogger(clazz.getName());
    }

    public static InternalLogger getLogger(String string) {
        return InternalLoggerFactory.getLoggerFactory().getLoggerInstance(string);
    }

    private static InternalLoggerFactory getLoggerFactory() {
        InternalLoggerFactory internalLoggerFactory = null;
        if (loggerType != null) {
            internalLoggerFactory = loggerFactoryCache.get(loggerType);
        }
        if (internalLoggerFactory == null) {
            internalLoggerFactory = loggerFactoryCache.get("slf4j");
        }
        if (internalLoggerFactory == null) {
            internalLoggerFactory = loggerFactoryCache.get(LOGGER_INNER);
        }
        if (internalLoggerFactory == null) {
            throw new RuntimeException("[RocketMQ] Logger init failed, please check logger");
        }
        return internalLoggerFactory;
    }

    public static void setCurrentLoggerType(String string) {
        loggerType = string;
    }

    protected void doRegister() {
        String string = this.getLoggerType();
        if (loggerFactoryCache.get(string) != null) {
            return;
        }
        loggerFactoryCache.put(string, this);
    }

    protected abstract void shutdown();

    protected abstract InternalLogger getLoggerInstance(String var1);

    protected abstract String getLoggerType();

    static {
        try {
            new Slf4jLoggerFactory();
        }
        catch (Throwable throwable) {}
        try {
            new InnerLoggerFactory();
        }
        catch (Throwable throwable) {}
    }
}

