/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.Layout;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.SysLogger;
import java.io.InterruptedIOException;

public abstract class Appender {
    public static final int CODE_WRITE_FAILURE = 1;
    public static final int CODE_FLUSH_FAILURE = 2;
    public static final int CODE_CLOSE_FAILURE = 3;
    public static final int CODE_FILE_OPEN_FAILURE = 4;
    public static final String LINE_SEP = System.getProperty("line.separator");
    boolean firstTime = true;
    protected Layout layout;
    protected String name;
    protected boolean closed = false;

    public void activateOptions() {
    }

    protected abstract void append(LoggingEvent var1);

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            SysLogger.error("Finalizing appender named [" + this.name + "]. error", throwable);
        }
        if (this.closed) {
            return;
        }
        SysLogger.debug("Finalizing appender named [" + this.name + "].");
        this.close();
    }

    public Layout getLayout() {
        return this.layout;
    }

    public final String getName() {
        return this.name;
    }

    public synchronized void doAppend(LoggingEvent loggingEvent) {
        if (this.closed) {
            SysLogger.error("Attempted to append to closed appender named [" + this.name + "].");
            return;
        }
        this.append(loggingEvent);
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setName(String string) {
        this.name = string;
    }

    public abstract void close();

    public void handleError(String string, Exception exception, int n2) {
        if (exception instanceof InterruptedIOException || exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (this.firstTime) {
            SysLogger.error(string + " code:" + n2, exception);
            this.firstTime = false;
        }
    }

    public void handleError(String string) {
        if (this.firstTime) {
            SysLogger.error(string);
            this.firstTime = false;
        }
    }
}

