/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner;

import java.io.Serializable;

public class Level
implements Serializable {
    transient int level;
    transient String levelStr;
    transient int syslogEquivalent;
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int ERROR_INT = 40000;
    public static final int WARN_INT = 30000;
    public static final int INFO_INT = 20000;
    public static final int DEBUG_INT = 10000;
    public static final int ALL_INT = Integer.MIN_VALUE;
    private static final String ALL_NAME = "ALL";
    private static final String DEBUG_NAME = "DEBUG";
    private static final String INFO_NAME = "INFO";
    private static final String WARN_NAME = "WARN";
    private static final String ERROR_NAME = "ERROR";
    private static final String OFF_NAME = "OFF";
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF", 0);
    public static final Level ERROR = new Level(40000, "ERROR", 3);
    public static final Level WARN = new Level(30000, "WARN", 4);
    public static final Level INFO = new Level(20000, "INFO", 6);
    public static final Level DEBUG = new Level(10000, "DEBUG", 7);
    public static final Level ALL = new Level(Integer.MIN_VALUE, "ALL", 7);
    static final long serialVersionUID = 3491141966387921974L;

    protected Level(int n2, String string, int n3) {
        this.level = n2;
        this.levelStr = string;
        this.syslogEquivalent = n3;
    }

    public static Level toLevel(String string) {
        return Level.toLevel(string, DEBUG);
    }

    public static Level toLevel(int n2) {
        return Level.toLevel(n2, DEBUG);
    }

    public static Level toLevel(int n2, Level level) {
        switch (n2) {
            case -2147483648: {
                return ALL;
            }
            case 10000: {
                return DEBUG;
            }
            case 20000: {
                return INFO;
            }
            case 30000: {
                return WARN;
            }
            case 40000: {
                return ERROR;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        return level;
    }

    public static Level toLevel(String string, Level level) {
        if (string == null) {
            return level;
        }
        if ((string = string.toUpperCase()).equals(ALL_NAME)) {
            return ALL;
        }
        if (string.equals(DEBUG_NAME)) {
            return DEBUG;
        }
        if (string.equals(INFO_NAME)) {
            return INFO;
        }
        if (string.equals(WARN_NAME)) {
            return WARN;
        }
        if (string.equals(ERROR_NAME)) {
            return ERROR;
        }
        if (string.equals(OFF_NAME)) {
            return OFF;
        }
        if (string.equals(INFO_NAME)) {
            return INFO;
        }
        return level;
    }

    public boolean equals(Object object) {
        if (object instanceof Level) {
            object = (Level)object;
            return this.level == ((Level)object).level;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.level;
        n2 = n2 * 31 + (this.levelStr != null ? this.levelStr.hashCode() : 0);
        n2 = n2 * 31 + this.syslogEquivalent;
        return n2;
    }

    public boolean isGreaterOrEqual(Level level) {
        return this.level >= level.level;
    }

    public final String toString() {
        return this.levelStr;
    }

    public final int toInt() {
        return this.level;
    }
}

