/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingBuilder$FileAppender;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingBuilder$RollingCalendar;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.SysLogger;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class LoggingBuilder$DailyRollingFileAppender
extends LoggingBuilder$FileAppender {
    static final int TOP_OF_TROUBLE = -1;
    static final int TOP_OF_MINUTE = 0;
    static final int TOP_OF_HOUR = 1;
    static final int HALF_DAY = 2;
    static final int TOP_OF_DAY = 3;
    static final int TOP_OF_WEEK = 4;
    static final int TOP_OF_MONTH = 5;
    private String datePattern = "'.'yyyy-MM-dd";
    private String scheduledFilename;
    private long nextCheck = System.currentTimeMillis() - 1L;
    Date now = new Date();
    SimpleDateFormat sdf;
    LoggingBuilder$RollingCalendar rc = new LoggingBuilder$RollingCalendar();
    final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");

    public void setDatePattern(String string) {
        this.datePattern = string;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    @Override
    public void activateOptions() {
        super.activateOptions();
        if (this.datePattern != null && this.fileName != null) {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int n2 = this.computeCheckPeriod();
            this.printPeriodicity(n2);
            this.rc.setType(n2);
            File file = new File(this.fileName);
            this.scheduledFilename = this.fileName + this.sdf.format(new Date(file.lastModified()));
            return;
        }
        SysLogger.error("Either File or DatePattern options are not set for appender [" + this.name + "].");
    }

    void printPeriodicity(int n2) {
        switch (n2) {
            case 0: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled every minute.");
                return;
            }
            case 1: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled on top of every hour.");
                return;
            }
            case 2: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled at midday and midnight.");
                return;
            }
            case 3: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled at midnight.");
                return;
            }
            case 4: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled at start of week.");
                return;
            }
            case 5: {
                SysLogger.debug("Appender [" + this.name + "] to be rolled at start of every month.");
                return;
            }
        }
        SysLogger.warn("Unknown periodicity for appender [" + this.name + "].");
    }

    int computeCheckPeriod() {
        LoggingBuilder$RollingCalendar loggingBuilder$RollingCalendar = new LoggingBuilder$RollingCalendar(this.gmtTimeZone, Locale.getDefault());
        Date date = new Date(0L);
        if (this.datePattern != null) {
            for (int i2 = 0; i2 <= 5; ++i2) {
                Object object = new SimpleDateFormat(this.datePattern);
                ((DateFormat)object).setTimeZone(this.gmtTimeZone);
                String string = ((DateFormat)object).format(date);
                loggingBuilder$RollingCalendar.setType(i2);
                Date date2 = new Date(loggingBuilder$RollingCalendar.getNextCheckMillis(date));
                object = ((DateFormat)object).format(date2);
                if (!string.equals(object)) continue;
                return i2;
            }
        }
        return -1;
    }

    void rollOver() {
        File file;
        boolean bl;
        if (this.datePattern == null) {
            this.handleError("Missing DatePattern option in rollOver().");
            return;
        }
        String string = this.fileName + this.sdf.format(this.now);
        if (this.scheduledFilename.equals(string)) {
            return;
        }
        this.closeFile();
        File file2 = new File(this.scheduledFilename);
        if (file2.exists() && !file2.delete()) {
            SysLogger.error("Failed to delete [" + this.scheduledFilename + "].");
        }
        if (bl = (file = new File(this.fileName)).renameTo(file2)) {
            SysLogger.debug(this.fileName + " -> " + this.scheduledFilename);
        } else {
            SysLogger.error("Failed to rename [" + this.fileName + "] to [" + this.scheduledFilename + "].");
        }
        try {
            LoggingBuilder$DailyRollingFileAppender loggingBuilder$DailyRollingFileAppender = this;
            loggingBuilder$DailyRollingFileAppender.setFile(loggingBuilder$DailyRollingFileAppender.fileName, true, this.bufferedIO, this.bufferSize);
        }
        catch (IOException iOException) {
            this.handleError("setFile(" + this.fileName + ", true) call failed.");
        }
        this.scheduledFilename = string;
    }

    @Override
    protected void subAppend(LoggingEvent loggingEvent) {
        long l2 = System.currentTimeMillis();
        if (l2 >= this.nextCheck) {
            this.now.setTime(l2);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                if (iOException instanceof InterruptedIOException) {
                    Thread.currentThread().interrupt();
                }
                SysLogger.error("rollOver() failed.", iOException2);
            }
        }
        super.subAppend(loggingEvent);
    }
}

