/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.Appender;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingBuilder$QuietWriter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.LoggingEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.SysLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class LoggingBuilder$WriterAppender
extends Appender {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected LoggingBuilder$QuietWriter qw;

    public void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    @Override
    public void activateOptions() {
    }

    @Override
    public void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(loggingEvent);
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            SysLogger.warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.qw == null) {
            this.handleError("No output stream or file set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.handleError("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeFooter();
        this.reset();
    }

    protected void closeWriter() {
        if (this.qw != null) {
            try {
                this.qw.close();
                return;
            }
            catch (IOException iOException) {
                this.handleError("Could not close " + this.qw, iOException, 3);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = null;
        String string = this.getEncoding();
        if (string != null) {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
            }
            catch (IOException iOException) {
                SysLogger.warn("Error initializing output writer.");
                SysLogger.warn("Unsupported encoding?");
            }
        }
        if (outputStreamWriter == null) {
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        return outputStreamWriter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public synchronized void setWriter(Writer writer) {
        this.reset();
        this.qw = new LoggingBuilder$QuietWriter(writer, this);
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent loggingEvent) {
        String[] stringArray;
        this.qw.write(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStr()) != null) {
            for (String string : stringArray) {
                this.qw.write(string);
                this.qw.write(LINE_SEP);
            }
        }
        if (this.shouldFlush(loggingEvent)) {
            this.qw.flush();
        }
    }

    protected void reset() {
        this.closeWriter();
        this.qw = null;
    }

    protected void writeFooter() {
        String string;
        if (this.layout != null && (string = this.layout.getFooter()) != null && this.qw != null) {
            this.qw.write(string);
            this.qw.flush();
        }
    }

    protected void writeHeader() {
        String string;
        if (this.layout != null && (string = this.layout.getHeader()) != null && this.qw != null) {
            this.qw.write(string);
        }
    }

    protected boolean shouldFlush(LoggingEvent loggingEvent) {
        return loggingEvent != null && this.immediateFlush;
    }
}

