/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.Level;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.Logger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.inner.SysLogger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class LoggingEvent
implements Serializable {
    public final transient String fqnOfCategoryClass;
    private transient Object message;
    private transient Level level;
    private transient Logger logger;
    private String renderedMessage;
    private String threadName;
    public final long timeStamp;
    private Throwable throwable;

    public LoggingEvent(String string, Logger logger, Level level, Object object, Throwable throwable) {
        this.fqnOfCategoryClass = string;
        this.message = object;
        this.logger = logger;
        this.throwable = throwable;
        this.level = level;
        this.timeStamp = System.currentTimeMillis();
    }

    public Object getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return this.getRenderedMessage();
    }

    public String getRenderedMessage() {
        if (this.renderedMessage == null && this.message != null) {
            this.renderedMessage = this.message instanceof String ? (String)this.message : this.message.toString();
        }
        return this.renderedMessage;
    }

    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public String[] getThrowableStr() {
        if (this.throwable == null) {
            return null;
        }
        Object object = new StringWriter();
        String[] stringArray = new PrintWriter((Writer)object);
        try {
            this.throwable.printStackTrace((PrintWriter)stringArray);
        }
        catch (RuntimeException runtimeException) {
            SysLogger.warn("InnerLogger print stack trace error", runtimeException);
        }
        stringArray.flush();
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(((StringWriter)object).toString()));
        object = new ArrayList();
        try {
            stringArray = lineNumberReader.readLine();
            while (stringArray != null) {
                ((ArrayList)object).add(stringArray);
                stringArray = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            stringArray = iOException;
            if (iOException instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            ((ArrayList)object).add(stringArray.toString());
        }
        stringArray = new String[((ArrayList)object).size()];
        ((ArrayList)object).toArray(stringArray);
        return stringArray;
    }
}

