/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;

public class RemotingHelper {
    public static final String ROCKETMQ_REMOTING = "RocketmqRemoting";
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");

    public static String exceptionSimpleDesc(Throwable object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null) {
            stringBuffer.append(((Throwable)object).toString());
            object = ((Throwable)object).getStackTrace();
            if (object != null && ((StackTraceElement[])object).length > 0) {
                object = object[0];
                stringBuffer.append(", ");
                stringBuffer.append(((StackTraceElement)object).toString());
            }
        }
        return stringBuffer.toString();
    }

    public static SocketAddress string2SocketAddress(String object) {
        object = object.split(":");
        object = new InetSocketAddress(object[0], Integer.parseInt(object[1]));
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RemotingCommand invokeSync(String object, RemotingCommand object2, long l2) {
        RemotingCommand remotingCommand;
        long l3 = System.currentTimeMillis();
        Object object3 = RemotingUtil.string2SocketAddress((String)object);
        if ((object3 = RemotingUtil.connect((SocketAddress)object3)) == null) throw new RemotingConnectException((String)object);
        boolean bl = false;
        try {
            ((AbstractSelectableChannel)object3).configureBlocking(true);
            ((SocketChannel)object3).socket().setSoTimeout((int)l2);
            object2 = ((RemotingCommand)object2).encode();
            while (((Buffer)object2).hasRemaining()) {
                int n2 = ((SocketChannel)object3).write((ByteBuffer)object2);
                if (n2 <= 0) throw new RemotingSendRequestException((String)object);
                if (((Buffer)object2).hasRemaining() && System.currentTimeMillis() - l3 > l2) {
                    throw new RemotingSendRequestException((String)object);
                }
                Thread.sleep(1L);
            }
            bl = true;
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            while (byteBuffer.hasRemaining()) {
                int n3 = ((SocketChannel)object3).read(byteBuffer);
                if (n3 <= 0) throw new RemotingTimeoutException((String)object, l2);
                if (byteBuffer.hasRemaining() && System.currentTimeMillis() - l3 > l2) {
                    throw new RemotingTimeoutException((String)object, l2);
                }
                Thread.sleep(1L);
            }
            int n4 = byteBuffer.getInt(0);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n4);
            while (byteBuffer2.hasRemaining()) {
                int n5 = ((SocketChannel)object3).read(byteBuffer2);
                if (n5 <= 0) throw new RemotingTimeoutException((String)object, l2);
                if (byteBuffer2.hasRemaining() && System.currentTimeMillis() - l3 > l2) {
                    throw new RemotingTimeoutException((String)object, l2);
                }
                Thread.sleep(1L);
            }
            byteBuffer2.flip();
            remotingCommand = RemotingCommand.decode(byteBuffer2);
        }
        catch (IOException iOException) {
            try {
                log.error("invokeSync failure", iOException);
                if (!bl) throw new RemotingSendRequestException((String)object);
                throw new RemotingTimeoutException((String)object, l2);
            }
            catch (Throwable throwable) {
                try {
                    ((AbstractInterruptibleChannel)object3).close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    object2 = iOException2;
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            ((AbstractInterruptibleChannel)object3).close();
            return remotingCommand;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return remotingCommand;
    }

    public static String parseChannelRemoteAddr(Channel object) {
        if (object == null) {
            return "";
        }
        if (((String)(object = (object = object.remoteAddress()) != null ? object.toString() : "")).length() > 0) {
            int n2 = ((String)object).lastIndexOf("/");
            if (n2 >= 0) {
                return ((String)object).substring(n2 + 1);
            }
            return object;
        }
        return "";
    }

    public static String parseSocketAddressAddr(SocketAddress object) {
        if (object != null && ((String)(object = object.toString())).length() > 0) {
            return ((String)object).substring(1);
        }
        return "";
    }
}

