/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil$1;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Enumeration;

public class RemotingUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static boolean isLinuxPlatform = false;
    private static boolean isWindowsPlatform = false;

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static Selector openSelector() {
        Selector selector;
        block7: {
            selector = null;
            if (RemotingUtil.isLinuxPlatform()) {
                try {
                    Object object = Class.forName("sun.nio.ch.EPollSelectorProvider");
                    if (object == null) break block7;
                    try {
                        object = ((Class)object).getMethod("provider", new Class[0]);
                        if (object != null && (object = (SelectorProvider)((Method)object).invoke(null, new Object[0])) != null) {
                            selector = ((SelectorProvider)object).openSelector();
                        }
                    }
                    catch (Exception exception) {
                        log.warn("Open ePoll Selector for linux platform exception", exception);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (selector == null) {
            selector = Selector.open();
        }
        return selector;
    }

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static String getLocalAddress() {
        try {
            Object object;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                Enumeration<InetAddress> object2 = ((NetworkInterface)object).getInetAddresses();
                while (object2.hasMoreElements()) {
                    object = object2.nextElement();
                    if (((InetAddress)object).isLoopbackAddress()) continue;
                    if (object instanceof Inet6Address) {
                        arrayList2.add(RemotingUtil.normalizeHostAddress((InetAddress)object));
                        continue;
                    }
                    arrayList.add(RemotingUtil.normalizeHostAddress((InetAddress)object));
                }
            }
            if (!arrayList.isEmpty()) {
                for (String string : arrayList) {
                    if (string.startsWith("127.0") || string.startsWith("192.168")) continue;
                    return string;
                }
                ArrayList<String> arrayList3 = arrayList;
                return (String)arrayList3.get(arrayList3.size() - 1);
            }
            if (!arrayList2.isEmpty()) {
                return (String)arrayList2.get(0);
            }
            object = InetAddress.getLocalHost();
            return RemotingUtil.normalizeHostAddress((InetAddress)object);
        }
        catch (Exception exception) {
            log.error("Failed to obtain local address", exception);
            return null;
        }
    }

    public static String normalizeHostAddress(InetAddress inetAddress) {
        if (inetAddress instanceof Inet6Address) {
            return "[" + inetAddress.getHostAddress() + "]";
        }
        return inetAddress.getHostAddress();
    }

    public static SocketAddress string2SocketAddress(String object) {
        object = object.split(":");
        object = new InetSocketAddress(object[0], Integer.parseInt(object[1]));
        return object;
    }

    public static String socketAddress2String(SocketAddress socketAddress) {
        StringBuilder stringBuilder = new StringBuilder();
        socketAddress = (InetSocketAddress)socketAddress;
        stringBuilder.append(((InetSocketAddress)socketAddress).getAddress().getHostAddress());
        stringBuilder.append(":");
        stringBuilder.append(((InetSocketAddress)socketAddress).getPort());
        return stringBuilder.toString();
    }

    public static SocketChannel connect(SocketAddress socketAddress) {
        return RemotingUtil.connect(socketAddress, 5000);
    }

    public static SocketChannel connect(SocketAddress serializable, int n2) {
        SocketChannel socketChannel = null;
        try {
            socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            socketChannel.socket().setSoLinger(false, -1);
            socketChannel.socket().setTcpNoDelay(true);
            socketChannel.socket().setReceiveBufferSize(65536);
            socketChannel.socket().setSendBufferSize(65536);
            socketChannel.socket().connect((SocketAddress)serializable, n2);
            socketChannel.configureBlocking(false);
            return socketChannel;
        }
        catch (Exception exception) {
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    serializable = iOException;
                    iOException.printStackTrace();
                }
            }
            return null;
        }
    }

    public static void closeChannel(Channel channel) {
        String string = RemotingHelper.parseChannelRemoteAddr(channel);
        channel.close().addListener(new RemotingUtil$1(string));
    }

    static /* synthetic */ InternalLogger access$000() {
        return log;
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("linux")) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().contains("windows")) {
            isWindowsPlatform = true;
        }
    }
}

