/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;

public abstract class ServiceThread
implements Runnable {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final long JOIN_TIME = 90000L;
    protected final Thread thread;
    protected volatile boolean hasNotified = false;
    protected volatile boolean stopped = false;

    public ServiceThread() {
        ServiceThread serviceThread = this;
        this.thread = new Thread((Runnable)serviceThread, serviceThread.getServiceName());
    }

    public abstract String getServiceName();

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean bl) {
        this.stopped = true;
        log.info("shutdown thread " + this.getServiceName() + " interrupt " + bl);
        ServiceThread serviceThread = this;
        synchronized (serviceThread) {
            if (!this.hasNotified) {
                this.hasNotified = true;
                this.notify();
            }
        }
        try {
            if (bl) {
                this.thread.interrupt();
            }
            long l2 = System.currentTimeMillis();
            this.thread.join(this.getJointime());
            long l3 = System.currentTimeMillis() - l2;
            log.info("join thread " + this.getServiceName() + " eclipse time(ms) " + l3 + " " + this.getJointime());
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("Interrupted", interruptedException);
            return;
        }
    }

    public long getJointime() {
        return 90000L;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

