/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteBuffer;

public class NettyDecoder
extends LengthFieldBasedFrameDecoder {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final int FRAME_MAX_LENGTH = Integer.parseInt(System.getProperty("com.rocketmq.remoting.frameMaxLength", "16777216"));

    public NettyDecoder() {
        super(FRAME_MAX_LENGTH, 0, 4, 0, 4);
    }

    @Override
    public Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf object) {
        ByteBuf byteBuf = null;
        try {
            byteBuf = (ByteBuf)super.decode(channelHandlerContext, (ByteBuf)object);
            if (byteBuf == null) {
                return null;
            }
            object = byteBuf.nioBuffer();
            object = RemotingCommand.decode((ByteBuffer)object);
            return object;
        }
        catch (Exception exception) {
            log.error("decode exception, " + RemotingHelper.parseChannelRemoteAddr(channelHandlerContext.channel()), exception);
            RemotingUtil.closeChannel(channelHandlerContext.channel());
        }
        finally {
            if (byteBuf != null) {
                byteBuf.release();
            }
        }
        return null;
    }
}

