/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.ServiceThread;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

class NettyRemotingAbstract$NettyEventExecutor
extends ServiceThread {
    private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();
    private final int maxSize = 10000;
    final /* synthetic */ NettyRemotingAbstract this$0;

    NettyRemotingAbstract$NettyEventExecutor(NettyRemotingAbstract nettyRemotingAbstract) {
        this.this$0 = nettyRemotingAbstract;
    }

    public void putNettyEvent(NettyEvent nettyEvent) {
        if (this.eventQueue.size() <= 10000) {
            this.eventQueue.add(nettyEvent);
            return;
        }
        NettyRemotingAbstract.access$000().warn("event queue size[{}] enough, so drop this event {}", (Object)this.eventQueue.size(), (Object)nettyEvent.toString());
    }

    @Override
    public void run() {
        NettyRemotingAbstract.access$000().info(((ServiceThread)this).getServiceName() + " service started");
        ChannelEventListener channelEventListener = this.this$0.getChannelEventListener();
        while (!this.isStopped()) {
            try {
                NettyEvent nettyEvent = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                if (nettyEvent != null && channelEventListener != null) {
                    switch (nettyEvent.getType()) {
                        case IDLE: {
                            channelEventListener.onChannelIdle(nettyEvent.getRemoteAddr(), nettyEvent.getChannel());
                            break;
                        }
                        case CLOSE: {
                            channelEventListener.onChannelClose(nettyEvent.getRemoteAddr(), nettyEvent.getChannel());
                            break;
                        }
                        case CONNECT: {
                            channelEventListener.onChannelConnect(nettyEvent.getRemoteAddr(), nettyEvent.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            channelEventListener.onChannelException(nettyEvent.getRemoteAddr(), nettyEvent.getChannel());
                        }
                    }
                }
            }
            catch (Exception exception) {
                NettyRemotingAbstract.access$000().warn(((ServiceThread)this).getServiceName() + " service has exception. ", exception);
            }
        }
        NettyRemotingAbstract.access$000().info(((ServiceThread)this).getServiceName() + " service end");
    }

    @Override
    public String getServiceName() {
        return NettyRemotingAbstract$NettyEventExecutor.class.getSimpleName();
    }
}

