/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyEvent;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract$NettyEventExecutor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.RequestTask;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.ResponseFuture;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.handler.ssl.SslContext;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class NettyRemotingAbstract {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap<Integer, ResponseFuture>(256);
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyRemotingAbstract$NettyEventExecutor nettyEventExecutor = new NettyRemotingAbstract$NettyEventExecutor(this);
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessor;
    protected volatile SslContext sslContext;

    public NettyRemotingAbstract(int n2, int n3) {
        this.semaphoreOneway = new Semaphore(n2, true);
        this.semaphoreAsync = new Semaphore(n3, true);
    }

    public abstract ChannelEventListener getChannelEventListener();

    public void putNettyEvent(NettyEvent nettyEvent) {
        this.nettyEventExecutor.putNettyEvent(nettyEvent);
    }

    public void processMessageReceived(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) {
        if (remotingCommand != null) {
            switch (remotingCommand.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(channelHandlerContext, remotingCommand);
                    return;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(channelHandlerContext, remotingCommand);
                }
            }
        }
    }

    public void processRequestCommand(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) {
        Pair<NettyRequestProcessor, ExecutorService> pair = this.processorTable.get(remotingCommand.getCode());
        pair = pair == null ? this.defaultRequestProcessor : pair;
        int n2 = remotingCommand.getOpaque();
        if (pair != null) {
            NettyRemotingAbstract$1 nettyRemotingAbstract$1 = new NettyRemotingAbstract$1(this, channelHandlerContext, remotingCommand, pair, n2);
            if (pair.getObject1().rejectRequest()) {
                RemotingCommand remotingCommand2 = RemotingCommand.createResponseCommand(2, "[REJECTREQUEST]system busy, start flow control for a while");
                remotingCommand2.setOpaque(n2);
                channelHandlerContext.writeAndFlush(remotingCommand2);
                return;
            }
            try {
                RequestTask requestTask = new RequestTask(nettyRemotingAbstract$1, channelHandlerContext.channel(), remotingCommand);
                pair.getObject2().submit(requestTask);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (System.currentTimeMillis() % 10000L == 0L) {
                    log.warn(RemotingHelper.parseChannelRemoteAddr(channelHandlerContext.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getObject2().toString() + " request code: " + remotingCommand.getCode());
                }
                if (!remotingCommand.isOnewayRPC()) {
                    remotingCommand = RemotingCommand.createResponseCommand(2, "[OVERLOAD]system busy, start flow control for a while");
                    remotingCommand.setOpaque(n2);
                    channelHandlerContext.writeAndFlush(remotingCommand);
                }
                return;
            }
        } else {
            String string = " request type " + remotingCommand.getCode() + " not supported";
            RemotingCommand remotingCommand3 = RemotingCommand.createResponseCommand(3, string);
            remotingCommand3.setOpaque(n2);
            channelHandlerContext.writeAndFlush(remotingCommand3);
            log.error(RemotingHelper.parseChannelRemoteAddr(channelHandlerContext.channel()) + string);
        }
    }

    public void processResponseCommand(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) {
        int n2 = remotingCommand.getOpaque();
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(n2);
        if (responseFuture != null) {
            responseFuture.setResponseCommand(remotingCommand);
            this.responseTable.remove(n2);
            if (responseFuture.getInvokeCallback() != null) {
                this.executeInvokeCallback(responseFuture);
                return;
            }
            responseFuture.putResponse(remotingCommand);
            responseFuture.release();
            return;
        }
        log.warn("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(channelHandlerContext.channel()));
        log.warn(remotingCommand.toString());
    }

    private void executeInvokeCallback(ResponseFuture responseFuture) {
        boolean bl = false;
        ExecutorService executorService = this.getCallbackExecutor();
        if (executorService != null) {
            try {
                executorService.submit(new NettyRemotingAbstract$2(this, responseFuture));
            }
            catch (Exception exception) {
                bl = true;
                log.warn("execute callback in executor exception, maybe executor busy", exception);
            }
        } else {
            bl = true;
        }
        if (bl) {
            try {
                responseFuture.executeInvokeCallback();
                return;
            }
            catch (Throwable throwable) {
                log.warn("executeInvokeCallback Exception", throwable);
                return;
            }
            finally {
                responseFuture.release();
            }
        }
    }

    public abstract List<RPCHook> getRPCHook();

    public abstract ExecutorService getCallbackExecutor();

    public void scanResponseTable() {
        LinkedList<ResponseFuture> linkedList = new LinkedList<ResponseFuture>();
        Iterator iterator = this.responseTable.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ResponseFuture responseFuture = (ResponseFuture)entry.getValue();
            if (responseFuture.getBeginTimestamp() + responseFuture.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            responseFuture.release();
            iterator.remove();
            linkedList.add(responseFuture);
            log.warn("remove timeout request, " + responseFuture);
        }
        for (ResponseFuture responseFuture : linkedList) {
            try {
                this.executeInvokeCallback(responseFuture);
            }
            catch (Throwable throwable) {
                log.warn("scanResponseTable, operationComplete Exception", throwable);
            }
        }
    }

    public RemotingCommand invokeSyncImpl(Channel object, RemotingCommand remotingCommand, long l2) {
        int n2 = remotingCommand.getOpaque();
        try {
            ResponseFuture responseFuture = new ResponseFuture(n2, l2, null, null);
            this.responseTable.put(n2, responseFuture);
            SocketAddress socketAddress = object.remoteAddress();
            object.writeAndFlush(remotingCommand).addListener(new NettyRemotingAbstract$3(this, responseFuture, n2, socketAddress));
            object = responseFuture.waitResponse(l2);
            if (object == null) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseSocketAddressAddr(socketAddress), l2, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseSocketAddressAddr(socketAddress), responseFuture.getCause());
            }
            return object;
        }
        finally {
            this.responseTable.remove(n2);
        }
    }

    public void invokeAsyncImpl(Channel channel, RemotingCommand remotingCommand, long l2, InvokeCallback invokeCallback) {
        int n2 = remotingCommand.getOpaque();
        boolean bl = this.semaphoreAsync.tryAcquire(l2, TimeUnit.MILLISECONDS);
        if (bl) {
            SemaphoreReleaseOnlyOnce semaphoreReleaseOnlyOnce = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            ResponseFuture responseFuture = new ResponseFuture(n2, l2, invokeCallback, semaphoreReleaseOnlyOnce);
            this.responseTable.put(n2, responseFuture);
            try {
                channel.writeAndFlush(remotingCommand).addListener(new NettyRemotingAbstract$4(this, responseFuture, n2, channel));
            }
            catch (Exception exception) {
                responseFuture.release();
                log.warn("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception", exception);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), exception);
            }
        } else {
            if (l2 <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String string = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", l2, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            log.warn(string);
            throw new RemotingTimeoutException(string);
        }
    }

    public void invokeOnewayImpl(Channel channel, RemotingCommand remotingCommand, long l2) {
        remotingCommand.markOnewayRPC();
        boolean bl = this.semaphoreOneway.tryAcquire(l2, TimeUnit.MILLISECONDS);
        if (bl) {
            SemaphoreReleaseOnlyOnce semaphoreReleaseOnlyOnce = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush(remotingCommand).addListener(new NettyRemotingAbstract$5(this, semaphoreReleaseOnlyOnce, channel));
            }
            catch (Exception exception) {
                semaphoreReleaseOnlyOnce.release();
                log.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), exception);
            }
        } else {
            if (l2 <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String string = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", l2, this.semaphoreOneway.getQueueLength(), this.semaphoreOneway.availablePermits());
            log.warn(string);
            throw new RemotingTimeoutException(string);
        }
    }

    static /* synthetic */ InternalLogger access$000() {
        return log;
    }

    static /* synthetic */ void access$100(NettyRemotingAbstract nettyRemotingAbstract, ResponseFuture responseFuture) {
        nettyRemotingAbstract.executeInvokeCallback(responseFuture);
    }

    static {
        NettyLogger.initNettyLogger();
    }
}

