/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RemotingClient;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingSendRequestException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$6;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$ChannelWrapper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingClient$InvokeCallbackWrapper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioSocketChannel;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentMap<String, NettyRemotingClient$ChannelWrapper> channelTables = new ConcurrentHashMap<String, NettyRemotingClient$ChannelWrapper>();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyRemotingClient.initValueIndex());
    private final Lock lockNamesrvChannel = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private ExecutorService callbackExecutor;
    private final ChannelEventListener channelEventListener;
    private EventExecutorGroup defaultEventExecutorGroup;
    private List<RPCHook> rpcHookList = new CopyOnWriteArrayList<RPCHook>();

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        this(nettyClientConfig, channelEventListener, null, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int n2 = nettyClientConfig.getClientCallbackExecutorThreads();
        if (n2 <= 0) {
            n2 = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(n2, new NettyRemotingClient$1(this));
        this.eventLoopGroupWorker = eventLoopGroup != null ? eventLoopGroup : new NioEventLoopGroup(1, new NettyRemotingClient$2(this));
        this.defaultEventExecutorGroup = eventExecutorGroup;
        if (nettyClientConfig.isUseTLS()) {
            try {
                this.sslContext = TlsHelper.buildSslContext(true);
                log.info("SSL enabled for client");
                return;
            }
            catch (IOException iOException) {
                log.error("Failed to create SSLContext", iOException);
                return;
            }
            catch (CertificateException certificateException) {
                log.error("Failed to create SSLContext", certificateException);
                throw new RuntimeException("Failed to create SSLContext", certificateException);
            }
        }
    }

    private static int initValueIndex() {
        Random random = new Random();
        return Math.abs(random.nextInt() % 999) % 999;
    }

    @Override
    public void start() {
        if (this.defaultEventExecutorGroup == null) {
            this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new NettyRemotingClient$3(this));
        }
        Bootstrap cfr_ignored_0 = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, Boolean.TRUE)).option(ChannelOption.SO_KEEPALIVE, Boolean.FALSE)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, this.nettyClientConfig.getClientSocketRcvBufSize())).handler(new NettyRemotingClient$4(this));
        this.timer.scheduleAtFixedRate((TimerTask)new NettyRemotingClient$5(this), 3000L, 1000L);
        this.timer.scheduleAtFixedRate((TimerTask)new NettyRemotingClient$6(this), 3000L, 10000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper : this.channelTables.values()) {
                this.closeChannel(null, NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper));
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception exception) {
            log.error("NettyRemotingClient shutdown exception, ", exception);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
                return;
            }
            catch (Exception exception) {
                log.error("NettyRemotingServer shutdown exception, ", exception);
            }
        }
    }

    public void closeChannel(String string, Channel channel) {
        if (channel == null) {
            return;
        }
        string = string == null ? RemotingHelper.parseChannelRemoteAddr(channel) : string;
        try {
            if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                try {
                    boolean bl = true;
                    NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(string);
                    log.info("closeChannel: begin close the channel[{}] Found: {}", (Object)string, (Object)(nettyRemotingClient$ChannelWrapper != null ? 1 : 0));
                    if (nettyRemotingClient$ChannelWrapper == null) {
                        log.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)string);
                        bl = false;
                    } else if (NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper) != channel) {
                        log.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)string);
                        bl = false;
                    }
                    if (bl) {
                        this.channelTables.remove(string);
                        log.info("closeChannel: the channel[{}] was removed from channel table", (Object)string);
                    }
                    RemotingUtil.closeChannel(channel);
                }
                catch (Exception exception) {
                    log.error("closeChannel: close the channel exception", exception);
                }
                finally {
                    this.lockChannelTables.unlock();
                }
            } else {
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("closeChannel exception", interruptedException);
            return;
        }
    }

    @Override
    public void registerRPCHook(RPCHook rPCHook) {
        if (rPCHook == null) {
            return;
        }
        if (!this.rpcHookList.contains(rPCHook)) {
            this.rpcHookList.add(rPCHook);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                try {
                    boolean bl = true;
                    NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper = null;
                    String string = null;
                    for (Map.Entry entry : this.channelTables.entrySet()) {
                        String string2 = (String)entry.getKey();
                        NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper2 = (NettyRemotingClient$ChannelWrapper)entry.getValue();
                        if (NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper2) == null || NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper2) != channel) continue;
                        nettyRemotingClient$ChannelWrapper = nettyRemotingClient$ChannelWrapper2;
                        string = string2;
                        break;
                    }
                    if (nettyRemotingClient$ChannelWrapper == null) {
                        log.info("eventCloseChannel: the channel[{}] has been removed from the channel table before", (Object)string);
                        bl = false;
                    }
                    if (!bl) return;
                    this.channelTables.remove(string);
                    log.info("closeChannel: the channel[{}] was removed from channel table", (Object)string);
                    RemotingUtil.closeChannel(channel);
                    return;
                }
                catch (Exception exception) {
                    log.error("closeChannel: close the channel exception", exception);
                    return;
                }
                finally {
                    this.lockChannelTables.unlock();
                }
            } else {
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            log.error("closeChannel exception", interruptedException);
            return;
        }
    }

    @Override
    public void updateNameServerAddressList(List<String> list) {
        List<String> list2 = this.namesrvAddrList.get();
        boolean bl = false;
        if (!list.isEmpty()) {
            if (list2 == null) {
                bl = true;
            } else if (list.size() != list2.size()) {
                bl = true;
            } else {
                for (int i2 = 0; i2 < list.size() && !bl; ++i2) {
                    if (list2.contains(list.get(i2))) continue;
                    bl = true;
                }
            }
            if (bl) {
                NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper;
                Collections.shuffle(list);
                log.info("name server address updated. NEW : {} , OLD: {}", (Object)list, (Object)list2);
                this.namesrvAddrList.set(list);
                if (this.namesrvAddrChoosed.get() != null && !list.contains(this.namesrvAddrChoosed.get()) && (nettyRemotingClient$ChannelWrapper = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(this.namesrvAddrChoosed.get())) != null) {
                    this.closeChannel(NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper));
                }
            }
        }
    }

    @Override
    public RemotingCommand invokeSync(String string, RemotingCommand remotingCommand, long l2) {
        Channel channel = this.getAndCreateChannel(string);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRequests(string, remotingCommand);
                RemotingCommand remotingCommand2 = this.invokeSyncImpl(channel, remotingCommand, l2);
                this.doAfterRequests(remotingCommand, channel, remotingCommand2);
                this.updateChannelLastResponseTime(string);
                return remotingCommand2;
            }
            catch (RemotingSendRequestException remotingSendRequestException) {
                log.warn("invokeSync: send request exception, so close the channel[{}]", (Object)string);
                this.closeChannel(string, channel);
                throw remotingSendRequestException;
            }
            catch (RemotingTimeoutException remotingTimeoutException) {
                if (this.nettyClientConfig.isClientCloseSocketIfTimeout()) {
                    this.closeChannel(string, channel);
                    log.warn("invokeSync: close socket because of timeout, {}ms, {}", (Object)l2, (Object)string);
                }
                log.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)string);
                throw remotingTimeoutException;
            }
        }
        this.closeChannel(string, channel);
        throw new RemotingConnectException(string);
    }

    private void doAfterRequests(RemotingCommand remotingCommand, Channel channel, RemotingCommand remotingCommand2) {
        if (this.rpcHookList == null || this.rpcHookList.size() <= 0) {
            return;
        }
        for (RPCHook rPCHook : this.rpcHookList) {
            rPCHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr(channel), remotingCommand, remotingCommand2);
        }
    }

    private void doBeforeRequests(String string, RemotingCommand remotingCommand) {
        if (this.rpcHookList == null || this.rpcHookList.size() <= 0) {
            return;
        }
        for (RPCHook rPCHook : this.rpcHookList) {
            rPCHook.doBeforeRequest(string, remotingCommand);
        }
    }

    private void updateChannelLastResponseTime(String object) {
        if (object == null) {
            object = this.namesrvAddrChoosed.get();
        }
        if (object == null) {
            log.warn("[updateChannelLastResponseTime] could not find address!!");
            return;
        }
        if ((object = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(object)) != null && ((NettyRemotingClient$ChannelWrapper)object).isOK()) {
            ((NettyRemotingClient$ChannelWrapper)object).updateLastResponseTime();
        }
    }

    private Channel getAndCreateChannel(String string) {
        if (string == null) {
            return this.getAndCreateNameserverChannel();
        }
        NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(string);
        if (nettyRemotingClient$ChannelWrapper != null && nettyRemotingClient$ChannelWrapper.isOK()) {
            return NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper);
        }
        return this.createChannel(string);
    }

    private Channel getAndCreateNameserverChannel() {
        Object object;
        Object object2 = this.namesrvAddrChoosed.get();
        if (object2 != null && (object = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(object2)) != null && ((NettyRemotingClient$ChannelWrapper)object).isOK()) {
            return NettyRemotingClient$ChannelWrapper.access$300((NettyRemotingClient$ChannelWrapper)object);
        }
        object = this.namesrvAddrList.get();
        if (this.lockNamesrvChannel.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper;
                object2 = this.namesrvAddrChoosed.get();
                if (object2 != null && (nettyRemotingClient$ChannelWrapper = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(object2)) != null && nettyRemotingClient$ChannelWrapper.isOK()) {
                    Channel channel = NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper);
                    return channel;
                }
                if (object != null && !object.isEmpty()) {
                    for (int i2 = 0; i2 < object.size(); ++i2) {
                        int n2 = this.namesrvIndex.incrementAndGet();
                        n2 = Math.abs(n2);
                        Object object3 = (String)object.get(n2 %= object.size());
                        this.namesrvAddrChoosed.set((String)object3);
                        log.info("new name server is chosen. OLD: {} , NEW: {}. namesrvIndex = {}", object2, object3, this.namesrvIndex);
                        object3 = this.createChannel((String)object3);
                        if (object3 == null) continue;
                        object2 = object3;
                        return object2;
                    }
                }
                this.lockNamesrvChannel.unlock();
            }
            catch (Exception exception) {
                log.error("getAndCreateNameserverChannel: create name server channel exception", exception);
            }
            finally {
                this.lockNamesrvChannel.unlock();
            }
        } else {
            log.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Channel createChannel(String var1_1) {
        block12: {
            var2_3 = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(var1_1);
            if (var2_3 != null && var2_3.isOK()) {
                NettyRemotingClient$ChannelWrapper.access$300(var2_3).close();
                this.channelTables.remove(var1_1);
            }
            if (!this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) break block12;
            try {
                block13: {
                    var2_3 = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(var1_1);
                    if (var2_3 == null) ** GOTO lbl23
                    if (!var2_3.isOK()) break block13;
                    NettyRemotingClient$ChannelWrapper.access$300(var2_3).close();
                    this.channelTables.remove(var1_1);
                    ** GOTO lbl23
                }
                if (!var2_3.getChannelFuture().isDone()) {
                    var3_4 = false;
                } else {
                    this.channelTables.remove(var1_1);
lbl23:
                    // 3 sources

                    var3_4 = true;
                }
                if (!var3_4) ** GOTO lbl39
                var3_5 = this.bootstrap.connect(RemotingHelper.string2SocketAddress(var1_1));
                NettyRemotingClient.log.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)var1_1);
                var2_3 = new NettyRemotingClient$ChannelWrapper(var3_5);
                this.channelTables.put(var1_1, var2_3);
            }
            catch (Exception var3_6) {
                NettyRemotingClient.log.error("createChannel: create channel exception", var3_6);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        }
        NettyRemotingClient.log.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
lbl39:
        // 4 sources

        if (var2_3 != null) {
            var3_7 = var2_3.getChannelFuture();
            if (var3_7.awaitUninterruptibly(this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (var2_3.isOK()) {
                    NettyRemotingClient.log.info("createChannel: connect remote host[{}] success, {}", (Object)var1_1, (Object)var3_7.toString());
                    return NettyRemotingClient$ChannelWrapper.access$300(var2_3);
                }
                NettyRemotingClient.log.warn("createChannel: connect remote host[" + var1_1 + "] failed, " + var3_7.toString(), var3_7.cause());
            } else {
                NettyRemotingClient.log.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{var1_1, this.nettyClientConfig.getConnectTimeoutMillis(), var3_7.toString()});
            }
        }
        return null;
    }

    @Override
    public void invokeAsync(String string, RemotingCommand remotingCommand, long l2, InvokeCallback invokeCallback) {
        Channel channel = this.getAndCreateChannel(string);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRequests(string, remotingCommand);
                this.invokeAsyncImpl(channel, remotingCommand, l2, new NettyRemotingClient$InvokeCallbackWrapper(this, invokeCallback, string));
                return;
            }
            catch (RemotingSendRequestException remotingSendRequestException) {
                log.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)string);
                this.closeChannel(string, channel);
                throw remotingSendRequestException;
            }
        }
        this.closeChannel(string, channel);
        throw new RemotingConnectException(string);
    }

    @Override
    public void invokeOneway(String string, RemotingCommand remotingCommand, long l2) {
        Channel channel = this.getAndCreateChannel(string);
        if (channel != null && channel.isActive()) {
            try {
                this.doBeforeRequests(string, remotingCommand);
                this.invokeOnewayImpl(channel, remotingCommand, l2);
                return;
            }
            catch (RemotingSendRequestException remotingSendRequestException) {
                log.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)string);
                this.closeChannel(string, channel);
                throw remotingSendRequestException;
            }
        }
        this.closeChannel(string, channel);
        throw new RemotingConnectException(string);
    }

    @Override
    public void registerProcessor(int n2, NettyRequestProcessor object, ExecutorService executorService) {
        ExecutorService executorService2 = executorService;
        if (executorService == null) {
            executorService2 = this.publicExecutor;
        }
        object = new Pair<NettyRequestProcessor, ExecutorService>((NettyRequestProcessor)object, executorService2);
        this.processorTable.put(n2, (Pair<NettyRequestProcessor, ExecutorService>)object);
    }

    @Override
    public boolean isChannelWritable(String object) {
        if ((object = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(object)) != null && ((NettyRemotingClient$ChannelWrapper)object).isOK()) {
            return ((NettyRemotingClient$ChannelWrapper)object).isWritable();
        }
        return true;
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public List<RPCHook> getRPCHook() {
        return this.rpcHookList;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        if (this.callbackExecutor != null) {
            return this.callbackExecutor;
        }
        return this.publicExecutor;
    }

    @Override
    public void setCallbackExecutor(ExecutorService executorService) {
        this.callbackExecutor = executorService;
    }

    protected void scanChannelTablesOfNameServer() {
        List<String> list = this.namesrvAddrList.get();
        if (list == null || list.isEmpty()) {
            log.warn("[SCAN] Addresses of name server is empty!");
            return;
        }
        for (String string : list) {
            NettyRemotingClient$ChannelWrapper nettyRemotingClient$ChannelWrapper = (NettyRemotingClient$ChannelWrapper)this.channelTables.get(string);
            if (nettyRemotingClient$ChannelWrapper == null || System.currentTimeMillis() - nettyRemotingClient$ChannelWrapper.getLastResponseTime() <= this.nettyClientConfig.getChannelNotActiveInterval()) continue;
            log.warn("[SCAN] No response after {} from name server {}, so close it!", (Object)nettyRemotingClient$ChannelWrapper.getLastResponseTime(), (Object)string);
            this.closeChannel(string, NettyRemotingClient$ChannelWrapper.access$300(nettyRemotingClient$ChannelWrapper));
        }
    }

    static /* synthetic */ NettyClientConfig access$000(NettyRemotingClient nettyRemotingClient) {
        return nettyRemotingClient.nettyClientConfig;
    }

    static /* synthetic */ EventExecutorGroup access$100(NettyRemotingClient nettyRemotingClient) {
        return nettyRemotingClient.defaultEventExecutorGroup;
    }

    static /* synthetic */ InternalLogger access$200() {
        return log;
    }

    static /* synthetic */ void access$400(NettyRemotingClient nettyRemotingClient, String string) {
        nettyRemotingClient.updateChannelLastResponseTime(string);
    }

    static /* synthetic */ ChannelEventListener access$500(NettyRemotingClient nettyRemotingClient) {
        return nettyRemotingClient.channelEventListener;
    }
}

