/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.TlsMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.FileRegionEncoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.io.netty.channel.SimpleChannelInboundHandler;
import java.util.NoSuchElementException;

class NettyRemotingServer$HandshakeHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final TlsMode tlsMode;
    private static final byte HANDSHAKE_MAGIC_CODE = 22;
    final /* synthetic */ NettyRemotingServer this$0;

    NettyRemotingServer$HandshakeHandler(NettyRemotingServer nettyRemotingServer, TlsMode tlsMode) {
        this.this$0 = nettyRemotingServer;
        this.tlsMode = tlsMode;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        byte by = byteBuf.getByte(0);
        if (by == 22) {
            switch (this.tlsMode) {
                case DISABLED: {
                    channelHandlerContext.close();
                    NettyRemotingServer.access$200().warn("Clients intend to establish a SSL connection while this server is running in SSL disabled mode");
                    break;
                }
                case PERMISSIVE: 
                case ENFORCING: {
                    if (null != this.this$0.sslContext) {
                        channelHandlerContext.pipeline().addAfter(NettyRemotingServer.access$000(this.this$0), "handshakeHandler", "sslHandler", this.this$0.sslContext.newHandler(channelHandlerContext.channel().alloc())).addAfter(NettyRemotingServer.access$000(this.this$0), "sslHandler", "fileRegionEncoder", new FileRegionEncoder());
                        NettyRemotingServer.access$200().info("Handlers prepended to channel pipeline to establish SSL connection");
                        break;
                    }
                    channelHandlerContext.close();
                    NettyRemotingServer.access$200().error("Trying to establish a SSL connection but sslContext is null");
                    break;
                }
                default: {
                    NettyRemotingServer.access$200().warn("Unknown TLS mode");
                    break;
                }
            }
        } else if (this.tlsMode == TlsMode.ENFORCING) {
            channelHandlerContext.close();
            NettyRemotingServer.access$200().warn("Clients intend to establish an insecure connection while this server is running in SSL enforcing mode");
        }
        byteBuf.resetReaderIndex();
        try {
            channelHandlerContext.pipeline().remove(this);
        }
        catch (NoSuchElementException noSuchElementException) {
            NettyRemotingServer.access$200().error("Error while removing HandshakeHandler", noSuchElementException);
        }
        channelHandlerContext.fireChannelRead(byteBuf.retain());
    }
}

