/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.ChannelEventListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RemotingServer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.Pair;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.TlsMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingAbstract;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$3;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$4;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$5;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$6;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRemotingServer$7;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyServerConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.io.netty.bootstrap.ServerBootstrap;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.epoll.Epoll;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.aliyun.openservices.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.aliyun.openservices.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private final ServerBootstrap serverBootstrap;
    private final EventLoopGroup eventLoopGroupSelector;
    private final EventLoopGroup eventLoopGroupBoss;
    private final NettyServerConfig nettyServerConfig;
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private final Timer timer = new Timer("ServerHouseKeepingService", true);
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private List<RPCHook> rpcHookList = new CopyOnWriteArrayList<RPCHook>();
    private int port = 0;
    private static final String HANDSHAKE_HANDLER_NAME = "handshakeHandler";
    private static final String TLS_HANDLER_NAME = "sslHandler";
    private static final String FILE_REGION_ENCODER_NAME = "fileRegionEncoder";

    public NettyRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null);
    }

    public NettyRemotingServer(NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig.getServerOnewaySemaphoreValue(), nettyServerConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.nettyServerConfig = nettyServerConfig;
        this.channelEventListener = channelEventListener;
        int n2 = nettyServerConfig.getServerCallbackExecutorThreads();
        if (n2 <= 0) {
            n2 = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(n2, new NettyRemotingServer$1(this));
        this.eventLoopGroupBoss = new NioEventLoopGroup(1, new NettyRemotingServer$2(this));
        this.eventLoopGroupSelector = this.useEpoll() ? new EpollEventLoopGroup(nettyServerConfig.getServerSelectorThreads(), new NettyRemotingServer$3(this, nettyServerConfig)) : new NioEventLoopGroup(nettyServerConfig.getServerSelectorThreads(), new NettyRemotingServer$4(this, nettyServerConfig));
        this.loadSslContext();
    }

    public void loadSslContext() {
        TlsMode tlsMode = TlsSystemConfig.tlsMode;
        log.info("Server is running in TLS {} mode", (Object)tlsMode.getName());
        if (tlsMode != TlsMode.DISABLED) {
            try {
                this.sslContext = TlsHelper.buildSslContext(false);
                log.info("SSLContext created for server");
                return;
            }
            catch (CertificateException certificateException) {
                log.error("Failed to create SSLContext for server", certificateException);
                return;
            }
            catch (IOException iOException) {
                log.error("Failed to create SSLContext for server", iOException);
            }
        }
    }

    private boolean useEpoll() {
        return RemotingUtil.isLinuxPlatform() && this.nettyServerConfig.isUseEpollNativeSelector() && Epoll.isAvailable();
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), new NettyRemotingServer$5(this));
        Object object = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupSelector).channel(this.useEpoll() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, Boolean.TRUE)).option(ChannelOption.SO_KEEPALIVE, Boolean.FALSE)).childOption(ChannelOption.TCP_NODELAY, Boolean.TRUE).childOption(ChannelOption.SO_SNDBUF, this.nettyServerConfig.getServerSocketSndBufSize()).childOption(ChannelOption.SO_RCVBUF, this.nettyServerConfig.getServerSocketRcvBufSize()).childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, this.nettyServerConfig.getWriteBufferHighWaterMark()).childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, this.nettyServerConfig.getWriteBufferLowWaterMark()).localAddress(new InetSocketAddress(this.nettyServerConfig.getListenPort()))).childHandler(new NettyRemotingServer$6(this));
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            ((ServerBootstrap)object).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        }
        try {
            object = this.serverBootstrap.bind().sync();
            object = (InetSocketAddress)object.channel().localAddress();
            this.port = ((InetSocketAddress)object).getPort();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("this.serverBootstrap.bind().sync() InterruptedException", interruptedException);
        }
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
        this.timer.scheduleAtFixedRate((TimerTask)new NettyRemotingServer$7(this), 3000L, 1000L);
    }

    @Override
    public void shutdown() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupSelector.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception exception) {
            log.error("NettyRemotingServer shutdown exception, ", exception);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
                return;
            }
            catch (Exception exception) {
                log.error("NettyRemotingServer shutdown exception, ", exception);
            }
        }
    }

    @Override
    public void registerRPCHook(RPCHook rPCHook) {
        this.rpcHookList.add(rPCHook);
    }

    @Override
    public void registerProcessor(int n2, NettyRequestProcessor object, ExecutorService executorService) {
        ExecutorService executorService2 = executorService;
        if (executorService == null) {
            executorService2 = this.publicExecutor;
        }
        object = new Pair<NettyRequestProcessor, ExecutorService>((NettyRequestProcessor)object, executorService2);
        this.processorTable.put(n2, (Pair<NettyRequestProcessor, ExecutorService>)object);
    }

    @Override
    public void registerDefaultProcessor(NettyRequestProcessor nettyRequestProcessor, ExecutorService executorService) {
        this.defaultRequestProcessor = new Pair<NettyRequestProcessor, ExecutorService>(nettyRequestProcessor, executorService);
    }

    @Override
    public int localListenPort() {
        return this.port;
    }

    @Override
    public Pair<NettyRequestProcessor, ExecutorService> getProcessorPair(int n2) {
        return this.processorTable.get(n2);
    }

    @Override
    public RemotingCommand invokeSync(Channel channel, RemotingCommand remotingCommand, long l2) {
        return this.invokeSyncImpl(channel, remotingCommand, l2);
    }

    @Override
    public void invokeAsync(Channel channel, RemotingCommand remotingCommand, long l2, InvokeCallback invokeCallback) {
        this.invokeAsyncImpl(channel, remotingCommand, l2, invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, RemotingCommand remotingCommand, long l2) {
        this.invokeOnewayImpl(channel, remotingCommand, l2);
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public List<RPCHook> getRPCHook() {
        return this.rpcHookList;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    static /* synthetic */ DefaultEventExecutorGroup access$000(NettyRemotingServer nettyRemotingServer) {
        return nettyRemotingServer.defaultEventExecutorGroup;
    }

    static /* synthetic */ NettyServerConfig access$100(NettyRemotingServer nettyRemotingServer) {
        return nettyRemotingServer.nettyServerConfig;
    }

    static /* synthetic */ InternalLogger access$200() {
        return log;
    }

    static /* synthetic */ ChannelEventListener access$300(NettyRemotingServer nettyRemotingServer) {
        return nettyRemotingServer.channelEventListener;
    }
}

