/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.InvokeCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.SemaphoreReleaseOnlyOnce;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResponseFuture {
    private final int opaque;
    private final long timeoutMillis;
    private final InvokeCallback invokeCallback;
    private final long beginTimestamp = System.currentTimeMillis();
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final SemaphoreReleaseOnlyOnce once;
    private final AtomicBoolean executeCallbackOnlyOnce = new AtomicBoolean(false);
    private volatile RemotingCommand responseCommand;
    private volatile boolean sendRequestOK = true;
    private volatile Throwable cause;

    public ResponseFuture(int n2, long l2, InvokeCallback invokeCallback, SemaphoreReleaseOnlyOnce semaphoreReleaseOnlyOnce) {
        this.opaque = n2;
        this.timeoutMillis = l2;
        this.invokeCallback = invokeCallback;
        this.once = semaphoreReleaseOnlyOnce;
    }

    public void executeInvokeCallback() {
        if (this.invokeCallback != null && this.executeCallbackOnlyOnce.compareAndSet(false, true)) {
            this.invokeCallback.operationComplete(this);
        }
    }

    public void release() {
        if (this.once != null) {
            this.once.release();
        }
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.beginTimestamp;
        return l2 > this.timeoutMillis;
    }

    public RemotingCommand waitResponse(long l2) {
        this.countDownLatch.await(l2, TimeUnit.MILLISECONDS);
        return this.responseCommand;
    }

    public void putResponse(RemotingCommand remotingCommand) {
        this.responseCommand = remotingCommand;
        this.countDownLatch.countDown();
    }

    public long getBeginTimestamp() {
        return this.beginTimestamp;
    }

    public boolean isSendRequestOK() {
        return this.sendRequestOK;
    }

    public void setSendRequestOK(boolean bl) {
        this.sendRequestOK = bl;
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public InvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable throwable) {
        this.cause = throwable;
    }

    public RemotingCommand getResponseCommand() {
        return this.responseCommand;
    }

    public void setResponseCommand(RemotingCommand remotingCommand) {
        this.responseCommand = remotingCommand;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public String toString() {
        return "ResponseFuture [responseCommand=" + this.responseCommand + ", sendRequestOK=" + this.sendRequestOK + ", cause=" + this.cause + ", opaque=" + this.opaque + ", timeoutMillis=" + this.timeoutMillis + ", invokeCallback=" + this.invokeCallback + ", beginTimestamp=" + this.beginTimestamp + ", countDownLatch=" + this.countDownLatch + "]";
    }
}

