/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol;

import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.CommandCustomHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.annotation.CFNotNull;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingCommandException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommandType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RocketMQSerializable;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.SerializeType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RemotingCommand {
    public static final String SERIALIZE_TYPE_PROPERTY = "rocketmq.serialize.type";
    public static final String SERIALIZE_TYPE_ENV = "ROCKETMQ_SERIALIZE_TYPE";
    public static final String REMOTING_VERSION_KEY = "rocketmq.remoting.version";
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private static final int RPC_TYPE = 0;
    private static final int RPC_ONEWAY = 1;
    private static final Map<Class<? extends CommandCustomHeader>, Field[]> CLASS_HASH_MAP = new HashMap<Class<? extends CommandCustomHeader>, Field[]>();
    private static final Map<Class, String> CANONICAL_NAME_CACHE = new HashMap<Class, String>();
    private static final Map<Field, Boolean> NULLABLE_FIELD_CACHE = new HashMap<Field, Boolean>();
    private static final String STRING_CANONICAL_NAME = String.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_1 = Double.class.getCanonicalName();
    private static final String DOUBLE_CANONICAL_NAME_2 = Double.TYPE.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_1 = Integer.class.getCanonicalName();
    private static final String INTEGER_CANONICAL_NAME_2 = Integer.TYPE.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_1 = Long.class.getCanonicalName();
    private static final String LONG_CANONICAL_NAME_2 = Long.TYPE.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_1 = Boolean.class.getCanonicalName();
    private static final String BOOLEAN_CANONICAL_NAME_2 = Boolean.TYPE.getCanonicalName();
    private static volatile int configVersion = -1;
    private static AtomicInteger requestId = new AtomicInteger(0);
    private static SerializeType serializeTypeConfigInThisServer = SerializeType.JSON;
    private int code;
    private LanguageCode language = LanguageCode.JAVA;
    private int version = 0;
    private int opaque = requestId.getAndIncrement();
    private int flag = 0;
    private String remark;
    private HashMap<String, String> extFields;
    private transient CommandCustomHeader customHeader;
    private SerializeType serializeTypeCurrentRPC = serializeTypeConfigInThisServer;
    private transient byte[] body;

    protected RemotingCommand() {
    }

    public static RemotingCommand createRequestCommand(int n2, CommandCustomHeader commandCustomHeader) {
        RemotingCommand remotingCommand = new RemotingCommand();
        remotingCommand.setCode(n2);
        remotingCommand.customHeader = commandCustomHeader;
        RemotingCommand.setCmdVersion(remotingCommand);
        return remotingCommand;
    }

    private static void setCmdVersion(RemotingCommand remotingCommand) {
        if (configVersion >= 0) {
            remotingCommand.setVersion(configVersion);
            return;
        }
        String string = System.getProperty(REMOTING_VERSION_KEY);
        if (string != null) {
            int n2 = Integer.parseInt(string);
            remotingCommand.setVersion(n2);
            configVersion = n2;
        }
    }

    public static RemotingCommand createResponseCommand(Class<? extends CommandCustomHeader> clazz) {
        return RemotingCommand.createResponseCommand(1, "not set any response code", clazz);
    }

    public static RemotingCommand createResponseCommand(int n2, String string, Class<? extends CommandCustomHeader> clazz) {
        RemotingCommand remotingCommand = new RemotingCommand();
        remotingCommand.markResponseType();
        remotingCommand.setCode(n2);
        remotingCommand.setRemark(string);
        RemotingCommand.setCmdVersion(remotingCommand);
        if (clazz != null) {
            try {
                CommandCustomHeader commandCustomHeader;
                remotingCommand.customHeader = commandCustomHeader = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        return remotingCommand;
    }

    public static RemotingCommand createResponseCommand(int n2, String string) {
        return RemotingCommand.createResponseCommand(n2, string, null);
    }

    public static RemotingCommand decode(byte[] object) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(object);
        object = byteBuffer;
        return RemotingCommand.decode(byteBuffer);
    }

    public static RemotingCommand decode(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.limit();
        int n3 = byteBuffer.getInt();
        int n4 = RemotingCommand.getHeaderLength(n3);
        byte[] byArray = new byte[n4];
        byteBuffer.get(byArray);
        RemotingCommand remotingCommand = RemotingCommand.headerDecode(byArray, RemotingCommand.getProtocolType(n3));
        n2 = n2 - 4 - n4;
        byte[] byArray2 = null;
        if (n2 > 0) {
            byArray2 = new byte[n2];
            byteBuffer.get(byArray2);
        }
        remotingCommand.body = byArray2;
        return remotingCommand;
    }

    public static int getHeaderLength(int n2) {
        return n2 & 0xFFFFFF;
    }

    private static RemotingCommand headerDecode(byte[] object, SerializeType serializeType) {
        switch (serializeType) {
            case JSON: {
                RemotingCommand remotingCommand = RemotingSerializable.decode(object, RemotingCommand.class);
                object = remotingCommand;
                remotingCommand.setSerializeTypeCurrentRPC(serializeType);
                return object;
            }
            case ROCKETMQ: {
                RemotingCommand remotingCommand = RocketMQSerializable.rocketMQProtocolDecode(object);
                object = remotingCommand;
                remotingCommand.setSerializeTypeCurrentRPC(serializeType);
                return object;
            }
        }
        return null;
    }

    public static SerializeType getProtocolType(int n2) {
        return SerializeType.valueOf((byte)(n2 >>> 24));
    }

    public static int createNewRequestId() {
        return requestId.getAndIncrement();
    }

    public static SerializeType getSerializeTypeConfigInThisServer() {
        return serializeTypeConfigInThisServer;
    }

    private static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static byte[] markProtocolType(int n2, SerializeType serializeType) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray[0] = serializeType.getCode();
        byArray2[1] = (byte)(n2 >> 16);
        byArray2[2] = (byte)(n2 >> 8);
        byArray2[3] = (byte)n2;
        return byArray2;
    }

    public void markResponseType() {
        this.flag |= 1;
    }

    public CommandCustomHeader readCustomHeader() {
        return this.customHeader;
    }

    public void writeCustomHeader(CommandCustomHeader commandCustomHeader) {
        this.customHeader = commandCustomHeader;
    }

    public CommandCustomHeader decodeCommandCustomHeader(Class<? extends CommandCustomHeader> fieldArray) {
        CommandCustomHeader commandCustomHeader;
        try {
            commandCustomHeader = fieldArray.newInstance();
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        if (this.extFields != null) {
            Field[] fieldArray2 = this.getClazzFields((Class<? extends CommandCustomHeader>)fieldArray);
            fieldArray = fieldArray2;
            fieldArray = fieldArray2;
            int n2 = fieldArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                Field field = fieldArray[i2];
                if (Modifier.isStatic(field.getModifiers()) || (string = field.getName()).startsWith("this")) continue;
                try {
                    Object object = this.extFields.get(string);
                    if (object == null) {
                        if (this.isFieldNullable(field)) continue;
                        throw new RemotingCommandException("the custom field <" + string + "> is null");
                    }
                    field.setAccessible(true);
                    String string2 = this.getCanonicalName(field.getType());
                    if (!string2.equals(STRING_CANONICAL_NAME)) {
                        if (string2.equals(INTEGER_CANONICAL_NAME_1) || string2.equals(INTEGER_CANONICAL_NAME_2)) {
                            object = Integer.parseInt((String)object);
                        } else if (string2.equals(LONG_CANONICAL_NAME_1) || string2.equals(LONG_CANONICAL_NAME_2)) {
                            object = Long.parseLong((String)object);
                        } else if (string2.equals(BOOLEAN_CANONICAL_NAME_1) || string2.equals(BOOLEAN_CANONICAL_NAME_2)) {
                            object = Boolean.parseBoolean((String)object);
                        } else if (string2.equals(DOUBLE_CANONICAL_NAME_1) || string2.equals(DOUBLE_CANONICAL_NAME_2)) {
                            object = Double.parseDouble((String)object);
                        } else {
                            throw new RemotingCommandException("the custom field <" + string + "> type is not supported");
                        }
                    }
                    field.set(commandCustomHeader, object);
                    continue;
                }
                catch (Throwable throwable) {
                    log.error("Failed field [{}] decoding", (Object)string, (Object)throwable);
                }
            }
            commandCustomHeader.checkFields();
        }
        return commandCustomHeader;
    }

    private Field[] getClazzFields(Class<? extends CommandCustomHeader> clazz) {
        Field[] fieldArray = CLASS_HASH_MAP.get(clazz);
        if (fieldArray == null) {
            fieldArray = clazz.getDeclaredFields();
            Map<Class<? extends CommandCustomHeader>, Field[]> map = CLASS_HASH_MAP;
            synchronized (map) {
                CLASS_HASH_MAP.put(clazz, fieldArray);
            }
        }
        return fieldArray;
    }

    private boolean isFieldNullable(Field field) {
        if (!NULLABLE_FIELD_CACHE.containsKey(field)) {
            CFNotNull cFNotNull = field.getAnnotation(CFNotNull.class);
            Map<Field, Boolean> map = NULLABLE_FIELD_CACHE;
            synchronized (map) {
                NULLABLE_FIELD_CACHE.put(field, cFNotNull == null);
            }
        }
        return NULLABLE_FIELD_CACHE.get(field);
    }

    private String getCanonicalName(Class clazz) {
        String string = CANONICAL_NAME_CACHE.get(clazz);
        if (string == null) {
            string = clazz.getCanonicalName();
            Map<Class, String> map = CANONICAL_NAME_CACHE;
            synchronized (map) {
                CANONICAL_NAME_CACHE.put(clazz, string);
            }
        }
        return string;
    }

    public ByteBuffer encode() {
        byte[] byArray = this.headerEncode();
        int n2 = 4 + byArray.length;
        if (this.body != null) {
            n2 += this.body.length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 + 4);
        byteBuffer.putInt(n2);
        byteBuffer.put(RemotingCommand.markProtocolType(byArray.length, this.serializeTypeCurrentRPC));
        byteBuffer.put(byArray);
        if (this.body != null) {
            byteBuffer.put(this.body);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private byte[] headerEncode() {
        this.makeCustomHeaderToNet();
        if (SerializeType.ROCKETMQ == this.serializeTypeCurrentRPC) {
            return RocketMQSerializable.rocketMQProtocolEncode(this);
        }
        return RemotingSerializable.encode(this);
    }

    public void makeCustomHeaderToNet() {
        if (this.customHeader != null) {
            RemotingCommand remotingCommand = this;
            Field[] fieldArray = remotingCommand.getClazzFields(remotingCommand.customHeader.getClass());
            if (this.extFields == null) {
                this.extFields = new HashMap();
            }
            for (Field field : fieldArray) {
                String string;
                if (Modifier.isStatic(field.getModifiers()) || (string = field.getName()).startsWith("this")) continue;
                Object object = null;
                try {
                    field.setAccessible(true);
                    object = field.get(this.customHeader);
                }
                catch (Exception exception) {
                    log.error("Failed to access field [{}]", (Object)string, (Object)exception);
                }
                if (object == null) continue;
                this.extFields.put(string, object.toString());
            }
        }
    }

    public ByteBuffer encodeHeader() {
        RemotingCommand remotingCommand = this;
        return remotingCommand.encodeHeader(remotingCommand.body != null ? this.body.length : 0);
    }

    public ByteBuffer encodeHeader(int n2) {
        byte[] byArray = this.headerEncode();
        int n3 = 4 + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate((n3 += n2) + 4 - n2);
        byteBuffer.putInt(n3);
        byteBuffer.put(RemotingCommand.markProtocolType(byArray.length, this.serializeTypeCurrentRPC));
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return byteBuffer;
    }

    public void markOnewayRPC() {
        this.flag |= 2;
    }

    @JSONField(serialize=false)
    public boolean isOnewayRPC() {
        return (this.flag & 2) == 2;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int n2) {
        this.code = n2;
    }

    @JSONField(serialize=false)
    public RemotingCommandType getType() {
        if (this.isResponseType()) {
            return RemotingCommandType.RESPONSE_COMMAND;
        }
        return RemotingCommandType.REQUEST_COMMAND;
    }

    @JSONField(serialize=false)
    public boolean isResponseType() {
        return (this.flag & 1) == 1;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode languageCode) {
        this.language = languageCode;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public int getOpaque() {
        return this.opaque;
    }

    public void setOpaque(int n2) {
        this.opaque = n2;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int n2) {
        this.flag = n2;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String string) {
        this.remark = string;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] byArray) {
        this.body = byArray;
    }

    public HashMap<String, String> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(HashMap<String, String> hashMap) {
        this.extFields = hashMap;
    }

    public void addExtField(String string, String string2) {
        if (this.extFields == null) {
            this.extFields = new HashMap();
        }
        this.extFields.put(string, string2);
    }

    public String toString() {
        return "RemotingCommand [code=" + this.code + ", language=" + (Object)((Object)this.language) + ", version=" + this.version + ", opaque=" + this.opaque + ", flag(B)=" + Integer.toBinaryString(this.flag) + ", remark=" + this.remark + ", extFields=" + this.extFields + ", serializeTypeCurrentRPC=" + (Object)((Object)this.serializeTypeCurrentRPC) + "]";
    }

    public SerializeType getSerializeTypeCurrentRPC() {
        return this.serializeTypeCurrentRPC;
    }

    public void setSerializeTypeCurrentRPC(SerializeType serializeType) {
        this.serializeTypeCurrentRPC = serializeType;
    }

    static {
        String string = System.getProperty(SERIALIZE_TYPE_PROPERTY, System.getenv(SERIALIZE_TYPE_ENV));
        if (!RemotingCommand.isBlank(string)) {
            try {
                serializeTypeConfigInThisServer = SerializeType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException("parser specified protocol error. protocol=" + string, illegalArgumentException);
            }
        }
    }
}

