/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class RocketMQSerializable {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    public static byte[] rocketMQProtocolEncode(RemotingCommand remotingCommand) {
        byte[] byArray = null;
        int n2 = 0;
        if (remotingCommand.getRemark() != null && remotingCommand.getRemark().length() > 0) {
            byArray = remotingCommand.getRemark().getBytes(CHARSET_UTF8);
            n2 = byArray.length;
        }
        byte[] byArray2 = null;
        int n3 = 0;
        if (remotingCommand.getExtFields() != null && !remotingCommand.getExtFields().isEmpty()) {
            byArray2 = RocketMQSerializable.mapSerialize(remotingCommand.getExtFields());
            n3 = byArray2.length;
        }
        n2 = RocketMQSerializable.calTotalLen(n2, n3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.putShort((short)remotingCommand.getCode());
        byteBuffer.put(remotingCommand.getLanguage().getCode());
        byteBuffer.putShort((short)remotingCommand.getVersion());
        byteBuffer.putInt(remotingCommand.getOpaque());
        byteBuffer.putInt(remotingCommand.getFlag());
        if (byArray != null) {
            byteBuffer.putInt(byArray.length);
            byteBuffer.put(byArray);
        } else {
            byteBuffer.putInt(0);
        }
        if (byArray2 != null) {
            byteBuffer.putInt(byArray2.length);
            byteBuffer.put(byArray2);
        } else {
            byteBuffer.putInt(0);
        }
        return byteBuffer.array();
    }

    public static byte[] mapSerialize(HashMap<String, String> entry3) {
        Map.Entry<String, String> entry22;
        if (entry3 == null || ((HashMap)((Object)entry3)).isEmpty()) {
            return null;
        }
        int n2 = 0;
        for (Map.Entry<String, String> entry22 : ((HashMap)((Object)entry3)).entrySet()) {
            if (entry22.getKey() == null || entry22.getValue() == null) continue;
            int n3 = 2 + ((String)entry22.getKey()).getBytes(CHARSET_UTF8).length + 4 + ((String)entry22.getValue()).getBytes(CHARSET_UTF8).length;
            n2 += n3;
        }
        entry22 = ByteBuffer.allocate(n2);
        for (Map.Entry<String, String> entry3 : ((HashMap)((Object)entry3)).entrySet()) {
            if (entry3.getKey() == null || entry3.getValue() == null) continue;
            byte[] byArray = ((String)entry3.getKey()).getBytes(CHARSET_UTF8);
            entry3 = (Map.Entry<String, String>)((String)entry3.getValue()).getBytes(CHARSET_UTF8);
            ((ByteBuffer)((Object)entry22)).putShort((short)byArray.length);
            ((ByteBuffer)((Object)entry22)).put(byArray);
            ((ByteBuffer)((Object)entry22)).putInt(((Object)entry3).length);
            ((ByteBuffer)((Object)entry22)).put((byte[])entry3);
        }
        return ((ByteBuffer)((Object)entry22)).array();
    }

    private static int calTotalLen(int n2, int n3) {
        n2 = n2 + 17 + 4 + n3;
        return n2;
    }

    public static RemotingCommand rocketMQProtocolDecode(byte[] object) {
        RemotingCommand remotingCommand = new RemotingCommand();
        object = ByteBuffer.wrap((byte[])object);
        remotingCommand.setCode(((ByteBuffer)object).getShort());
        remotingCommand.setLanguage(LanguageCode.valueOf(((ByteBuffer)object).get()));
        remotingCommand.setVersion(((ByteBuffer)object).getShort());
        remotingCommand.setOpaque(((ByteBuffer)object).getInt());
        remotingCommand.setFlag(((ByteBuffer)object).getInt());
        int n2 = ((ByteBuffer)object).getInt();
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)object).get(byArray);
            remotingCommand.setRemark(new String(byArray, CHARSET_UTF8));
        }
        if ((n2 = ((ByteBuffer)object).getInt()) > 0) {
            byte[] byArray = new byte[n2];
            ((ByteBuffer)object).get(byArray);
            remotingCommand.setExtFields(RocketMQSerializable.mapDeserialize(byArray));
        }
        return remotingCommand;
    }

    public static HashMap<String, String> mapDeserialize(byte[] object) {
        if (object == null || ((byte[])object).length <= 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = ByteBuffer.wrap((byte[])object);
        while (((Buffer)object).hasRemaining()) {
            short s2 = ((ByteBuffer)object).getShort();
            byte[] byArray = new byte[s2];
            ((ByteBuffer)object).get(byArray);
            int n2 = ((ByteBuffer)object).getInt();
            byte[] byArray2 = new byte[n2];
            ((ByteBuffer)object).get(byArray2);
            hashMap.put(new String(byArray, CHARSET_UTF8), new String(byArray2, CHARSET_UTF8));
        }
        return hashMap;
    }

    public static boolean isBlank(String string) {
        int n2;
        if (string == null || (n2 = string.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

