/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.bootstrap;

import com.aliyun.openservices.shade.io.netty.bootstrap.AbstractBootstrap$1;
import com.aliyun.openservices.shade.io.netty.bootstrap.AbstractBootstrap$2;
import com.aliyun.openservices.shade.io.netty.bootstrap.AbstractBootstrap$BootstrapChannelFactory;
import com.aliyun.openservices.shade.io.netty.bootstrap.AbstractBootstrap$PendingRegistrationPromise;
import com.aliyun.openservices.shade.io.netty.bootstrap.ChannelFactory;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandler;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.DefaultChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.AttributeKey;
import com.aliyun.openservices.shade.io.netty.util.UniqueName;
import com.aliyun.openservices.shade.io.netty.util.concurrent.GlobalEventExecutor;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractBootstrap<B extends AbstractBootstrap<B, C>, C extends Channel>
implements Cloneable {
    volatile EventLoopGroup group;
    private volatile ChannelFactory<? extends C> channelFactory;
    private volatile SocketAddress localAddress;
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new LinkedHashMap();
    private volatile ChannelHandler handler;

    AbstractBootstrap() {
    }

    AbstractBootstrap(AbstractBootstrap<B, C> abstractBootstrap) {
        this.group = abstractBootstrap.group;
        this.channelFactory = abstractBootstrap.channelFactory;
        this.handler = abstractBootstrap.handler;
        this.localAddress = abstractBootstrap.localAddress;
        Map<UniqueName, Object> map = abstractBootstrap.options;
        synchronized (map) {
            this.options.putAll(abstractBootstrap.options);
        }
        map = abstractBootstrap.attrs;
        synchronized (map) {
            this.attrs.putAll(abstractBootstrap.attrs);
            return;
        }
    }

    public B group(EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            throw new NullPointerException("group");
        }
        if (this.group != null) {
            throw new IllegalStateException("group set already");
        }
        this.group = eventLoopGroup;
        return (B)this;
    }

    public B channel(Class<? extends C> clazz) {
        if (clazz == null) {
            throw new NullPointerException("channelClass");
        }
        return this.channelFactory(new AbstractBootstrap$BootstrapChannelFactory<C>(clazz));
    }

    public B channelFactory(ChannelFactory<? extends C> channelFactory) {
        if (channelFactory == null) {
            throw new NullPointerException("channelFactory");
        }
        if (this.channelFactory != null) {
            throw new IllegalStateException("channelFactory set already");
        }
        this.channelFactory = channelFactory;
        return (B)this;
    }

    public B localAddress(SocketAddress socketAddress) {
        this.localAddress = socketAddress;
        return (B)this;
    }

    public B localAddress(int n2) {
        return this.localAddress(new InetSocketAddress(n2));
    }

    public B localAddress(String string, int n2) {
        return this.localAddress(new InetSocketAddress(string, n2));
    }

    public B localAddress(InetAddress inetAddress, int n2) {
        return this.localAddress(new InetSocketAddress(inetAddress, n2));
    }

    public <T> B option(ChannelOption<T> channelOption, T t2) {
        if (channelOption == null) {
            throw new NullPointerException("option");
        }
        if (t2 == null) {
            Map<ChannelOption<?>, Object> map = this.options;
            synchronized (map) {
                this.options.remove(channelOption);
            }
        }
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            this.options.put(channelOption, t2);
        }
        return (B)this;
    }

    public <T> B attr(AttributeKey<T> attributeKey, T t2) {
        if (attributeKey == null) {
            throw new NullPointerException("key");
        }
        if (t2 == null) {
            Map<AttributeKey<?>, Object> map = this.attrs;
            synchronized (map) {
                this.attrs.remove(attributeKey);
            }
        }
        Map<AttributeKey<?>, Object> map = this.attrs;
        synchronized (map) {
            this.attrs.put(attributeKey, t2);
        }
        return (B)this;
    }

    public B validate() {
        if (this.group == null) {
            throw new IllegalStateException("group not set");
        }
        if (this.channelFactory == null) {
            throw new IllegalStateException("channel or channelFactory not set");
        }
        return (B)this;
    }

    public abstract B clone();

    public ChannelFuture register() {
        this.validate();
        return this.initAndRegister();
    }

    public ChannelFuture bind() {
        this.validate();
        SocketAddress socketAddress = this.localAddress;
        if (socketAddress == null) {
            throw new IllegalStateException("localAddress not set");
        }
        return this.doBind(socketAddress);
    }

    public ChannelFuture bind(int n2) {
        return this.bind(new InetSocketAddress(n2));
    }

    public ChannelFuture bind(String string, int n2) {
        return this.bind(new InetSocketAddress(string, n2));
    }

    public ChannelFuture bind(InetAddress inetAddress, int n2) {
        return this.bind(new InetSocketAddress(inetAddress, n2));
    }

    public ChannelFuture bind(SocketAddress socketAddress) {
        this.validate();
        if (socketAddress == null) {
            throw new NullPointerException("localAddress");
        }
        return this.doBind(socketAddress);
    }

    private ChannelFuture doBind(SocketAddress socketAddress) {
        ChannelFuture channelFuture = this.initAndRegister();
        Channel channel = channelFuture.channel();
        if (channelFuture.cause() != null) {
            return channelFuture;
        }
        if (channelFuture.isDone()) {
            ChannelPromise channelPromise = channel.newPromise();
            AbstractBootstrap.doBind0(channelFuture, channel, socketAddress, channelPromise);
            return channelPromise;
        }
        AbstractBootstrap$PendingRegistrationPromise abstractBootstrap$PendingRegistrationPromise = new AbstractBootstrap$PendingRegistrationPromise(channel, null);
        channelFuture.addListener(new AbstractBootstrap$1(this, abstractBootstrap$PendingRegistrationPromise, channel, channelFuture, socketAddress));
        return abstractBootstrap$PendingRegistrationPromise;
    }

    final ChannelFuture initAndRegister() {
        Channel channel = null;
        try {
            channel = (Channel)this.channelFactory().newChannel();
            this.init(channel);
        }
        catch (Throwable throwable) {
            if (channel != null) {
                channel.unsafe().closeForcibly();
            }
            return new DefaultChannelPromise(channel, GlobalEventExecutor.INSTANCE).setFailure(throwable);
        }
        ChannelFuture channelFuture = this.group().register(channel);
        if (channelFuture.cause() != null) {
            if (channel.isRegistered()) {
                channel.close();
            } else {
                channel.unsafe().closeForcibly();
            }
        }
        return channelFuture;
    }

    abstract void init(Channel var1);

    private static void doBind0(ChannelFuture channelFuture, Channel channel, SocketAddress socketAddress, ChannelPromise channelPromise) {
        channel.eventLoop().execute(new AbstractBootstrap$2(channelFuture, channel, socketAddress, channelPromise));
    }

    public B handler(ChannelHandler channelHandler) {
        if (channelHandler == null) {
            throw new NullPointerException("handler");
        }
        this.handler = channelHandler;
        return (B)this;
    }

    final SocketAddress localAddress() {
        return this.localAddress;
    }

    final ChannelFactory<? extends C> channelFactory() {
        return this.channelFactory;
    }

    final ChannelHandler handler() {
        return this.handler;
    }

    public EventLoopGroup group() {
        return this.group;
    }

    final Map<ChannelOption<?>, Object> options() {
        return this.options;
    }

    final Map<AttributeKey<?>, Object> attrs() {
        return this.attrs;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append('(');
        if (this.group != null) {
            stringBuilder.append("group: ").append(StringUtil.simpleClassName(this.group)).append(", ");
        }
        if (this.channelFactory != null) {
            stringBuilder.append("channelFactory: ").append(this.channelFactory).append(", ");
        }
        if (this.localAddress != null) {
            stringBuilder.append("localAddress: ").append(this.localAddress).append(", ");
        }
        Map<UniqueName, Object> map = this.options;
        synchronized (map) {
            if (!this.options.isEmpty()) {
                stringBuilder.append("options: ").append(this.options).append(", ");
            }
        }
        map = this.attrs;
        synchronized (map) {
            if (!this.attrs.isEmpty()) {
                stringBuilder.append("attrs: ").append(this.attrs).append(", ");
            }
        }
        if (this.handler != null) {
            stringBuilder.append("handler: ").append(this.handler).append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        if (stringBuilder2.charAt(stringBuilder2.length() - 1) == '(') {
            stringBuilder.append(')');
        } else {
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.setCharAt(stringBuilder3.length() - 2, ')');
            StringBuilder stringBuilder4 = stringBuilder;
            stringBuilder4.setLength(stringBuilder4.length() - 1);
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ void access$200(ChannelFuture channelFuture, Channel channel, SocketAddress socketAddress, ChannelPromise channelPromise) {
        AbstractBootstrap.doBind0(channelFuture, channel, socketAddress, channelPromise);
    }
}

