/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.bootstrap;

import com.aliyun.openservices.shade.io.netty.bootstrap.AbstractBootstrap;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap$1;
import com.aliyun.openservices.shade.io.netty.bootstrap.Bootstrap$2;
import com.aliyun.openservices.shade.io.netty.channel.Channel;
import com.aliyun.openservices.shade.io.netty.channel.ChannelFuture;
import com.aliyun.openservices.shade.io.netty.channel.ChannelOption;
import com.aliyun.openservices.shade.io.netty.channel.ChannelPromise;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.AttributeKey;
import com.aliyun.openservices.shade.io.netty.util.UniqueName;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;

public class Bootstrap
extends AbstractBootstrap<Bootstrap, Channel> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Bootstrap.class);
    private volatile SocketAddress remoteAddress;

    public Bootstrap() {
    }

    private Bootstrap(Bootstrap bootstrap) {
        super(bootstrap);
        this.remoteAddress = bootstrap.remoteAddress;
    }

    public Bootstrap remoteAddress(SocketAddress socketAddress) {
        this.remoteAddress = socketAddress;
        return this;
    }

    public Bootstrap remoteAddress(String string, int n2) {
        this.remoteAddress = new InetSocketAddress(string, n2);
        return this;
    }

    public Bootstrap remoteAddress(InetAddress inetAddress, int n2) {
        this.remoteAddress = new InetSocketAddress(inetAddress, n2);
        return this;
    }

    public ChannelFuture connect() {
        this.validate();
        SocketAddress socketAddress = this.remoteAddress;
        if (socketAddress == null) {
            throw new IllegalStateException("remoteAddress not set");
        }
        return this.doConnect(socketAddress, this.localAddress());
    }

    public ChannelFuture connect(String string, int n2) {
        return this.connect(new InetSocketAddress(string, n2));
    }

    public ChannelFuture connect(InetAddress inetAddress, int n2) {
        return this.connect(new InetSocketAddress(inetAddress, n2));
    }

    public ChannelFuture connect(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doConnect(socketAddress, this.localAddress());
    }

    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validate();
        return this.doConnect(socketAddress, socketAddress2);
    }

    private ChannelFuture doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        ChannelFuture channelFuture = this.initAndRegister();
        Channel channel = channelFuture.channel();
        if (channelFuture.cause() != null) {
            return channelFuture;
        }
        ChannelPromise channelPromise = channel.newPromise();
        if (channelFuture.isDone()) {
            Bootstrap.doConnect0(channelFuture, channel, socketAddress, socketAddress2, channelPromise);
        } else {
            channelFuture.addListener(new Bootstrap$1(this, channelFuture, channel, socketAddress, socketAddress2, channelPromise));
        }
        return channelPromise;
    }

    private static void doConnect0(ChannelFuture channelFuture, Channel channel, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        channel.eventLoop().execute(new Bootstrap$2(channelFuture, socketAddress2, channel, socketAddress, channelPromise));
    }

    @Override
    void init(Channel channel) {
        Object object = channel.pipeline();
        object.addLast(this.handler());
        object = this.options();
        Map<UniqueName, Object> map = object;
        synchronized (object) {
            for (Map.Entry object2 : object.entrySet()) {
                try {
                    if (channel.config().setOption((ChannelOption)object2.getKey(), object2.getValue())) continue;
                    logger.warn("Unknown channel option: " + object2);
                }
                catch (Throwable entry) {
                    logger.warn("Failed to set a channel option: " + channel, entry);
                }
            }
            // ** MonitorExit[map] (shouldn't be in output)
            map = this.attrs();
            object = map;
            synchronized (map) {
                for (Map.Entry<UniqueName, Object> entry : map.entrySet()) {
                    channel.attr((AttributeKey)entry.getKey()).set(entry.getValue());
                }
                return;
            }
        }
    }

    @Override
    public Bootstrap validate() {
        super.validate();
        if (this.handler() == null) {
            throw new IllegalStateException("handler not set");
        }
        return this;
    }

    @Override
    public Bootstrap clone() {
        return new Bootstrap(this);
    }

    public Bootstrap clone(EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = new Bootstrap(this);
        new Bootstrap(this).group = eventLoopGroup;
        return bootstrap;
    }

    @Override
    public String toString() {
        if (this.remoteAddress == null) {
            return super.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.append(", remoteAddress: ").append(this.remoteAddress).append(')').toString();
    }

    static /* synthetic */ void access$000(ChannelFuture channelFuture, Channel channel, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        Bootstrap.doConnect0(channelFuture, channel, socketAddress, socketAddress2, channelPromise);
    }
}

