/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil;
import com.aliyun.openservices.shade.io.netty.buffer.DuplicatedAbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.SlicedAbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.SwappedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.util.IllegalReferenceCountException;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetectorFactory;
import com.aliyun.openservices.shade.io.netty.util.internal.MathUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

public abstract class AbstractByteBuf
extends ByteBuf {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractByteBuf.class);
    private static final String PROP_MODE = "com.aliyun.openservices.shade.io.netty.buffer.bytebuf.checkAccessible";
    private static final boolean checkAccessible = SystemPropertyUtil.getBoolean("com.aliyun.openservices.shade.io.netty.buffer.bytebuf.checkAccessible", true);
    static final ResourceLeakDetector<ByteBuf> leakDetector;
    int readerIndex;
    int writerIndex;
    private int markedReaderIndex;
    private int markedWriterIndex;
    private int maxCapacity;
    private SwappedByteBuf swappedBuf;

    protected AbstractByteBuf(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxCapacity: " + n2 + " (expected: >= 0)");
        }
        this.maxCapacity = n2;
    }

    @Override
    public int maxCapacity() {
        return this.maxCapacity;
    }

    protected final void maxCapacity(int n2) {
        this.maxCapacity = n2;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public ByteBuf readerIndex(int n2) {
        if (n2 < 0 || n2 > this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d (expected: 0 <= readerIndex <= writerIndex(%d))", n2, this.writerIndex));
        }
        this.readerIndex = n2;
        return this;
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public ByteBuf writerIndex(int n2) {
        if (n2 < this.readerIndex || n2 > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("writerIndex: %d (expected: readerIndex(%d) <= writerIndex <= capacity(%d))", n2, this.readerIndex, this.capacity()));
        }
        this.writerIndex = n2;
        return this;
    }

    @Override
    public ByteBuf setIndex(int n2, int n3) {
        if (n2 < 0 || n2 > n3 || n3 > this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("readerIndex: %d, writerIndex: %d (expected: 0 <= readerIndex <= writerIndex <= capacity(%d))", n2, n3, this.capacity()));
        }
        this.setIndex0(n2, n3);
        return this;
    }

    @Override
    public ByteBuf clear() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.writerIndex = 0;
        abstractByteBuf.readerIndex = 0;
        return this;
    }

    @Override
    public boolean isReadable() {
        return this.writerIndex > this.readerIndex;
    }

    @Override
    public boolean isReadable(int n2) {
        return this.writerIndex - this.readerIndex >= n2;
    }

    @Override
    public boolean isWritable() {
        return this.capacity() > this.writerIndex;
    }

    @Override
    public boolean isWritable(int n2) {
        return this.capacity() - this.writerIndex >= n2;
    }

    @Override
    public int readableBytes() {
        return this.writerIndex - this.readerIndex;
    }

    @Override
    public int writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    @Override
    public int maxWritableBytes() {
        return ((ByteBuf)this).maxCapacity() - this.writerIndex;
    }

    @Override
    public ByteBuf markReaderIndex() {
        this.markedReaderIndex = this.readerIndex;
        return this;
    }

    @Override
    public ByteBuf resetReaderIndex() {
        AbstractByteBuf abstractByteBuf = this;
        ((ByteBuf)abstractByteBuf).readerIndex(abstractByteBuf.markedReaderIndex);
        return this;
    }

    @Override
    public ByteBuf markWriterIndex() {
        this.markedWriterIndex = this.writerIndex;
        return this;
    }

    @Override
    public ByteBuf resetWriterIndex() {
        this.writerIndex = this.markedWriterIndex;
        return this;
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex != this.writerIndex) {
            AbstractByteBuf abstractByteBuf = this;
            this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            AbstractByteBuf abstractByteBuf2 = this;
            abstractByteBuf2.adjustMarkers(abstractByteBuf2.readerIndex);
            this.readerIndex = 0;
        } else {
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
            AbstractByteBuf abstractByteBuf3 = this;
            abstractByteBuf3.readerIndex = 0;
            abstractByteBuf3.writerIndex = 0;
        }
        return this;
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.ensureAccessible();
        if (this.readerIndex == 0) {
            return this;
        }
        if (this.readerIndex == this.writerIndex) {
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.adjustMarkers(abstractByteBuf.readerIndex);
            AbstractByteBuf abstractByteBuf2 = this;
            abstractByteBuf2.readerIndex = 0;
            abstractByteBuf2.writerIndex = 0;
            return this;
        }
        if (this.readerIndex >= this.capacity() >>> 1) {
            AbstractByteBuf abstractByteBuf = this;
            this.setBytes(0, abstractByteBuf, abstractByteBuf.readerIndex, this.writerIndex - this.readerIndex);
            this.writerIndex -= this.readerIndex;
            AbstractByteBuf abstractByteBuf3 = this;
            abstractByteBuf3.adjustMarkers(abstractByteBuf3.readerIndex);
            this.readerIndex = 0;
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void adjustMarkers(int n2) {
        int n3 = this.markedReaderIndex;
        if (n3 > n2) {
            this.markedReaderIndex = n3 - n2;
            this.markedWriterIndex -= n2;
            return;
        }
        this.markedReaderIndex = 0;
        n3 = this.markedWriterIndex;
        if (n3 <= n2) {
            this.markedWriterIndex = 0;
            return;
        }
        this.markedWriterIndex = n3 - n2;
    }

    @Override
    public ByteBuf ensureWritable(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", n2));
        }
        this.ensureWritable0(n2);
        return this;
    }

    private void ensureWritable0(int n2) {
        if (n2 <= ((ByteBuf)this).writableBytes()) {
            return;
        }
        if (n2 > this.maxCapacity - this.writerIndex) {
            throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + minWritableBytes(%d) exceeds maxCapacity(%d): %s", this.writerIndex, n2, this.maxCapacity, this));
        }
        AbstractByteBuf abstractByteBuf = this;
        n2 = abstractByteBuf.calculateNewCapacity(abstractByteBuf.writerIndex + n2);
        this.capacity(n2);
    }

    @Override
    public int ensureWritable(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("minWritableBytes: %d (expected: >= 0)", n2));
        }
        if (n2 <= ((ByteBuf)this).writableBytes()) {
            return 0;
        }
        if (n2 > this.maxCapacity - this.writerIndex && bl) {
            if (this.capacity() == ((ByteBuf)this).maxCapacity()) {
                return 1;
            }
            AbstractByteBuf abstractByteBuf = this;
            abstractByteBuf.capacity(((ByteBuf)abstractByteBuf).maxCapacity());
            return 3;
        }
        AbstractByteBuf abstractByteBuf = this;
        n2 = abstractByteBuf.calculateNewCapacity(abstractByteBuf.writerIndex + n2);
        this.capacity(n2);
        return 2;
    }

    private int calculateNewCapacity(int n2) {
        int n3;
        int n4 = this.maxCapacity;
        if (n2 == 0x400000) {
            return 0x400000;
        }
        if (n2 > 0x400000) {
            int n5 = n2 / 0x400000 * 0x400000;
            n5 = n5 > n4 - 0x400000 ? n4 : (n5 += 0x400000);
            return n5;
        }
        for (n3 = 64; n3 < n2; n3 <<= 1) {
        }
        return Math.min(n3, n4);
    }

    @Override
    public ByteBuf order(ByteOrder object) {
        if (object == null) {
            throw new NullPointerException("endianness");
        }
        if (object == this.order()) {
            return this;
        }
        object = this.swappedBuf;
        if (object == null) {
            object = this.newSwappedByteBuf();
            this.swappedBuf = object;
        }
        return object;
    }

    protected SwappedByteBuf newSwappedByteBuf() {
        return new SwappedByteBuf(this);
    }

    @Override
    public byte getByte(int n2) {
        this.checkIndex(n2);
        return this._getByte(n2);
    }

    protected abstract byte _getByte(int var1);

    @Override
    public boolean getBoolean(int n2) {
        return ((ByteBuf)this).getByte(n2) != 0;
    }

    @Override
    public short getUnsignedByte(int n2) {
        return (short)(((ByteBuf)this).getByte(n2) & 0xFF);
    }

    @Override
    public short getShort(int n2) {
        this.checkIndex(n2, 2);
        return this._getShort(n2);
    }

    protected abstract short _getShort(int var1);

    @Override
    public int getUnsignedShort(int n2) {
        return ((ByteBuf)this).getShort(n2) & 0xFFFF;
    }

    @Override
    public int getUnsignedMedium(int n2) {
        this.checkIndex(n2, 3);
        return this._getUnsignedMedium(n2);
    }

    protected abstract int _getUnsignedMedium(int var1);

    @Override
    public int getMedium(int n2) {
        if (((n2 = ((ByteBuf)this).getUnsignedMedium(n2)) & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    @Override
    public int getInt(int n2) {
        this.checkIndex(n2, 4);
        return this._getInt(n2);
    }

    protected abstract int _getInt(int var1);

    @Override
    public long getUnsignedInt(int n2) {
        return (long)((ByteBuf)this).getInt(n2) & 0xFFFFFFFFL;
    }

    @Override
    public long getLong(int n2) {
        this.checkIndex(n2, 8);
        return this._getLong(n2);
    }

    protected abstract long _getLong(int var1);

    @Override
    public char getChar(int n2) {
        return (char)((ByteBuf)this).getShort(n2);
    }

    @Override
    public float getFloat(int n2) {
        return Float.intBitsToFloat(((ByteBuf)this).getInt(n2));
    }

    @Override
    public double getDouble(int n2) {
        return Double.longBitsToDouble(((ByteBuf)this).getLong(n2));
    }

    @Override
    public ByteBuf getBytes(int n2, byte[] byArray) {
        this.getBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).getBytes(n2, byteBuf2, byteBuf2.writableBytes());
        return this;
    }

    @Override
    public ByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        ByteBuf byteBuf2 = byteBuf;
        this.getBytes(n2, byteBuf2, byteBuf2.writerIndex(), n3);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.writerIndex() + n3);
        return this;
    }

    @Override
    public ByteBuf setByte(int n2, int n3) {
        this.checkIndex(n2);
        this._setByte(n2, n3);
        return this;
    }

    protected abstract void _setByte(int var1, int var2);

    @Override
    public ByteBuf setBoolean(int n2, boolean bl) {
        ((ByteBuf)this).setByte(n2, bl ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf setShort(int n2, int n3) {
        this.checkIndex(n2, 2);
        this._setShort(n2, n3);
        return this;
    }

    protected abstract void _setShort(int var1, int var2);

    @Override
    public ByteBuf setChar(int n2, int n3) {
        ((ByteBuf)this).setShort(n2, n3);
        return this;
    }

    @Override
    public ByteBuf setMedium(int n2, int n3) {
        this.checkIndex(n2, 3);
        this._setMedium(n2, n3);
        return this;
    }

    protected abstract void _setMedium(int var1, int var2);

    @Override
    public ByteBuf setInt(int n2, int n3) {
        this.checkIndex(n2, 4);
        this._setInt(n2, n3);
        return this;
    }

    protected abstract void _setInt(int var1, int var2);

    @Override
    public ByteBuf setFloat(int n2, float f2) {
        ((ByteBuf)this).setInt(n2, Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf setLong(int n2, long l2) {
        this.checkIndex(n2, 8);
        this._setLong(n2, l2);
        return this;
    }

    protected abstract void _setLong(int var1, long var2);

    @Override
    public ByteBuf setDouble(int n2, double d2) {
        ((ByteBuf)this).setLong(n2, Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, byte[] byArray) {
        this.setBytes(n2, byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).setBytes(n2, byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    @Override
    public ByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        this.checkIndex(n2, n3);
        if (byteBuf == null) {
            throw new NullPointerException("src");
        }
        if (n3 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n3, byteBuf.readableBytes(), byteBuf));
        }
        ByteBuf byteBuf2 = byteBuf;
        this.setBytes(n2, byteBuf2, byteBuf2.readerIndex(), n3);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.readerIndex() + n3);
        return this;
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        if (n3 == 0) {
            return this;
        }
        this.checkIndex(n2, n3);
        int n4 = n3 >>> 3;
        n3 &= 7;
        while (n4 > 0) {
            this._setLong(n2, 0L);
            n2 += 8;
            --n4;
        }
        if (n3 == 4) {
            this._setInt(n2, 0);
        } else if (n3 < 4) {
            for (n4 = n3; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        } else {
            this._setInt(n2, 0);
            n2 += 4;
            for (n4 = n3 - 4; n4 > 0; --n4) {
                this._setByte(n2, 0);
                ++n2;
            }
        }
        return this;
    }

    @Override
    public byte readByte() {
        this.checkReadableBytes0(1);
        int n2 = this.readerIndex;
        byte by = this._getByte(n2);
        this.readerIndex = n2 + 1;
        return by;
    }

    @Override
    public boolean readBoolean() {
        return ((ByteBuf)this).readByte() != 0;
    }

    @Override
    public short readUnsignedByte() {
        return (short)(((ByteBuf)this).readByte() & 0xFF);
    }

    @Override
    public short readShort() {
        this.checkReadableBytes0(2);
        AbstractByteBuf abstractByteBuf = this;
        short s2 = abstractByteBuf._getShort(abstractByteBuf.readerIndex);
        this.readerIndex += 2;
        return s2;
    }

    @Override
    public int readUnsignedShort() {
        return ((ByteBuf)this).readShort() & 0xFFFF;
    }

    @Override
    public int readMedium() {
        int n2 = ((ByteBuf)this).readUnsignedMedium();
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkReadableBytes0(3);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf._getUnsignedMedium(abstractByteBuf.readerIndex);
        this.readerIndex += 3;
        return n2;
    }

    @Override
    public int readInt() {
        this.checkReadableBytes0(4);
        AbstractByteBuf abstractByteBuf = this;
        int n2 = abstractByteBuf._getInt(abstractByteBuf.readerIndex);
        this.readerIndex += 4;
        return n2;
    }

    @Override
    public long readUnsignedInt() {
        return (long)((ByteBuf)this).readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        this.checkReadableBytes0(8);
        AbstractByteBuf abstractByteBuf = this;
        long l2 = abstractByteBuf._getLong(abstractByteBuf.readerIndex);
        this.readerIndex += 8;
        return l2;
    }

    @Override
    public char readChar() {
        return (char)((ByteBuf)this).readShort();
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(((ByteBuf)this).readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(((ByteBuf)this).readLong());
    }

    @Override
    public ByteBuf readBytes(int n2) {
        this.checkReadableBytes(n2);
        if (n2 == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBuf byteBuf = this.alloc().buffer(n2, this.maxCapacity);
        AbstractByteBuf abstractByteBuf = this;
        byteBuf.writeBytes(abstractByteBuf, abstractByteBuf.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readSlice(int n2) {
        AbstractByteBuf abstractByteBuf = this;
        ByteBuf byteBuf = ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, n2);
        this.readerIndex += n2;
        return byteBuf;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byArray, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(byte[] byArray) {
        ((ByteBuf)this).readBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).readBytes(byteBuf2, byteBuf2.writableBytes());
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.writableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds dst.writableBytes(%d) where dst is: %s", n2, byteBuf.writableBytes(), byteBuf));
        }
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).readBytes(byteBuf2, byteBuf2.writerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.writerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        this.checkReadableBytes(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byteBuf, n2, n3);
        this.readerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, byteBuffer);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        int n3 = abstractByteBuf.getBytes(abstractByteBuf.readerIndex, gatheringByteChannel, n2);
        this.readerIndex += n3;
        return n3;
    }

    @Override
    public ByteBuf readBytes(OutputStream outputStream, int n2) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.getBytes(abstractByteBuf.readerIndex, outputStream, n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf skipBytes(int n2) {
        this.checkReadableBytes(n2);
        this.readerIndex += n2;
        return this;
    }

    @Override
    public ByteBuf writeBoolean(boolean bl) {
        ((ByteBuf)this).writeByte(bl ? 1 : 0);
        return this;
    }

    @Override
    public ByteBuf writeByte(int n2) {
        this.ensureAccessible();
        this.ensureWritable0(1);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setByte(abstractByteBuf.writerIndex++, n2);
        return this;
    }

    @Override
    public ByteBuf writeShort(int n2) {
        this.ensureAccessible();
        this.ensureWritable0(2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setShort(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public ByteBuf writeMedium(int n2) {
        this.ensureAccessible();
        this.ensureWritable0(3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setMedium(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 3;
        return this;
    }

    @Override
    public ByteBuf writeInt(int n2) {
        this.ensureAccessible();
        this.ensureWritable0(4);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setInt(abstractByteBuf.writerIndex, n2);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public ByteBuf writeLong(long l2) {
        this.ensureAccessible();
        this.ensureWritable0(8);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf._setLong(abstractByteBuf.writerIndex, l2);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public ByteBuf writeChar(int n2) {
        ((ByteBuf)this).writeShort(n2);
        return this;
    }

    @Override
    public ByteBuf writeFloat(float f2) {
        ((ByteBuf)this).writeInt(Float.floatToRawIntBits(f2));
        return this;
    }

    @Override
    public ByteBuf writeDouble(double d2) {
        ((ByteBuf)this).writeLong(Double.doubleToRawLongBits(d2));
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        this.ensureAccessible();
        ((ByteBuf)this).ensureWritable(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byArray, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(byte[] byArray) {
        ((ByteBuf)this).writeBytes(byArray, 0, byArray.length);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).writeBytes(byteBuf2, byteBuf2.readableBytes());
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        if (n2 > byteBuf.readableBytes()) {
            throw new IndexOutOfBoundsException(String.format("length(%d) exceeds src.readableBytes(%d) where src is: %s", n2, byteBuf.readableBytes(), byteBuf));
        }
        ByteBuf byteBuf2 = byteBuf;
        ((ByteBuf)this).writeBytes(byteBuf2, byteBuf2.readerIndex(), n2);
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.readerIndex(byteBuf3.readerIndex() + n2);
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        this.ensureAccessible();
        ((ByteBuf)this).ensureWritable(n3);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuf, n2, n3);
        this.writerIndex += n3;
        return this;
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer byteBuffer) {
        this.ensureAccessible();
        int n2 = byteBuffer.remaining();
        ((ByteBuf)this).ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.setBytes(abstractByteBuf.writerIndex, byteBuffer);
        this.writerIndex += n2;
        return this;
    }

    @Override
    public int writeBytes(InputStream inputStream, int n2) {
        this.ensureAccessible();
        ((ByteBuf)this).ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        int n3 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, inputStream, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public int writeBytes(ScatteringByteChannel scatteringByteChannel, int n2) {
        this.ensureAccessible();
        ((ByteBuf)this).ensureWritable(n2);
        AbstractByteBuf abstractByteBuf = this;
        int n3 = abstractByteBuf.setBytes(abstractByteBuf.writerIndex, scatteringByteChannel, n2);
        if (n3 > 0) {
            this.writerIndex += n3;
        }
        return n3;
    }

    @Override
    public ByteBuf writeZero(int n2) {
        if (n2 == 0) {
            return this;
        }
        ((ByteBuf)this).ensureWritable(n2);
        int n3 = this.writerIndex;
        this.checkIndex(n3, n2);
        int n4 = n2 >>> 3;
        n2 &= 7;
        while (n4 > 0) {
            this._setLong(n3, 0L);
            n3 += 8;
            --n4;
        }
        if (n2 == 4) {
            this._setInt(n3, 0);
            n3 += 4;
        } else if (n2 < 4) {
            for (n4 = n2; n4 > 0; --n4) {
                this._setByte(n3, 0);
                ++n3;
            }
        } else {
            this._setInt(n3, 0);
            n3 += 4;
            for (n4 = n2 - 4; n4 > 0; --n4) {
                this._setByte(n3, 0);
                ++n3;
            }
        }
        this.writerIndex = n3;
        return this;
    }

    @Override
    public ByteBuf copy() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.copy(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf duplicate() {
        return new DuplicatedAbstractByteBuf(this);
    }

    @Override
    public ByteBuf slice() {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).slice(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        return new SlicedAbstractByteBuf(this, n2, n3);
    }

    @Override
    public ByteBuffer nioBuffer() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffer(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        AbstractByteBuf abstractByteBuf = this;
        return abstractByteBuf.nioBuffers(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes());
    }

    @Override
    public String toString(Charset charset) {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).toString(abstractByteBuf.readerIndex, ((ByteBuf)this).readableBytes(), charset);
    }

    @Override
    public String toString(int n2, int n3, Charset charset) {
        return ByteBufUtil.decodeString(this, n2, n3, charset);
    }

    @Override
    public int indexOf(int n2, int n3, byte by) {
        return ByteBufUtil.indexOf(this, n2, n3, by);
    }

    @Override
    public int bytesBefore(byte by) {
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), ((ByteBuf)this).readableBytes(), by);
    }

    @Override
    public int bytesBefore(int n2, byte by) {
        this.checkReadableBytes(n2);
        AbstractByteBuf abstractByteBuf = this;
        return ((ByteBuf)abstractByteBuf).bytesBefore(((ByteBuf)abstractByteBuf).readerIndex(), n2, by);
    }

    @Override
    public int bytesBefore(int n2, int n3, byte by) {
        int n4 = n2;
        if ((n3 = ((ByteBuf)this).indexOf(n4, n4 + n3, by)) < 0) {
            return -1;
        }
        return n3 - n2;
    }

    @Override
    public int forEachByte(ByteBufProcessor object) {
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteAsc0(abstractByteBuf.readerIndex, this.writerIndex, (ByteBufProcessor)object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByte(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        this.checkIndex(n2, n3);
        try {
            int n4 = n2;
            return this.forEachByteAsc0(n4, n4 + n3, byteBufProcessor);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    private int forEachByteAsc0(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        while (n2 < n3) {
            if (!byteBufProcessor.process(this._getByte(n2))) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int forEachByteDesc(ByteBufProcessor object) {
        this.ensureAccessible();
        try {
            AbstractByteBuf abstractByteBuf = this;
            return abstractByteBuf.forEachByteDesc0(abstractByteBuf.writerIndex - 1, this.readerIndex, (ByteBufProcessor)object);
        }
        catch (Exception exception) {
            object = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    @Override
    public int forEachByteDesc(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        this.checkIndex(n2, n3);
        try {
            return this.forEachByteDesc0(n2 + n3 - 1, n2, byteBufProcessor);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            PlatformDependent.throwException(exception);
            return -1;
        }
    }

    private int forEachByteDesc0(int n2, int n3, ByteBufProcessor byteBufProcessor) {
        while (n2 >= n3) {
            if (!byteBufProcessor.process(this._getByte(n2))) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    @Override
    public int hashCode() {
        return ByteBufUtil.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteBuf) {
            return ByteBufUtil.equals(this, (ByteBuf)object);
        }
        return false;
    }

    @Override
    public int compareTo(ByteBuf byteBuf) {
        return ByteBufUtil.compare(this, byteBuf);
    }

    @Override
    public String toString() {
        ByteBuf byteBuf;
        if (this.refCnt() == 0) {
            return StringUtil.simpleClassName(this) + "(freed)";
        }
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append("(ridx: ").append(this.readerIndex).append(", widx: ").append(this.writerIndex).append(", cap: ").append(this.capacity());
        if (this.maxCapacity != Integer.MAX_VALUE) {
            stringBuilder.append('/').append(this.maxCapacity);
        }
        if ((byteBuf = this.unwrap()) != null) {
            stringBuilder.append(", unwrapped: ").append(byteBuf);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    protected final void checkIndex(int n2) {
        this.checkIndex(n2, 1);
    }

    protected final void checkIndex(int n2, int n3) {
        this.ensureAccessible();
        this.checkIndex0(n2, n3);
    }

    final void checkIndex0(int n2, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, this.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", n2, n3, this.capacity()));
        }
    }

    protected final void checkSrcIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (MathUtil.isOutOfBounds(n4, n3, n5)) {
            throw new IndexOutOfBoundsException(String.format("srcIndex: %d, length: %d (expected: range(0, %d))", n4, n3, n5));
        }
    }

    protected final void checkDstIndex(int n2, int n3, int n4, int n5) {
        this.checkIndex(n2, n3);
        if (MathUtil.isOutOfBounds(n4, n3, n5)) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n4, n3, n5));
        }
    }

    protected final void checkReadableBytes(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("minimumReadableBytes: " + n2 + " (expected: >= 0)");
        }
        this.checkReadableBytes0(n2);
    }

    private void checkReadableBytes0(int n2) {
        this.ensureAccessible();
        if (this.readerIndex > this.writerIndex - n2) {
            throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d): %s", this.readerIndex, n2, this.writerIndex, this));
        }
    }

    protected final void ensureAccessible() {
        if (checkAccessible && this.refCnt() == 0) {
            throw new IllegalReferenceCountException(0);
        }
    }

    final void setIndex0(int n2, int n3) {
        this.readerIndex = n2;
        this.writerIndex = n3;
    }

    final void discardMarks() {
        AbstractByteBuf abstractByteBuf = this;
        abstractByteBuf.markedWriterIndex = 0;
        abstractByteBuf.markedReaderIndex = 0;
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_MODE, (Object)checkAccessible);
        }
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ByteBuf.class);
    }
}

