/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.AdvancedLeakAwareByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.AdvancedLeakAwareCompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.EmptyByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.SimpleLeakAwareByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeak;
import com.aliyun.openservices.shade.io.netty.util.ResourceLeakDetector;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;

public abstract class AbstractByteBufAllocator
implements ByteBufAllocator {
    private static final int DEFAULT_INITIAL_CAPACITY = 256;
    static final int DEFAULT_MAX_COMPONENTS = 16;
    private final boolean directByDefault;
    private final ByteBuf emptyBuf;

    protected static ByteBuf toLeakAwareBuffer(ByteBuf byteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeak resourceLeak = AbstractByteBuf.leakDetector.open(byteBuf);
                if (resourceLeak == null) break;
                byteBuf = new SimpleLeakAwareByteBuf(byteBuf, resourceLeak);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeak resourceLeak = AbstractByteBuf.leakDetector.open(byteBuf);
                if (resourceLeak == null) break;
                byteBuf = new AdvancedLeakAwareByteBuf(byteBuf, resourceLeak);
            }
        }
        return byteBuf;
    }

    protected static CompositeByteBuf toLeakAwareBuffer(CompositeByteBuf compositeByteBuf) {
        switch (ResourceLeakDetector.getLevel()) {
            case SIMPLE: {
                ResourceLeak resourceLeak = AbstractByteBuf.leakDetector.open(compositeByteBuf);
                if (resourceLeak == null) break;
                compositeByteBuf = new SimpleLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeak);
                break;
            }
            case ADVANCED: 
            case PARANOID: {
                ResourceLeak resourceLeak = AbstractByteBuf.leakDetector.open(compositeByteBuf);
                if (resourceLeak == null) break;
                compositeByteBuf = new AdvancedLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeak);
            }
        }
        return compositeByteBuf;
    }

    protected AbstractByteBufAllocator() {
        this(false);
    }

    protected AbstractByteBufAllocator(boolean bl) {
        this.directByDefault = bl && PlatformDependent.hasUnsafe();
        this.emptyBuf = new EmptyByteBuf(this);
    }

    @Override
    public ByteBuf buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n2) {
        if (this.directByDefault) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf buffer(int n2, int n3) {
        if (this.directByDefault) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf ioBuffer() {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(256);
        }
        return this.heapBuffer(256);
    }

    @Override
    public ByteBuf ioBuffer(int n2) {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf ioBuffer(int n2, int n3) {
        if (PlatformDependent.hasUnsafe()) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2) {
        return this.heapBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newHeapBuffer(n2, n3);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2) {
        return this.directBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newDirectBuffer(n2, n3);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        if (this.directByDefault) {
            return this.compositeDirectBuffer();
        }
        return this.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n2) {
        if (this.directByDefault) {
            return this.compositeDirectBuffer(n2);
        }
        return this.compositeHeapBuffer(n2);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.compositeHeapBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, false, n2));
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.compositeDirectBuffer(16);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, true, n2));
    }

    private static void validate(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity: " + n2 + " (expectd: 0+)");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", n2, n3));
        }
    }

    protected abstract ByteBuf newHeapBuffer(int var1, int var2);

    protected abstract ByteBuf newDirectBuffer(int var1, int var2);

    public String toString() {
        return StringUtil.simpleClassName(this) + "(directByDefault: " + this.directByDefault + ')';
    }
}

