/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.util.IllegalReferenceCountException;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCountedByteBuf
extends AbstractByteBuf {
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> refCntUpdater;
    private volatile int refCnt = 1;

    protected AbstractReferenceCountedByteBuf(int n2) {
        super(n2);
    }

    @Override
    public int refCnt() {
        return this.refCnt;
    }

    protected final void setRefCnt(int n2) {
        this.refCnt = n2;
    }

    @Override
    public ByteBuf retain() {
        return this.retain0(1);
    }

    @Override
    public ByteBuf retain(int n2) {
        return this.retain0(ObjectUtil.checkPositive(n2, "increment"));
    }

    private ByteBuf retain0(int n2) {
        int n3;
        int n4;
        do {
            if ((n3 = (n4 = this.refCnt) + n2) > n2) continue;
            throw new IllegalReferenceCountException(n4, n2);
        } while (!refCntUpdater.compareAndSet(this, n4, n3));
        return this;
    }

    @Override
    public boolean release() {
        return this.release0(1);
    }

    @Override
    public boolean release(int n2) {
        return this.release0(ObjectUtil.checkPositive(n2, "decrement"));
    }

    private boolean release0(int n2) {
        int n3;
        int n4;
        do {
            if ((n3 = this.refCnt) < n2) {
                throw new IllegalReferenceCountException(n3, -n2);
            }
            n4 = n3;
        } while (!refCntUpdater.compareAndSet(this, n4, n4 - n2));
        if (n3 == n2) {
            this.deallocate();
            return true;
        }
        return false;
    }

    protected abstract void deallocate();

    static {
        AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> atomicIntegerFieldUpdater = PlatformDependent.newAtomicIntegerFieldUpdater(AbstractReferenceCountedByteBuf.class, "refCnt");
        if (atomicIntegerFieldUpdater == null) {
            atomicIntegerFieldUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCountedByteBuf.class, "refCnt");
        }
        refCntUpdater = atomicIntegerFieldUpdater;
    }
}

