/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.util.internal.MathUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;

final class ByteBufUtil$HexUtil {
    private static final char[] BYTE2CHAR;
    private static final char[] HEXDUMP_TABLE;
    private static final String[] HEXPADDING;
    private static final String[] HEXDUMP_ROWPREFIXES;
    private static final String[] BYTE2HEX;
    private static final String[] BYTEPADDING;

    private ByteBufUtil$HexUtil() {
    }

    private static String hexDump(ByteBuf byteBuf, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("length: " + n3);
        }
        if (n3 == 0) {
            return "";
        }
        int n4 = n2 + n3;
        char[] cArray = new char[n3 << 1];
        int n5 = 0;
        while (n2 < n4) {
            System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n2) << 1, cArray, n5, 2);
            ++n2;
            n5 += 2;
        }
        return new String(cArray);
    }

    private static String hexDump(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("length: " + n3);
        }
        if (n3 == 0) {
            return "";
        }
        int n4 = n2 + n3;
        char[] cArray = new char[n3 << 1];
        int n5 = 0;
        while (n2 < n4) {
            System.arraycopy(HEXDUMP_TABLE, (byArray[n2] & 0xFF) << 1, cArray, n5, 2);
            ++n2;
            n5 += 2;
        }
        return new String(cArray);
    }

    private static String prettyHexDump(ByteBuf byteBuf, int n2, int n3) {
        if (n3 == 0) {
            return "";
        }
        int n4 = n3 / 16 + (n3 % 15 == 0 ? 0 : 1) + 4;
        StringBuilder stringBuilder = new StringBuilder(n4 * 80);
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n2, n3);
        return stringBuilder.toString();
    }

    private static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (MathUtil.isOutOfBounds(n2, n3, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= offset(" + n2 + ") <= offset + length(" + n3 + ") <= buf.capacity(" + byteBuf.capacity() + ')');
        }
        if (n3 == 0) {
            return;
        }
        stringBuilder.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        int n7 = n3 >>> 4;
        n3 &= 0xF;
        for (n6 = 0; n6 < n7; ++n6) {
            int n8;
            n5 = (n6 << 4) + n2;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n6, n5);
            n4 = n5 + 16;
            for (n8 = n5; n8 < n4; ++n8) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append(" |");
            for (n8 = n5; n8 < n4; ++n8) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n8)]);
            }
            stringBuilder.append('|');
        }
        if (n3 != 0) {
            n6 = (n7 << 4) + n2;
            ByteBufUtil$HexUtil.appendHexDumpRowPrefix(stringBuilder, n7, n6);
            n5 = n6 + n3;
            for (n4 = n6; n4 < n5; ++n4) {
                stringBuilder.append(BYTE2HEX[byteBuf.getUnsignedByte(n4)]);
            }
            stringBuilder.append(HEXPADDING[n3]);
            stringBuilder.append(" |");
            for (n4 = n6; n4 < n5; ++n4) {
                stringBuilder.append(BYTE2CHAR[byteBuf.getUnsignedByte(n4)]);
            }
            stringBuilder.append(BYTEPADDING[n3]);
            stringBuilder.append('|');
        }
        stringBuilder.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
    }

    private static void appendHexDumpRowPrefix(StringBuilder stringBuilder, int n2, int n3) {
        if (n2 < HEXDUMP_ROWPREFIXES.length) {
            stringBuilder.append(HEXDUMP_ROWPREFIXES[n2]);
            return;
        }
        stringBuilder.append(StringUtil.NEWLINE);
        stringBuilder.append(Long.toHexString((long)n3 & 0xFFFFFFFFL | 0x100000000L));
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setCharAt(stringBuilder2.length() - 9, '|');
        stringBuilder.append('|');
    }

    static /* synthetic */ String access$000(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.hexDump(byteBuf, n2, n3);
    }

    static /* synthetic */ String access$100(byte[] byArray, int n2, int n3) {
        return ByteBufUtil$HexUtil.hexDump(byArray, n2, n3);
    }

    static /* synthetic */ String access$200(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.prettyHexDump(byteBuf, n2, n3);
    }

    static /* synthetic */ void access$300(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
        ByteBufUtil$HexUtil.appendPrettyHexDump(stringBuilder, byteBuf, n2, n3);
    }

    static {
        int n2;
        StringBuilder stringBuilder;
        int n3;
        BYTE2CHAR = new char[256];
        HEXDUMP_TABLE = new char[1024];
        HEXPADDING = new String[16];
        HEXDUMP_ROWPREFIXES = new String[4096];
        BYTE2HEX = new String[256];
        BYTEPADDING = new String[16];
        Object object = "0123456789abcdef".toCharArray();
        for (n3 = 0; n3 < 256; ++n3) {
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[n3 << 1] = object[n3 >>> 4 & 0xF];
            ByteBufUtil$HexUtil.HEXDUMP_TABLE[(n3 << 1) + 1] = object[n3 & 0xF];
        }
        for (n3 = 0; n3 < HEXPADDING.length; ++n3) {
            int n4 = HEXPADDING.length - n3;
            stringBuilder = new StringBuilder(n4 * 3);
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append("   ");
            }
            ByteBufUtil$HexUtil.HEXPADDING[n3] = stringBuilder.toString();
        }
        for (n3 = 0; n3 < HEXDUMP_ROWPREFIXES.length; ++n3) {
            StringBuilder stringBuilder2 = new StringBuilder(12);
            object = stringBuilder2;
            stringBuilder2.append(StringUtil.NEWLINE);
            ((StringBuilder)object).append(Long.toHexString((long)(n3 << 4) & 0xFFFFFFFFL | 0x100000000L));
            Object object2 = object;
            ((StringBuilder)object2).setCharAt(((StringBuilder)object2).length() - 9, '|');
            ((StringBuilder)object).append('|');
            ByteBufUtil$HexUtil.HEXDUMP_ROWPREFIXES[n3] = ((StringBuilder)object).toString();
        }
        for (n3 = 0; n3 < BYTE2HEX.length; ++n3) {
            ByteBufUtil$HexUtil.BYTE2HEX[n3] = " " + StringUtil.byteToHexStringPadded(n3);
        }
        for (n3 = 0; n3 < BYTEPADDING.length; ++n3) {
            int n5 = BYTEPADDING.length - n3;
            stringBuilder = new StringBuilder(n5);
            for (n2 = 0; n2 < n5; ++n2) {
                stringBuilder.append(' ');
            }
            ByteBufUtil$HexUtil.BYTEPADDING[n3] = stringBuilder.toString();
        }
        for (n3 = 0; n3 < BYTE2CHAR.length; ++n3) {
            if (n3 <= 31 || n3 >= 127) {
                ByteBufUtil$HexUtil.BYTE2CHAR[n3] = 46;
                continue;
            }
            int n6 = n3;
            ByteBufUtil$HexUtil.BYTE2CHAR[n6] = (char)n6;
        }
    }
}

