/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.AbstractByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufProcessor;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$1;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$2;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$HexUtil;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$IndexOfProcessor;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$ThreadLocalDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufUtil$ThreadLocalUnsafeDirectByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.PooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.UnpooledByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.WrappedByteBuf;
import com.aliyun.openservices.shade.io.netty.util.CharsetUtil;
import com.aliyun.openservices.shade.io.netty.util.concurrent.FastThreadLocal;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.PlatformDependent;
import com.aliyun.openservices.shade.io.netty.util.internal.StringUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.SystemPropertyUtil;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLogger;
import com.aliyun.openservices.shade.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<CharBuffer> CHAR_BUFFERS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    private static final ByteBufProcessor FIND_NON_ASCII;

    public static String hexDump(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.hexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$000(byteBuf, n2, n3);
    }

    public static String hexDump(byte[] byArray) {
        return ByteBufUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$100(byArray, n2, n3);
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        int n3 = n2 >>> 2;
        n2 &= 3;
        int n4 = 1;
        int n5 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            while (n3 > 0) {
                n4 = n4 * 31 + byteBuf.getInt(n5);
                n5 += 4;
                --n3;
            }
        } else {
            while (n3 > 0) {
                n4 = n4 * 31 + ByteBufUtil.swapInt(byteBuf.getInt(n5));
                n5 += 4;
                --n3;
            }
        }
        for (n3 = n2; n3 > 0; --n3) {
            n4 = n4 * 31 + byteBuf.getByte(n5++);
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return n4;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes();
        if (n2 != byteBuf2.readableBytes()) {
            return false;
        }
        int n3 = n2 >>> 3;
        n2 &= 7;
        int n4 = byteBuf.readerIndex();
        int n5 = byteBuf2.readerIndex();
        if (byteBuf.order() == byteBuf2.order()) {
            while (n3 > 0) {
                if (byteBuf.getLong(n4) != byteBuf2.getLong(n5)) {
                    return false;
                }
                n4 += 8;
                n5 += 8;
                --n3;
            }
        } else {
            while (n3 > 0) {
                if (byteBuf.getLong(n4) != ByteBufUtil.swapLong(byteBuf2.getLong(n5))) {
                    return false;
                }
                n4 += 8;
                n5 += 8;
                --n3;
            }
        }
        for (n3 = n2; n3 > 0; --n3) {
            if (byteBuf.getByte(n4) != byteBuf2.getByte(n5)) {
                return false;
            }
            ++n4;
            ++n5;
        }
        return true;
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf2.readableBytes();
        int n5 = Math.min(n3, n4);
        int n6 = n5 >>> 2;
        n5 &= 3;
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf2.readerIndex();
        if (n6 > 0) {
            long l2;
            n2 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            n6 <<= 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n7, n8, n6) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n7, n8, n6);
            } else {
                long l3 = l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n7, n8, n6) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n7, n8, n6);
            }
            if (l2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, l2);
            }
            n7 += n6;
            n8 += n6;
        }
        n2 = n7 + n5;
        while (n7 < n2) {
            n5 = byteBuf.getUnsignedByte(n7) - byteBuf2.getUnsignedByte(n8);
            if (n5 != 0) {
                return n5;
            }
            ++n7;
            ++n8;
        }
        return n3 - n4;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = ((long)ByteBufUtil.swapInt(byteBuf.getInt(n2)) & 0xFFFFFFFFL) - ((long)ByteBufUtil.swapInt(byteBuf2.getInt(n3)) & 0xFFFFFFFFL);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedInt(n2) - ((long)ByteBufUtil.swapInt(byteBuf2.getInt(n3)) & 0xFFFFFFFFL);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = ((long)ByteBufUtil.swapInt(byteBuf.getInt(n2)) & 0xFFFFFFFFL) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    public static int indexOf(ByteBuf byteBuf, int n2, int n3, byte by) {
        if (n2 <= n3) {
            return ByteBufUtil.firstIndexOf(byteBuf, n2, n3, by);
        }
        return ByteBufUtil.lastIndexOf(byteBuf, n2, n3, by);
    }

    public static short swapShort(short s2) {
        return Short.reverseBytes(s2);
    }

    public static int swapMedium(int n2) {
        if (((n2 = n2 << 16 & 0xFF0000 | n2 & 0xFF00 | n2 >>> 16 & 0xFF) & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    public static int swapInt(int n2) {
        return Integer.reverseBytes(n2);
    }

    public static long swapLong(long l2) {
        return Long.reverseBytes(l2);
    }

    public static ByteBuf readBytes(ByteBufAllocator object, ByteBuf object2, int n2) {
        boolean bl = true;
        object = object.buffer(n2);
        try {
            ((ByteBuf)object2).readBytes((ByteBuf)object);
            bl = false;
            object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl) {
                object.release();
            }
            throw throwable;
        }
    }

    private static int firstIndexOf(ByteBuf byteBuf, int n2, int n3, byte by) {
        if ((n2 = Math.max(n2, 0)) >= n3 || byteBuf.capacity() == 0) {
            return -1;
        }
        return byteBuf.forEachByte(n2, n3 - n2, new ByteBufUtil$IndexOfProcessor(by));
    }

    private static int lastIndexOf(ByteBuf byteBuf, int n2, int n3, byte by) {
        if ((n2 = Math.min(n2, byteBuf.capacity())) < 0 || byteBuf.capacity() == 0) {
            return -1;
        }
        return byteBuf.forEachByteDesc(n3, n2 - n3, new ByteBufUtil$IndexOfProcessor(by));
    }

    public static ByteBuf writeUtf8(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(charSequence.length() * MAX_BYTES_PER_CHAR_UTF8);
        ByteBufUtil.writeUtf8((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence object) {
        int n2 = object.length();
        byteBuf.ensureWritable(n2 * MAX_BYTES_PER_CHAR_UTF8);
        while (true) {
            if (byteBuf instanceof AbstractByteBuf) {
                return ByteBufUtil.writeUtf8((AbstractByteBuf)byteBuf, (CharSequence)object, n2);
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        object = object.toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes((byte[])object);
        return ((Object)object).length;
    }

    private static int writeUtf8(AbstractByteBuf abstractByteBuf, CharSequence charSequence, int n2) {
        int n3;
        int n4 = n3 = abstractByteBuf.writerIndex;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = charSequence.charAt(i2);
            if (n5 < 128) {
                abstractByteBuf._setByte(n4++, (byte)n5);
                continue;
            }
            if (n5 < 2048) {
                abstractByteBuf._setByte(n4++, (byte)(0xC0 | n5 >> 6));
                abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate((char)n5)) {
                char c2;
                if (!Character.isHighSurrogate((char)n5)) {
                    abstractByteBuf._setByte(n4++, 63);
                    continue;
                }
                try {
                    c2 = charSequence.charAt(++i2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    abstractByteBuf._setByte(n4++, 63);
                    break;
                }
                if (!Character.isLowSurrogate(c2)) {
                    abstractByteBuf._setByte(n4++, 63);
                    abstractByteBuf._setByte(n4++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                n5 = Character.toCodePoint((char)n5, c2);
                abstractByteBuf._setByte(n4++, (byte)(0xF0 | n5 >> 18));
                abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 >> 12 & 0x3F));
                abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 >> 6 & 0x3F));
                abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            abstractByteBuf._setByte(n4++, (byte)(0xE0 | n5 >> 12));
            abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 >> 6 & 0x3F));
            abstractByteBuf._setByte(n4++, (byte)(0x80 | n5 & 0x3F));
        }
        abstractByteBuf.writerIndex = n4;
        return n4 - n3;
    }

    public static ByteBuf writeAscii(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(charSequence.length());
        ByteBufUtil.writeAscii((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        int n2 = charSequence.length();
        byteBuf.ensureWritable(n2);
        while (true) {
            if (byteBuf instanceof AbstractByteBuf) break;
            if (byteBuf instanceof WrappedByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            byteBuf.writeBytes(charSequence.toString().getBytes(CharsetUtil.US_ASCII));
        }
        ByteBufUtil.writeAscii((AbstractByteBuf)byteBuf, charSequence, n2);
        return n2;
    }

    private static void writeAscii(AbstractByteBuf abstractByteBuf, CharSequence charSequence, int n2) {
        int n3 = abstractByteBuf.writerIndex;
        for (int i2 = 0; i2 < n2; ++i2) {
            abstractByteBuf._setByte(n3++, (byte)charSequence.charAt(i2));
        }
        abstractByteBuf.writerIndex = n3;
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset);
    }

    static ByteBuf encodeString0(ByteBufAllocator object, boolean bl, CharBuffer object2, Charset object3) {
        object3 = CharsetUtil.encoder((Charset)object3);
        int n2 = (int)((double)((Buffer)object2).remaining() * (double)((CharsetEncoder)object3).maxBytesPerChar());
        boolean bl2 = true;
        object = bl ? object.heapBuffer(n2) : object.buffer(n2);
        try {
            Object object4 = ((ByteBuf)object).internalNioBuffer(0, n2);
            n2 = ((Buffer)object4).position();
            object2 = ((CharsetEncoder)object3).encode((CharBuffer)object2, (ByteBuffer)object4, true);
            if (!((CoderResult)object2).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            if (!((CoderResult)(object2 = ((CharsetEncoder)object3).flush((ByteBuffer)object4))).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            Object object5 = object;
            ((ByteBuf)object5).writerIndex(((ByteBuf)object5).writerIndex() + ((Buffer)object4).position() - n2);
            bl2 = false;
            object4 = object;
            return object4;
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                throw new IllegalStateException(characterCodingException);
            }
            catch (Throwable throwable) {
                if (bl2) {
                    object.release();
                }
                throw throwable;
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n2, int n3, Charset object) {
        if (n3 == 0) {
            return "";
        }
        object = CharsetUtil.decoder((Charset)object);
        int n4 = (int)((double)n3 * (double)((CharsetDecoder)object).maxCharsPerByte());
        CharBuffer charBuffer = CHAR_BUFFERS.get();
        if (charBuffer.length() < n4) {
            charBuffer = CharBuffer.allocate(n4);
            if (n4 <= MAX_CHAR_BUFFER_SIZE) {
                CHAR_BUFFERS.set(charBuffer);
            }
        } else {
            charBuffer.clear();
        }
        if (byteBuf.nioBufferCount() == 1) {
            ByteBufUtil.decodeString((CharsetDecoder)object, byteBuf.internalNioBuffer(n2, n3), charBuffer);
        } else {
            ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n3);
            try {
                byteBuf2.writeBytes(byteBuf, n2, n3);
                ByteBufUtil.decodeString((CharsetDecoder)object, byteBuf2.internalNioBuffer(0, n3), charBuffer);
            }
            finally {
                byteBuf2.release();
            }
        }
        return charBuffer.flip().toString();
    }

    private static void decodeString(CharsetDecoder charsetDecoder, ByteBuffer object, CharBuffer charBuffer) {
        try {
            object = charsetDecoder.decode((ByteBuffer)object, charBuffer, true);
            if (!((CoderResult)object).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            if (!((CoderResult)(object = charsetDecoder.flush(charBuffer))).isUnderflow()) {
                ((CoderResult)object).throwException();
            }
            return;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
    }

    public static String prettyHexDump(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.prettyHexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static String prettyHexDump(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil$HexUtil.access$200(byteBuf, n2, n3);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n2, int n3) {
        ByteBufUtil$HexUtil.access$300(stringBuilder, byteBuf, n2, n3);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ByteBufUtil$ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ByteBufUtil$ThreadLocalDirectByteBuf.newInstance();
    }

    public static boolean isText(ByteBuf byteBuf, Charset charset) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.isText(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes(), charset);
    }

    public static boolean isText(ByteBuf byteBuf, int n2, int n3, Charset object) {
        ObjectUtil.checkNotNull(byteBuf, "buf");
        ObjectUtil.checkNotNull(object, "charset");
        int n4 = byteBuf.readerIndex() + byteBuf.readableBytes();
        if (n2 < 0 || n3 < 0 || n2 > n4 - n3) {
            throw new IndexOutOfBoundsException("index: " + n2 + " length: " + n3);
        }
        if (((Charset)object).equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(byteBuf, n2, n3);
        }
        if (((Charset)object).equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(byteBuf, n2, n3);
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        object = CharsetUtil.decoder((Charset)object, codingErrorAction, codingErrorAction);
        try {
            if (byteBuf.nioBufferCount() == 1) {
                ((CharsetDecoder)object).decode(byteBuf.internalNioBuffer(n2, n3));
            } else {
                ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n3);
                try {
                    byteBuf2.writeBytes(byteBuf, n2, n3);
                    ((CharsetDecoder)object).decode(byteBuf2.internalNioBuffer(0, n3));
                }
                finally {
                    byteBuf2.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private static boolean isAscii(ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.forEachByte(n2, n3, FIND_NON_ASCII) == -1;
    }

    private static boolean isUtf8(ByteBuf byteBuf, int n2, int n3) {
        n3 = n2 + n3;
        while (n2 < n3) {
            byte by;
            byte by2;
            byte by3;
            if (((by3 = byteBuf.getByte(n2++)) & 0x80) == 0) continue;
            if ((by3 & 0xE0) == 192) {
                if (n2 >= n3) {
                    return false;
                }
                if (((by2 = byteBuf.getByte(n2++)) & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) >= 194) continue;
                return false;
            }
            if ((by3 & 0xF0) == 224) {
                if (n2 > n3 - 2) {
                    return false;
                }
                by2 = byteBuf.getByte(n2++);
                by = byteBuf.getByte(n2++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xF) == 0 && (by2 & 0xFF) < 160) {
                    return false;
                }
                if ((by3 & 0xF) != 13 || (by2 & 0xFF) <= 159) continue;
                return false;
            }
            if ((by3 & 0xF8) == 240) {
                if (n2 > n3 - 3) {
                    return false;
                }
                by2 = byteBuf.getByte(n2++);
                by = byteBuf.getByte(n2++);
                byte by4 = byteBuf.getByte(n2++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) <= 244 && ((by3 & 0xFF) != 240 || (by2 & 0xFF) >= 144) && ((by3 & 0xFF) != 244 || (by2 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private ByteBufUtil() {
    }

    static /* synthetic */ int access$500() {
        return THREAD_LOCAL_BUFFER_SIZE;
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        CHAR_BUFFERS = new ByteBufUtil$1();
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("com.aliyun.openservices.shade.io.netty.allocator.type", "unpooled").toLowerCase(Locale.US).trim();
        if ("unpooled".equals(string)) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: unpooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.threadLocalDirectBufferSize", 65536);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("com.aliyun.openservices.shade.io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteBufUtil$2();
    }
}

