/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.io.netty.buffer;

import com.aliyun.openservices.shade.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBuf;
import com.aliyun.openservices.shade.io.netty.buffer.ByteBufAllocator;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf$Component;
import com.aliyun.openservices.shade.io.netty.buffer.CompositeByteBuf$CompositeByteBufIterator;
import com.aliyun.openservices.shade.io.netty.buffer.Unpooled;
import com.aliyun.openservices.shade.io.netty.util.internal.EmptyArrays;
import com.aliyun.openservices.shade.io.netty.util.internal.ObjectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CompositeByteBuf
extends AbstractReferenceCountedByteBuf
implements Iterable<ByteBuf> {
    private static final ByteBuffer EMPTY_NIO_BUFFER = Unpooled.EMPTY_BUFFER.nioBuffer();
    private static final Iterator<ByteBuf> EMPTY_ITERATOR = Collections.emptyList().iterator();
    private final ByteBufAllocator alloc;
    private final boolean direct;
    private final List<CompositeByteBuf$Component> components;
    private final int maxNumComponents;
    private boolean freed;

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n2) {
        super(Integer.MAX_VALUE);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        this.alloc = byteBufAllocator;
        this.direct = bl;
        this.maxNumComponents = n2;
        this.components = CompositeByteBuf.newList(n2);
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n2, ByteBuf ... byteBufArray) {
        this(byteBufAllocator, bl, n2, byteBufArray, 0, byteBufArray.length);
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n2, ByteBuf[] byteBufArray, int n3, int n4) {
        super(Integer.MAX_VALUE);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("maxNumComponents: " + n2 + " (expected: >= 2)");
        }
        this.alloc = byteBufAllocator;
        this.direct = bl;
        this.maxNumComponents = n2;
        this.components = CompositeByteBuf.newList(n2);
        this.addComponents0(false, 0, byteBufArray, n3, n4);
        this.consolidateIfNeeded();
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    public CompositeByteBuf(ByteBufAllocator byteBufAllocator, boolean bl, int n2, Iterable<ByteBuf> iterable) {
        super(Integer.MAX_VALUE);
        if (byteBufAllocator == null) {
            throw new NullPointerException("alloc");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("maxNumComponents: " + n2 + " (expected: >= 2)");
        }
        this.alloc = byteBufAllocator;
        this.direct = bl;
        this.maxNumComponents = n2;
        this.components = CompositeByteBuf.newList(n2);
        this.addComponents0(false, 0, iterable);
        this.consolidateIfNeeded();
        this.setIndex(0, ((ByteBuf)this).capacity());
    }

    private static List<CompositeByteBuf$Component> newList(int n2) {
        return new ArrayList<CompositeByteBuf$Component>(Math.min(16, n2));
    }

    CompositeByteBuf(ByteBufAllocator byteBufAllocator) {
        super(Integer.MAX_VALUE);
        this.alloc = byteBufAllocator;
        this.direct = false;
        this.maxNumComponents = 0;
        this.components = Collections.emptyList();
    }

    public CompositeByteBuf addComponent(ByteBuf byteBuf) {
        return this.addComponent(false, byteBuf);
    }

    public CompositeByteBuf addComponents(ByteBuf ... byteBufArray) {
        return this.addComponents(false, byteBufArray);
    }

    public CompositeByteBuf addComponents(Iterable<ByteBuf> iterable) {
        return this.addComponents(false, iterable);
    }

    public CompositeByteBuf addComponent(int n2, ByteBuf byteBuf) {
        return this.addComponent(false, n2, byteBuf);
    }

    public CompositeByteBuf addComponent(boolean bl, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.addComponent0(bl, this.components.size(), byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean bl, ByteBuf ... byteBufArray) {
        this.addComponents0(bl, this.components.size(), byteBufArray, 0, byteBufArray.length);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponents(boolean bl, Iterable<ByteBuf> iterable) {
        this.addComponents0(bl, this.components.size(), iterable);
        this.consolidateIfNeeded();
        return this;
    }

    public CompositeByteBuf addComponent(boolean bl, int n2, ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        this.addComponent0(bl, n2, byteBuf);
        this.consolidateIfNeeded();
        return this;
    }

    private int addComponent0(boolean bl, int n2, ByteBuf byteBuf) {
        assert (byteBuf != null);
        boolean bl2 = false;
        try {
            this.checkComponentIndex(n2);
            int n3 = byteBuf.readableBytes();
            CompositeByteBuf$Component compositeByteBuf$Component = new CompositeByteBuf$Component(byteBuf.order(ByteOrder.BIG_ENDIAN).slice());
            if (n2 == this.components.size()) {
                bl2 = this.components.add(compositeByteBuf$Component);
                if (n2 == 0) {
                    compositeByteBuf$Component.endOffset = n3;
                } else {
                    CompositeByteBuf$Component compositeByteBuf$Component2 = this.components.get(n2 - 1);
                    compositeByteBuf$Component.offset = compositeByteBuf$Component2.endOffset;
                    compositeByteBuf$Component.endOffset = compositeByteBuf$Component.offset + n3;
                }
            } else {
                this.components.add(n2, compositeByteBuf$Component);
                bl2 = true;
                if (n3 != 0) {
                    this.updateComponentOffsets(n2);
                }
            }
            if (bl) {
                CompositeByteBuf compositeByteBuf = this;
                compositeByteBuf.writerIndex(((ByteBuf)compositeByteBuf).writerIndex() + byteBuf.readableBytes());
            }
            return n2;
        }
        finally {
            if (!bl2) {
                byteBuf.release();
            }
        }
    }

    public CompositeByteBuf addComponents(int n2, ByteBuf ... byteBufArray) {
        this.addComponents0(false, n2, byteBufArray, 0, byteBufArray.length);
        this.consolidateIfNeeded();
        return this;
    }

    private int addComponents0(boolean bl, int n2, ByteBuf[] byteBufArray, int n3, int n4) {
        int n5;
        ObjectUtil.checkNotNull(byteBufArray, "buffers");
        try {
            ByteBuf byteBuf;
            this.checkComponentIndex(n2);
            while (n3 < n4 && (byteBuf = byteBufArray[n3++]) != null) {
                int n6;
                if ((n2 = this.addComponent0(bl, n2, byteBuf) + 1) <= (n6 = this.components.size())) continue;
                n2 = n6;
            }
            n5 = n2;
        }
        catch (Throwable throwable) {
            while (n3 < n4) {
                ByteBuf byteBuf = byteBufArray[n3];
                if (byteBuf != null) {
                    try {
                        byteBuf.release();
                    }
                    catch (Throwable throwable2) {}
                }
                ++n3;
            }
            throw throwable;
        }
        while (n3 < n4) {
            ByteBuf byteBuf = byteBufArray[n3];
            if (byteBuf != null) {
                try {
                    byteBuf.release();
                }
                catch (Throwable throwable) {}
            }
            ++n3;
        }
        return n5;
    }

    public CompositeByteBuf addComponents(int n2, Iterable<ByteBuf> iterable) {
        this.addComponents0(false, n2, iterable);
        this.consolidateIfNeeded();
        return this;
    }

    private int addComponents0(boolean bl, int n2, Iterable<ByteBuf> object) {
        ArrayList<ByteBuf> arrayList;
        if (object instanceof ByteBuf) {
            return this.addComponent0(bl, n2, (ByteBuf)object);
        }
        ObjectUtil.checkNotNull(object, "buffers");
        if (!(object instanceof Collection)) {
            arrayList = new ArrayList<ByteBuf>();
            try {
                Iterator<ByteBuf> iterator = object.iterator();
                while (iterator.hasNext()) {
                    ByteBuf byteBuf = iterator.next();
                    arrayList.add(byteBuf);
                }
                object = arrayList;
            }
            catch (Throwable throwable) {
                if (object != arrayList) {
                    Iterator<ByteBuf> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (object == null) continue;
                        try {
                            object.release();
                        }
                        catch (Throwable throwable2) {}
                    }
                }
                throw throwable;
            }
        }
        ArrayList<ByteBuf> arrayList2 = arrayList = (ArrayList<ByteBuf>)object;
        return this.addComponents0(bl, n2, arrayList2.toArray(new ByteBuf[arrayList2.size()]), 0, arrayList.size());
    }

    private void consolidateIfNeeded() {
        int n2 = this.components.size();
        if (n2 > this.maxNumComponents) {
            int n3 = this.components.get((int)(n2 - 1)).endOffset;
            ByteBuf byteBuf = this.allocBuffer(n3);
            for (int i2 = 0; i2 < n2; ++i2) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(i2);
                ByteBuf byteBuf2 = compositeByteBuf$Component.buf;
                byteBuf.writeBytes(byteBuf2);
                compositeByteBuf$Component.freeIfNecessary();
            }
            CompositeByteBuf$Component compositeByteBuf$Component = new CompositeByteBuf$Component(byteBuf);
            new CompositeByteBuf$Component(byteBuf).endOffset = compositeByteBuf$Component.length;
            this.components.clear();
            this.components.add(compositeByteBuf$Component);
        }
    }

    private void checkComponentIndex(int n2) {
        this.ensureAccessible();
        if (n2 < 0 || n2 > this.components.size()) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", n2, this.components.size()));
        }
    }

    private void checkComponentIndex(int n2, int n3) {
        this.ensureAccessible();
        if (n2 < 0 || n2 + n3 > this.components.size()) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", n2, n3, this.components.size()));
        }
    }

    private void updateComponentOffsets(int n2) {
        int n3 = this.components.size();
        if (n3 <= n2) {
            return;
        }
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n2);
        if (n2 == 0) {
            compositeByteBuf$Component.offset = 0;
            compositeByteBuf$Component.endOffset = compositeByteBuf$Component.length;
            ++n2;
        }
        while (n2 < n3) {
            compositeByteBuf$Component = this.components.get(n2 - 1);
            CompositeByteBuf$Component compositeByteBuf$Component2 = this.components.get(n2);
            this.components.get(n2).offset = compositeByteBuf$Component.endOffset;
            compositeByteBuf$Component2.endOffset = compositeByteBuf$Component2.offset + compositeByteBuf$Component2.length;
            ++n2;
        }
    }

    public CompositeByteBuf removeComponent(int n2) {
        this.checkComponentIndex(n2);
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.remove(n2);
        compositeByteBuf$Component.freeIfNecessary();
        if (compositeByteBuf$Component.length > 0) {
            this.updateComponentOffsets(n2);
        }
        return this;
    }

    public CompositeByteBuf removeComponents(int n2, int n3) {
        this.checkComponentIndex(n2, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = n2;
        List<CompositeByteBuf$Component> list = this.components.subList(n4, n4 + n3);
        boolean bl = false;
        for (CompositeByteBuf$Component compositeByteBuf$Component : list) {
            if (compositeByteBuf$Component.length > 0) {
                bl = true;
            }
            compositeByteBuf$Component.freeIfNecessary();
        }
        list.clear();
        if (bl) {
            this.updateComponentOffsets(n2);
        }
        return this;
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        this.ensureAccessible();
        if (this.components.isEmpty()) {
            return EMPTY_ITERATOR;
        }
        return new CompositeByteBuf$CompositeByteBufIterator(this, null);
    }

    public List<ByteBuf> decompose(int n2, int n3) {
        int n4;
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return Collections.emptyList();
        }
        int n5 = this.toComponentIndex(n2);
        ArrayList<ByteBuf> arrayList = new ArrayList<ByteBuf>(this.components.size());
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
        ByteBuf byteBuf = compositeByteBuf$Component.buf.duplicate();
        byteBuf.readerIndex(n2 - compositeByteBuf$Component.offset);
        ByteBuf byteBuf2 = byteBuf;
        do {
            if (n3 <= (n4 = byteBuf2.readableBytes())) {
                ByteBuf byteBuf3 = byteBuf2;
                byteBuf3.writerIndex(byteBuf3.readerIndex() + n3);
                arrayList.add(byteBuf2);
                break;
            }
            arrayList.add(byteBuf2);
            byteBuf2 = this.components.get((int)(++n5)).buf.duplicate();
        } while ((n3 -= n4) > 0);
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            arrayList.set(n4, ((ByteBuf)arrayList.get(n4)).slice());
        }
        return arrayList;
    }

    @Override
    public boolean isDirect() {
        int n2 = this.components.size();
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.components.get((int)i2).buf.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasArray() {
        switch (this.components.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.components.get((int)0).buf.hasArray();
            }
        }
        return false;
    }

    @Override
    public byte[] array() {
        switch (this.components.size()) {
            case 0: {
                return EmptyArrays.EMPTY_BYTES;
            }
            case 1: {
                return this.components.get((int)0).buf.array();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        switch (this.components.size()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.components.get((int)0).buf.arrayOffset();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMemoryAddress() {
        switch (this.components.size()) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.hasMemoryAddress();
            }
            case 1: {
                return this.components.get((int)0).buf.hasMemoryAddress();
            }
        }
        return false;
    }

    @Override
    public long memoryAddress() {
        switch (this.components.size()) {
            case 0: {
                return Unpooled.EMPTY_BUFFER.memoryAddress();
            }
            case 1: {
                return this.components.get((int)0).buf.memoryAddress();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        int n2 = this.components.size();
        if (n2 == 0) {
            return 0;
        }
        return this.components.get((int)(n2 - 1)).endOffset;
    }

    @Override
    public CompositeByteBuf capacity(int n2) {
        this.ensureAccessible();
        if (n2 < 0 || n2 > ((ByteBuf)this).maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + n2);
        }
        int n3 = ((ByteBuf)this).capacity();
        if (n2 > n3) {
            n3 = n2 - n3;
            int n4 = this.components.size();
            if (n4 < this.maxNumComponents) {
                ByteBuf byteBuf = this.allocBuffer(n3);
                byteBuf.setIndex(0, n3);
                this.addComponent0(false, this.components.size(), byteBuf);
            } else {
                ByteBuf byteBuf = this.allocBuffer(n3);
                byteBuf.setIndex(0, n3);
                this.addComponent0(false, this.components.size(), byteBuf);
                this.consolidateIfNeeded();
            }
        } else if (n2 < n3) {
            n3 -= n2;
            ListIterator<CompositeByteBuf$Component> listIterator = this.components.listIterator(this.components.size());
            while (listIterator.hasPrevious()) {
                CompositeByteBuf$Component compositeByteBuf$Component = listIterator.previous();
                if (n3 >= compositeByteBuf$Component.length) {
                    n3 -= compositeByteBuf$Component.length;
                    listIterator.remove();
                    continue;
                }
                CompositeByteBuf$Component compositeByteBuf$Component2 = new CompositeByteBuf$Component(compositeByteBuf$Component.buf.slice(0, compositeByteBuf$Component.length - n3));
                new CompositeByteBuf$Component(compositeByteBuf$Component.buf.slice(0, compositeByteBuf$Component.length - n3)).offset = compositeByteBuf$Component.offset;
                compositeByteBuf$Component2.endOffset = compositeByteBuf$Component2.offset + compositeByteBuf$Component2.length;
                listIterator.set(compositeByteBuf$Component2);
                break;
            }
            if (((ByteBuf)this).readerIndex() > n2) {
                int n5 = n2;
                this.setIndex(n5, n5);
            } else if (((ByteBuf)this).writerIndex() > n2) {
                this.writerIndex(n2);
            }
        }
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public int numComponents() {
        return this.components.size();
    }

    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    public int toComponentIndex(int n2) {
        this.checkIndex(n2);
        int n3 = 0;
        int n4 = this.components.size();
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            if (n2 >= compositeByteBuf$Component.endOffset) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < compositeByteBuf$Component.offset) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        throw new Error("should not reach here");
    }

    public int toByteIndex(int n2) {
        this.checkComponentIndex(n2);
        return this.components.get((int)n2).offset;
    }

    @Override
    public byte getByte(int n2) {
        return this._getByte(n2);
    }

    @Override
    protected byte _getByte(int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        return compositeByteBuf$Component.buf.getByte(n2 - compositeByteBuf$Component.offset);
    }

    @Override
    protected short _getShort(int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 2 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getShort(n2 - compositeByteBuf$Component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this._getByte(n2) & 0xFF) << 8 | this._getByte(n2 + 1) & 0xFF);
        }
        return (short)(this._getByte(n2) & 0xFF | (this._getByte(n2 + 1) & 0xFF) << 8);
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 3 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getUnsignedMedium(n2 - compositeByteBuf$Component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 8 | this._getByte(n2 + 2) & 0xFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getByte(n2 + 2) & 0xFF) << 16;
    }

    @Override
    protected int _getInt(int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 4 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getInt(n2 - compositeByteBuf$Component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return (this._getShort(n2) & 0xFFFF) << 16 | this._getShort(n2 + 2) & 0xFFFF;
        }
        return this._getShort(n2) & 0xFFFF | (this._getShort(n2 + 2) & 0xFFFF) << 16;
    }

    @Override
    protected long _getLong(int n2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 8 <= compositeByteBuf$Component.endOffset) {
            return compositeByteBuf$Component.buf.getLong(n2 - compositeByteBuf$Component.offset);
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this._getInt(n2) & 0xFFFFFFFFL) << 32 | (long)this._getInt(n2 + 4) & 0xFFFFFFFFL;
        }
        return (long)this._getInt(n2) & 0xFFFFFFFFL | ((long)this._getInt(n2 + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n4, byteBuf.capacity() - (n2 - n6));
            byteBuf.getBytes(n2 - n6, byArray, n3, n7);
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        try {
            while (n4 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n6 = compositeByteBuf$Component.offset;
                int n7 = Math.min(n4, byteBuf.capacity() - (n2 - n6));
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n7);
                byteBuf.getBytes(n2 - n6, byteBuffer);
                n2 += n7;
                n4 -= n7;
                ++n5;
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            ByteBuf byteBuf2 = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n4, byteBuf2.capacity() - (n2 - n6));
            byteBuf2.getBytes(n2 - n6, byteBuf, n3, n7);
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return this;
    }

    @Override
    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) {
        int n4 = ((ByteBuf)this).nioBufferCount();
        if (n4 == 1) {
            return gatheringByteChannel.write(((ByteBuf)this).internalNioBuffer(n2, n3));
        }
        long l2 = gatheringByteChannel.write(((ByteBuf)this).nioBuffers(n2, n3));
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public CompositeByteBuf getBytes(int n2, OutputStream outputStream, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return this;
        }
        int n4 = this.toComponentIndex(n2);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n4);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n5 = compositeByteBuf$Component.offset;
            int n6 = Math.min(n3, byteBuf.capacity() - (n2 - n5));
            byteBuf.getBytes(n2 - n5, outputStream, n6);
            n2 += n6;
            n3 -= n6;
            ++n4;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setByte(int n2, int n3) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        compositeByteBuf$Component.buf.setByte(n2 - compositeByteBuf$Component.offset, n3);
        return this;
    }

    @Override
    protected void _setByte(int n2, int n3) {
        this.setByte(n2, n3);
    }

    @Override
    public CompositeByteBuf setShort(int n2, int n3) {
        return (CompositeByteBuf)super.setShort(n2, n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 2 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setShort(n2 - compositeByteBuf$Component.offset, n3);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setByte(n2, (byte)(n3 >>> 8));
            this._setByte(n2 + 1, (byte)n3);
            return;
        }
        this._setByte(n2, (byte)n3);
        this._setByte(n2 + 1, (byte)(n3 >>> 8));
    }

    @Override
    public CompositeByteBuf setMedium(int n2, int n3) {
        return (CompositeByteBuf)super.setMedium(n2, n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 3 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setMedium(n2 - compositeByteBuf$Component.offset, n3);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n2, (short)(n3 >> 8));
            this._setByte(n2 + 2, (byte)n3);
            return;
        }
        this._setShort(n2, (short)n3);
        this._setByte(n2 + 2, (byte)(n3 >>> 16));
    }

    @Override
    public CompositeByteBuf setInt(int n2, int n3) {
        return (CompositeByteBuf)super.setInt(n2, n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 4 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setInt(n2 - compositeByteBuf$Component.offset, n3);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setShort(n2, (short)(n3 >>> 16));
            this._setShort(n2 + 2, (short)n3);
            return;
        }
        this._setShort(n2, (short)n3);
        this._setShort(n2 + 2, (short)(n3 >>> 16));
    }

    @Override
    public CompositeByteBuf setLong(int n2, long l2) {
        return (CompositeByteBuf)super.setLong(n2, l2);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        CompositeByteBuf$Component compositeByteBuf$Component = this.findComponent(n2);
        if (n2 + 8 <= compositeByteBuf$Component.endOffset) {
            compositeByteBuf$Component.buf.setLong(n2 - compositeByteBuf$Component.offset, l2);
            return;
        }
        if (((ByteBuf)this).order() == ByteOrder.BIG_ENDIAN) {
            this._setInt(n2, (int)(l2 >>> 32));
            this._setInt(n2 + 4, (int)l2);
            return;
        }
        this._setInt(n2, (int)l2);
        this._setInt(n2 + 4, (int)(l2 >>> 32));
    }

    @Override
    public CompositeByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n4, byteBuf.capacity() - (n2 - n6));
            byteBuf.setBytes(n2 - n6, byArray, n3, n7);
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.limit();
        int n4 = byteBuffer.remaining();
        this.checkIndex(n2, n4);
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        try {
            while (n4 > 0) {
                CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
                ByteBuf byteBuf = compositeByteBuf$Component.buf;
                int n6 = compositeByteBuf$Component.offset;
                int n7 = Math.min(n4, byteBuf.capacity() - (n2 - n6));
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.limit(byteBuffer2.position() + n7);
                byteBuf.setBytes(n2 - n6, byteBuffer);
                n2 += n7;
                n4 -= n7;
                ++n5;
            }
        }
        finally {
            byteBuffer.limit(n3);
        }
        return this;
    }

    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuf byteBuf, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBuf.capacity());
        if (n4 == 0) {
            return this;
        }
        int n5 = this.toComponentIndex(n2);
        while (n4 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            ByteBuf byteBuf2 = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n4, byteBuf2.capacity() - (n2 - n6));
            byteBuf2.setBytes(n2 - n6, byteBuf, n3, n7);
            n2 += n7;
            n3 += n7;
            n4 -= n7;
            ++n5;
        }
        return this;
    }

    @Override
    public int setBytes(int n2, InputStream inputStream, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return inputStream.read(EmptyArrays.EMPTY_BYTES);
        }
        int n4 = this.toComponentIndex(n2);
        int n5 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n4);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n3, byteBuf.capacity() - (n2 - n6));
            if ((n6 = byteBuf.setBytes(n2 - n6, inputStream, n7)) < 0) {
                if (n5 != 0) break;
                return -1;
            }
            if (n6 == n7) {
                n2 += n7;
                n3 -= n7;
                n5 += n7;
                ++n4;
                continue;
            }
            n2 += n6;
            n3 -= n6;
            n5 += n6;
        } while (n3 > 0);
        return n5;
    }

    @Override
    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return scatteringByteChannel.read(EMPTY_NIO_BUFFER);
        }
        int n4 = this.toComponentIndex(n2);
        int n5 = 0;
        do {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n4);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n3, byteBuf.capacity() - (n2 - n6));
            if ((n6 = byteBuf.setBytes(n2 - n6, scatteringByteChannel, n7)) == 0) break;
            if (n6 < 0) {
                if (n5 != 0) break;
                return -1;
            }
            if (n6 == n7) {
                n2 += n7;
                n3 -= n7;
                n5 += n7;
                ++n4;
                continue;
            }
            n2 += n6;
            n3 -= n6;
            n5 += n6;
        } while (n3 > 0);
        return n5;
    }

    @Override
    public ByteBuf copy(int n2, int n3) {
        this.checkIndex(n2, n3);
        ByteBuf byteBuf = Unpooled.buffer(n3);
        if (n3 != 0) {
            this.copyTo(n2, n3, this.toComponentIndex(n2), byteBuf);
        }
        return byteBuf;
    }

    private void copyTo(int n2, int n3, int n4, ByteBuf byteBuf) {
        int n5 = 0;
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n4);
            ByteBuf byteBuf2 = compositeByteBuf$Component.buf;
            int n6 = compositeByteBuf$Component.offset;
            int n7 = Math.min(n3, byteBuf2.capacity() - (n2 - n6));
            byteBuf2.getBytes(n2 - n6, byteBuf, n5, n7);
            n2 += n7;
            n5 += n7;
            n3 -= n7;
            ++n4;
        }
        ByteBuf byteBuf3 = byteBuf;
        byteBuf3.writerIndex(byteBuf3.capacity());
    }

    public ByteBuf component(int n2) {
        return this.internalComponent(n2).duplicate();
    }

    public ByteBuf componentAtOffset(int n2) {
        return this.internalComponentAtOffset(n2).duplicate();
    }

    public ByteBuf internalComponent(int n2) {
        this.checkComponentIndex(n2);
        return this.components.get((int)n2).buf;
    }

    public ByteBuf internalComponentAtOffset(int n2) {
        return this.findComponent((int)n2).buf;
    }

    private CompositeByteBuf$Component findComponent(int n2) {
        this.checkIndex(n2);
        int n3 = 0;
        int n4 = this.components.size();
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n5);
            if (n2 >= compositeByteBuf$Component.endOffset) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < compositeByteBuf$Component.offset) {
                n4 = n5 - 1;
                continue;
            }
            assert (compositeByteBuf$Component.length != 0);
            return compositeByteBuf$Component;
        }
        throw new Error("should not reach here");
    }

    @Override
    public int nioBufferCount() {
        switch (this.components.size()) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.components.get((int)0).buf.nioBufferCount();
            }
        }
        int n2 = 0;
        int n3 = this.components.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(i2);
            n2 += compositeByteBuf$Component.buf.nioBufferCount();
        }
        return n2;
    }

    @Override
    public ByteBuffer internalNioBuffer(int n2, int n3) {
        switch (this.components.size()) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                return this.components.get((int)0).buf.internalNioBuffer(n2, n3);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer nioBuffer(int n2, int n3) {
        Comparable<ByteBuffer> comparable;
        this.checkIndex(n2, n3);
        switch (this.components.size()) {
            case 0: {
                return EMPTY_NIO_BUFFER;
            }
            case 1: {
                comparable = this.components.get((int)0).buf;
                if (((ByteBuf)comparable).nioBufferCount() != 1) break;
                return this.components.get((int)0).buf.nioBuffer(n2, n3);
            }
        }
        comparable = ByteBuffer.allocate(n3).order(((ByteBuf)this).order());
        ByteBuffer[] byteBufferArray = ((ByteBuf)this).nioBuffers(n2, n3);
        ByteBuffer[] byteBufferArray2 = byteBufferArray;
        byteBufferArray2 = byteBufferArray;
        n3 = byteBufferArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            ByteBuffer byteBuffer = byteBufferArray2[i2];
            ((ByteBuffer)comparable).put(byteBuffer);
        }
        ((ByteBuffer)comparable).flip();
        return comparable;
    }

    @Override
    public ByteBuffer[] nioBuffers(int n2, int n3) {
        this.checkIndex(n2, n3);
        if (n3 == 0) {
            return new ByteBuffer[]{EMPTY_NIO_BUFFER};
        }
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(this.components.size());
        int n4 = this.toComponentIndex(n2);
        while (n3 > 0) {
            CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n4);
            ByteBuf byteBuf = compositeByteBuf$Component.buf;
            int n5 = compositeByteBuf$Component.offset;
            int n6 = Math.min(n3, byteBuf.capacity() - (n2 - n5));
            switch (byteBuf.nioBufferCount()) {
                case 0: {
                    throw new UnsupportedOperationException();
                }
                case 1: {
                    arrayList.add(byteBuf.nioBuffer(n2 - n5, n6));
                    break;
                }
                default: {
                    Collections.addAll(arrayList, byteBuf.nioBuffers(n2 - n5, n6));
                }
            }
            n2 += n6;
            n3 -= n6;
            ++n4;
        }
        ArrayList<ByteBuffer> arrayList2 = arrayList;
        return arrayList2.toArray(new ByteBuffer[arrayList2.size()]);
    }

    public CompositeByteBuf consolidate() {
        this.ensureAccessible();
        int n2 = this.numComponents();
        if (n2 <= 1) {
            return this;
        }
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n2 - 1);
        int n3 = compositeByteBuf$Component.endOffset;
        ByteBuf byteBuf = this.allocBuffer(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            CompositeByteBuf$Component compositeByteBuf$Component2 = this.components.get(i2);
            ByteBuf byteBuf2 = compositeByteBuf$Component2.buf;
            byteBuf.writeBytes(byteBuf2);
            compositeByteBuf$Component2.freeIfNecessary();
        }
        this.components.clear();
        this.components.add(new CompositeByteBuf$Component(byteBuf));
        this.updateComponentOffsets(0);
        return this;
    }

    public CompositeByteBuf consolidate(int n2, int n3) {
        this.checkComponentIndex(n2, n3);
        if (n3 <= 1) {
            return this;
        }
        n3 = n2 + n3;
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(n3 - 1);
        int n4 = compositeByteBuf$Component.endOffset - this.components.get((int)n2).offset;
        ByteBuf byteBuf = this.allocBuffer(n4);
        for (int i2 = n2; i2 < n3; ++i2) {
            CompositeByteBuf$Component compositeByteBuf$Component2 = this.components.get(i2);
            ByteBuf byteBuf2 = compositeByteBuf$Component2.buf;
            byteBuf.writeBytes(byteBuf2);
            compositeByteBuf$Component2.freeIfNecessary();
        }
        this.components.subList(n2 + 1, n3).clear();
        this.components.set(n2, new CompositeByteBuf$Component(byteBuf));
        this.updateComponentOffsets(n2);
        return this;
    }

    public CompositeByteBuf discardReadComponents() {
        this.ensureAccessible();
        int n2 = ((ByteBuf)this).readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = ((ByteBuf)this).writerIndex();
        if (n2 == n3 && n3 == ((ByteBuf)this).capacity()) {
            for (CompositeByteBuf$Component compositeByteBuf$Component : this.components) {
                compositeByteBuf$Component.freeIfNecessary();
            }
            this.components.clear();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        int n4 = this.toComponentIndex(n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            this.components.get(i2).freeIfNecessary();
        }
        this.components.subList(0, n4).clear();
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(0);
        n4 = compositeByteBuf$Component.offset;
        this.updateComponentOffsets(0);
        this.setIndex(n2 - n4, n3 - n4);
        this.adjustMarkers(n4);
        return this;
    }

    @Override
    public CompositeByteBuf discardReadBytes() {
        this.ensureAccessible();
        int n2 = ((ByteBuf)this).readerIndex();
        if (n2 == 0) {
            return this;
        }
        int n3 = ((ByteBuf)this).writerIndex();
        if (n2 == n3 && n3 == ((ByteBuf)this).capacity()) {
            for (CompositeByteBuf$Component compositeByteBuf$Component : this.components) {
                compositeByteBuf$Component.freeIfNecessary();
            }
            this.components.clear();
            this.setIndex(0, 0);
            this.adjustMarkers(n2);
            return this;
        }
        int n4 = this.toComponentIndex(n2);
        for (int i2 = 0; i2 < n4; ++i2) {
            this.components.get(i2).freeIfNecessary();
        }
        this.components.subList(0, n4).clear();
        CompositeByteBuf$Component compositeByteBuf$Component = this.components.get(0);
        n4 = n2 - compositeByteBuf$Component.offset;
        if (n4 == compositeByteBuf$Component.length) {
            this.components.remove(0);
        } else {
            CompositeByteBuf$Component compositeByteBuf$Component2 = new CompositeByteBuf$Component(compositeByteBuf$Component.buf.slice(n4, compositeByteBuf$Component.length - n4));
            this.components.set(0, compositeByteBuf$Component2);
        }
        this.updateComponentOffsets(0);
        this.setIndex(0, n3 - n2);
        this.adjustMarkers(n2);
        return this;
    }

    private ByteBuf allocBuffer(int n2) {
        if (this.direct) {
            return ((ByteBuf)this).alloc().directBuffer(n2);
        }
        return ((ByteBuf)this).alloc().heapBuffer(n2);
    }

    @Override
    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        return string + ", components=" + this.components.size() + ')';
    }

    @Override
    public CompositeByteBuf readerIndex(int n2) {
        return (CompositeByteBuf)super.readerIndex(n2);
    }

    @Override
    public CompositeByteBuf writerIndex(int n2) {
        return (CompositeByteBuf)super.writerIndex(n2);
    }

    @Override
    public CompositeByteBuf setIndex(int n2, int n3) {
        return (CompositeByteBuf)super.setIndex(n2, n3);
    }

    @Override
    public CompositeByteBuf clear() {
        return (CompositeByteBuf)super.clear();
    }

    @Override
    public CompositeByteBuf markReaderIndex() {
        return (CompositeByteBuf)super.markReaderIndex();
    }

    @Override
    public CompositeByteBuf resetReaderIndex() {
        return (CompositeByteBuf)super.resetReaderIndex();
    }

    @Override
    public CompositeByteBuf markWriterIndex() {
        return (CompositeByteBuf)super.markWriterIndex();
    }

    @Override
    public CompositeByteBuf resetWriterIndex() {
        return (CompositeByteBuf)super.resetWriterIndex();
    }

    @Override
    public CompositeByteBuf ensureWritable(int n2) {
        return (CompositeByteBuf)super.ensureWritable(n2);
    }

    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuf byteBuf) {
        return (CompositeByteBuf)super.getBytes(n2, byteBuf);
    }

    @Override
    public CompositeByteBuf getBytes(int n2, ByteBuf byteBuf, int n3) {
        return (CompositeByteBuf)super.getBytes(n2, byteBuf, n3);
    }

    @Override
    public CompositeByteBuf getBytes(int n2, byte[] byArray) {
        return (CompositeByteBuf)super.getBytes(n2, byArray);
    }

    @Override
    public CompositeByteBuf setBoolean(int n2, boolean bl) {
        return (CompositeByteBuf)super.setBoolean(n2, bl);
    }

    @Override
    public CompositeByteBuf setChar(int n2, int n3) {
        return (CompositeByteBuf)super.setChar(n2, n3);
    }

    @Override
    public CompositeByteBuf setFloat(int n2, float f2) {
        return (CompositeByteBuf)super.setFloat(n2, f2);
    }

    @Override
    public CompositeByteBuf setDouble(int n2, double d2) {
        return (CompositeByteBuf)super.setDouble(n2, d2);
    }

    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuf byteBuf) {
        return (CompositeByteBuf)super.setBytes(n2, byteBuf);
    }

    @Override
    public CompositeByteBuf setBytes(int n2, ByteBuf byteBuf, int n3) {
        return (CompositeByteBuf)super.setBytes(n2, byteBuf, n3);
    }

    @Override
    public CompositeByteBuf setBytes(int n2, byte[] byArray) {
        return (CompositeByteBuf)super.setBytes(n2, byArray);
    }

    @Override
    public CompositeByteBuf setZero(int n2, int n3) {
        return (CompositeByteBuf)super.setZero(n2, n3);
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf) {
        return (CompositeByteBuf)super.readBytes(byteBuf);
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n2) {
        return (CompositeByteBuf)super.readBytes(byteBuf, n2);
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuf byteBuf, int n2, int n3) {
        return (CompositeByteBuf)super.readBytes(byteBuf, n2, n3);
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray) {
        return (CompositeByteBuf)super.readBytes(byArray);
    }

    @Override
    public CompositeByteBuf readBytes(byte[] byArray, int n2, int n3) {
        return (CompositeByteBuf)super.readBytes(byArray, n2, n3);
    }

    @Override
    public CompositeByteBuf readBytes(ByteBuffer byteBuffer) {
        return (CompositeByteBuf)super.readBytes(byteBuffer);
    }

    @Override
    public CompositeByteBuf readBytes(OutputStream outputStream, int n2) {
        return (CompositeByteBuf)super.readBytes(outputStream, n2);
    }

    @Override
    public CompositeByteBuf skipBytes(int n2) {
        return (CompositeByteBuf)super.skipBytes(n2);
    }

    @Override
    public CompositeByteBuf writeBoolean(boolean bl) {
        return (CompositeByteBuf)super.writeBoolean(bl);
    }

    @Override
    public CompositeByteBuf writeByte(int n2) {
        return (CompositeByteBuf)super.writeByte(n2);
    }

    @Override
    public CompositeByteBuf writeShort(int n2) {
        return (CompositeByteBuf)super.writeShort(n2);
    }

    @Override
    public CompositeByteBuf writeMedium(int n2) {
        return (CompositeByteBuf)super.writeMedium(n2);
    }

    @Override
    public CompositeByteBuf writeInt(int n2) {
        return (CompositeByteBuf)super.writeInt(n2);
    }

    @Override
    public CompositeByteBuf writeLong(long l2) {
        return (CompositeByteBuf)super.writeLong(l2);
    }

    @Override
    public CompositeByteBuf writeChar(int n2) {
        return (CompositeByteBuf)super.writeChar(n2);
    }

    @Override
    public CompositeByteBuf writeFloat(float f2) {
        return (CompositeByteBuf)super.writeFloat(f2);
    }

    @Override
    public CompositeByteBuf writeDouble(double d2) {
        return (CompositeByteBuf)super.writeDouble(d2);
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf) {
        return (CompositeByteBuf)super.writeBytes(byteBuf);
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n2) {
        return (CompositeByteBuf)super.writeBytes(byteBuf, n2);
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuf byteBuf, int n2, int n3) {
        return (CompositeByteBuf)super.writeBytes(byteBuf, n2, n3);
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray) {
        return (CompositeByteBuf)super.writeBytes(byArray);
    }

    @Override
    public CompositeByteBuf writeBytes(byte[] byArray, int n2, int n3) {
        return (CompositeByteBuf)super.writeBytes(byArray, n2, n3);
    }

    @Override
    public CompositeByteBuf writeBytes(ByteBuffer byteBuffer) {
        return (CompositeByteBuf)super.writeBytes(byteBuffer);
    }

    @Override
    public CompositeByteBuf writeZero(int n2) {
        return (CompositeByteBuf)super.writeZero(n2);
    }

    @Override
    public CompositeByteBuf retain(int n2) {
        return (CompositeByteBuf)super.retain(n2);
    }

    @Override
    public CompositeByteBuf retain() {
        return (CompositeByteBuf)super.retain();
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        CompositeByteBuf compositeByteBuf = this;
        return ((ByteBuf)compositeByteBuf).nioBuffers(((ByteBuf)compositeByteBuf).readerIndex(), ((ByteBuf)this).readableBytes());
    }

    @Override
    public CompositeByteBuf discardSomeReadBytes() {
        return this.discardReadComponents();
    }

    @Override
    protected void deallocate() {
        if (this.freed) {
            return;
        }
        this.freed = true;
        int n2 = this.components.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.components.get(i2).freeIfNecessary();
        }
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    static /* synthetic */ List access$100(CompositeByteBuf compositeByteBuf) {
        return compositeByteBuf.components;
    }
}

